/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.scorecard;

import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.scorecard.Attribute;
import org.dmg.pmml.scorecard.Characteristics;
import org.dmg.pmml.scorecard.ComplexPartialScore;
import org.dmg.pmml.scorecard.PMMLAttributes;
import org.dmg.pmml.scorecard.PMMLElements;
import org.dmg.pmml.scorecard.Scorecard;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.MissingElementException;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.PMMLUtil;

public abstract class ScorecardEvaluator
extends ModelEvaluator<Scorecard> {
    protected ScorecardEvaluator() {
    }

    public ScorecardEvaluator(PMML pmml) {
        this(pmml, PMMLUtil.findModel(pmml, Scorecard.class));
    }

    public ScorecardEvaluator(PMML pmml, Scorecard scorecard) {
        super(pmml, scorecard);
        Characteristics characteristics = scorecard.getCharacteristics();
        if (characteristics == null) {
            throw new MissingElementException((PMMLObject)scorecard, PMMLElements.SCORECARD_CHARACTERISTICS);
        }
        if (!characteristics.hasCharacteristics()) {
            throw new MissingElementException((PMMLObject)characteristics, PMMLElements.CHARACTERISTICS_CHARACTERISTICS);
        }
    }

    @Override
    public String getSummary() {
        return "Scorecard";
    }

    protected static Number evaluatePartialScore(Attribute attribute, EvaluationContext context) {
        ComplexPartialScore complexPartialScore = attribute.getComplexPartialScore();
        if (complexPartialScore != null) {
            FieldValue computedValue = ExpressionUtil.evaluateExpressionContainer(complexPartialScore, context);
            if (FieldValueUtil.isMissing(computedValue)) {
                return null;
            }
            return computedValue.asNumber();
        }
        Number partialScore = attribute.getPartialScore();
        if (partialScore == null) {
            throw new MissingAttributeException((PMMLObject)attribute, PMMLAttributes.ATTRIBUTE_PARTIALSCORE);
        }
        return partialScore;
    }
}

