/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.scorecard;

import java.util.List;
import java.util.Objects;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.HasReasonCodeRanking;
import org.jpmml.evaluator.Regression;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.evaluator.scorecard.HasPartialScores;
import org.jpmml.evaluator.scorecard.PartialScore;
import org.jpmml.model.ToStringHelper;

public class ReasonCodeRanking<V extends Number>
extends Regression<V>
implements HasReasonCodeRanking,
HasPartialScores {
    private List<PartialScore> partialScores = null;
    private ValueMap<String, V> reasonCodePoints = null;

    ReasonCodeRanking(Value<V> value, List<PartialScore> partialScores, ValueMap<String, V> reasonCodePoints) {
        super(value);
        this.setPartialScores(Objects.requireNonNull(partialScores));
        this.setReasonCodePoints(Objects.requireNonNull(reasonCodePoints));
    }

    @Override
    protected ToStringHelper toStringHelper() {
        ValueMap<String, V> reasonCodePoints = this.getReasonCodePoints();
        ToStringHelper helper = super.toStringHelper().add(Classification.Type.VOTE.entryKey(), reasonCodePoints.entrySet()).add("reasonCodeRanking", this.getReasonCodeRanking());
        return helper;
    }

    @Override
    public List<String> getReasonCodeRanking() {
        ValueMap<String, V> reasonCodePoints = this.getReasonCodePoints();
        return Classification.entryKeys(Classification.getWinnerList(Classification.Type.VOTE, reasonCodePoints.entrySet()));
    }

    @Override
    public List<PartialScore> getPartialScores() {
        return this.partialScores;
    }

    private void setPartialScores(List<PartialScore> partialScores) {
        this.partialScores = partialScores;
    }

    public ValueMap<String, V> getReasonCodePoints() {
        return this.reasonCodePoints;
    }

    private void setReasonCodePoints(ValueMap<String, V> reasonCodePoints) {
        this.reasonCodePoints = reasonCodePoints;
    }
}

