/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.io.Serializable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ResultFeature;
import org.jpmml.evaluator.Configuration;
import org.jpmml.evaluator.ConfigurationBuilder;
import org.jpmml.evaluator.EvaluatorBuilder;
import org.jpmml.evaluator.HasGroupFields;
import org.jpmml.evaluator.InputField;
import org.jpmml.evaluator.InputMapper;
import org.jpmml.evaluator.InvalidElementException;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.ModelEvaluatorFactory;
import org.jpmml.evaluator.OutputField;
import org.jpmml.evaluator.OutputFilter;
import org.jpmml.evaluator.PMMLUtil;
import org.jpmml.evaluator.ResultMapper;
import org.jpmml.evaluator.SymbolTable;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.ValueFactoryFactory;

public class ModelEvaluatorBuilder
implements EvaluatorBuilder,
Serializable {
    private PMML pmml = null;
    private Model model = null;
    private ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
    private Set<ResultFeature> extraResultFeatures = EnumSet.noneOf(ResultFeature.class);
    private InputMapper inputMapper = null;
    private ResultMapper resultMapper = null;

    protected ModelEvaluatorBuilder() {
    }

    public ModelEvaluatorBuilder(PMML pmml) {
        this(pmml, (String)null);
    }

    public ModelEvaluatorBuilder(PMML pmml, String modelName) {
        this.setPMML(Objects.requireNonNull(pmml));
        this.setModel(PMMLUtil.findModel(pmml, modelName));
    }

    public ModelEvaluatorBuilder(PMML pmml, Model model) {
        this.setPMML(Objects.requireNonNull(pmml));
        this.setModel(Objects.requireNonNull(model));
    }

    @Override
    public ModelEvaluatorBuilder clone() {
        ModelEvaluatorBuilder modelEvaluatorBuilder;
        try {
            modelEvaluatorBuilder = (ModelEvaluatorBuilder)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw (InternalError)new InternalError().initCause(cnse);
        }
        modelEvaluatorBuilder.configurationBuilder = modelEvaluatorBuilder.configurationBuilder.clone();
        return modelEvaluatorBuilder;
    }

    @Override
    public ModelEvaluator<?> build() {
        PMML pmml = this.getPMML();
        Model model = this.getModel();
        if (pmml == null || model == null) {
            throw new IllegalStateException();
        }
        ConfigurationBuilder configurationBuilder = this.getConfigurationBuilder();
        Configuration configuration = configurationBuilder.build();
        ModelEvaluatorFactory modelEvaluatorFactory = configuration.getModelEvaluatorFactory();
        Set<ResultFeature> extraResultFeatures = this.getExtraResultFeatures();
        ModelEvaluator<?> modelEvaluator = modelEvaluatorFactory.newModelEvaluator(pmml, model, extraResultFeatures);
        modelEvaluator.configure(configuration);
        InputMapper inputMapper = this.getInputMapper();
        ResultMapper resultMapper = this.getResultMapper();
        modelEvaluator.setInputMapper(inputMapper);
        modelEvaluator.setResultMapper(resultMapper);
        this.checkSchema(modelEvaluator);
        return modelEvaluator;
    }

    protected void checkSchema(ModelEvaluator<?> modelEvaluator) {
        Object model = modelEvaluator.getModel();
        MiningSchema miningSchema = model.getMiningSchema();
        List<InputField> inputFields = modelEvaluator.getInputFields();
        List<Object> groupFields = Collections.emptyList();
        if (modelEvaluator instanceof HasGroupFields) {
            HasGroupFields hasGroupFields = (HasGroupFields)((Object)modelEvaluator);
            groupFields = hasGroupFields.getGroupFields();
        }
        if (inputFields.size() + groupFields.size() > 1000) {
            throw new InvalidElementException("Model has too many input fields", (PMMLObject)miningSchema);
        }
        List<TargetField> targetFields = modelEvaluator.getTargetFields();
        List<OutputField> outputFields = modelEvaluator.getOutputFields();
        if (targetFields.size() + outputFields.size() < 1) {
            throw new InvalidElementException("Model does not have any target or output fields", (PMMLObject)miningSchema);
        }
    }

    public PMML getPMML() {
        return this.pmml;
    }

    protected ModelEvaluatorBuilder setPMML(PMML pmml) {
        this.pmml = pmml;
        return this;
    }

    public Model getModel() {
        return this.model;
    }

    protected ModelEvaluatorBuilder setModel(Model model) {
        this.model = model;
        return this;
    }

    public ConfigurationBuilder getConfigurationBuilder() {
        return this.configurationBuilder;
    }

    public ModelEvaluatorFactory getModelEvaluatorFactory() {
        ConfigurationBuilder configurationBuilder = this.getConfigurationBuilder();
        return configurationBuilder.getModelEvaluatorFactory();
    }

    public ModelEvaluatorBuilder setModelEvaluatorFactory(ModelEvaluatorFactory modelEvaluatorFactory) {
        ConfigurationBuilder configurationBuilder = this.getConfigurationBuilder();
        configurationBuilder.setModelEvaluatorFactory(modelEvaluatorFactory);
        return this;
    }

    public ValueFactoryFactory getValueFactoryFactory() {
        ConfigurationBuilder configurationBuilder = this.getConfigurationBuilder();
        return configurationBuilder.getValueFactoryFactory();
    }

    public ModelEvaluatorBuilder setValueFactoryFactory(ValueFactoryFactory valueFactoryFactory) {
        ConfigurationBuilder configurationBuilder = this.getConfigurationBuilder();
        configurationBuilder.setValueFactoryFactory(valueFactoryFactory);
        return this;
    }

    public OutputFilter getOutputFilter() {
        ConfigurationBuilder configurationBuilder = this.getConfigurationBuilder();
        return configurationBuilder.getOutputFilter();
    }

    public ModelEvaluatorBuilder setOutputFilter(OutputFilter outputFilter) {
        ConfigurationBuilder configurationBuilder = this.getConfigurationBuilder();
        configurationBuilder.setOutputFilter(outputFilter);
        return this;
    }

    public SymbolTable<FieldName> getDerivedFieldGuard() {
        ConfigurationBuilder configurationBuilder = this.getConfigurationBuilder();
        return configurationBuilder.getDerivedFieldGuard();
    }

    public ModelEvaluatorBuilder setDerivedFieldGuard(SymbolTable<FieldName> derivedFieldGuard) {
        ConfigurationBuilder configurationBuilder = this.getConfigurationBuilder();
        configurationBuilder.setDerivedFieldGuard(derivedFieldGuard);
        return this;
    }

    public SymbolTable<String> getFunctionGuard() {
        ConfigurationBuilder configurationBuilder = this.getConfigurationBuilder();
        return configurationBuilder.getFunctionGuard();
    }

    public ModelEvaluatorBuilder setFunctionGuard(SymbolTable<String> functionGuard) {
        ConfigurationBuilder configurationBuilder = this.getConfigurationBuilder();
        configurationBuilder.setFunctionGuard(functionGuard);
        return this;
    }

    public Set<ResultFeature> getExtraResultFeatures() {
        return this.extraResultFeatures;
    }

    public ModelEvaluatorBuilder setExtraResultFeatures(Set<ResultFeature> extraResultFeatures) {
        this.extraResultFeatures = extraResultFeatures;
        return this;
    }

    public InputMapper getInputMapper() {
        return this.inputMapper;
    }

    public ModelEvaluatorBuilder setInputMapper(InputMapper inputMapper) {
        this.inputMapper = inputMapper;
        return this;
    }

    public ResultMapper getResultMapper() {
        return this.resultMapper;
    }

    public ModelEvaluatorBuilder setResultMapper(ResultMapper resultMapper) {
        this.resultMapper = resultMapper;
        return this;
    }
}

