schema = {u'copyFields': [{u'dest': u'text', u'source': u'author'},
                 {u'dest': u'text', u'source': u'cat'},
                 {u'dest': u'text', u'source': u'content'},
                 {u'dest': u'text', u'source': u'content_type'},
                 {u'dest': u'text', u'source': u'description'},
                 {u'dest': u'text', u'source': u'features'},
                 {u'dest': u'text', u'source': u'includes'},
                 {u'dest': u'text', u'source': u'keywords'},
                 {u'dest': u'manu_exact', u'source': u'manu'},
                 {u'dest': u'text', u'source': u'manu'},
                 {u'dest': u'text', u'source': u'name'},
                 {u'dest': u'text', u'source': u'resourcename'},
                 {u'dest': u'text', u'source': u'title'},
                 {u'dest': u'text', u'source': u'url'},
                 {u'dest': u'price_c', u'source': u'price'},
                 {u'dest': u'author_s', u'source': u'author'}],
 u'dynamicFields': [{u'indexed': True,
                     u'name': u'*_coordinate',
                     u'stored': False,
                     u'type': u'tdouble'},
                    {u'multiValued': True,
                     u'name': u'ignored_*',
                     u'type': u'ignored'},
                    {u'name': u'random_*', u'type': u'random'},
                    {u'indexed': True,
                     u'multiValued': True,
                     u'name': u'attr_*',
                     u'stored': True,
                     u'type': u'text_general'},
                    {u'indexed': True,
                     u'multiValued': True,
                     u'name': u'*_txt',
                     u'stored': True,
                     u'type': u'text_general'},
                    {u'indexed': True,
                     u'multiValued': True,
                     u'name': u'*_dts',
                     u'stored': True,
                     u'type': u'date'},
                    {u'indexed': True,
                     u'name': u'*_tdt',
                     u'stored': True,
                     u'type': u'tdate'},
                    {u'indexed': True,
                     u'multiValued': True,
                     u'name': u'*_is',
                     u'stored': True,
                     u'type': u'int'},
                    {u'indexed': True,
                     u'multiValued': True,
                     u'name': u'*_ss',
                     u'stored': True,
                     u'type': u'string'},
                    {u'indexed': True,
                     u'multiValued': True,
                     u'name': u'*_ls',
                     u'stored': True,
                     u'type': u'long'},
                    {u'indexed': True,
                     u'multiValued': True,
                     u'name': u'*_en',
                     u'stored': True,
                     u'type': u'text_en'},
                    {u'indexed': True,
                     u'multiValued': True,
                     u'name': u'*_bs',
                     u'stored': True,
                     u'type': u'boolean'},
                    {u'indexed': True,
                     u'multiValued': True,
                     u'name': u'*_fs',
                     u'stored': True,
                     u'type': u'float'},
                    {u'indexed': True,
                     u'multiValued': True,
                     u'name': u'*_ds',
                     u'stored': True,
                     u'type': u'double'},
                    {u'indexed': True,
                     u'name': u'*_dt',
                     u'stored': True,
                     u'type': u'date'},
                    {u'indexed': True,
                     u'name': u'*_ti',
                     u'stored': True,
                     u'type': u'tint'},
                    {u'indexed': True,
                     u'name': u'*_tl',
                     u'stored': True,
                     u'type': u'tlong'},
                    {u'indexed': True,
                     u'name': u'*_tf',
                     u'stored': True,
                     u'type': u'tfloat'},
                    {u'indexed': True,
                     u'name': u'*_td',
                     u'stored': True,
                     u'type': u'tdouble'},
                    {u'indexed': True,
                     u'name': u'*_i',
                     u'stored': True,
                     u'type': u'int'},
                    {u'indexed': True,
                     u'name': u'*_s',
                     u'stored': True,
                     u'type': u'string'},
                    {u'indexed': True,
                     u'name': u'*_l',
                     u'stored': True,
                     u'type': u'long'},
                    {u'indexed': True,
                     u'name': u'*_t',
                     u'stored': True,
                     u'type': u'text_general'},
                    {u'indexed': True,
                     u'name': u'*_b',
                     u'stored': True,
                     u'type': u'boolean'},
                    {u'indexed': True,
                     u'name': u'*_f',
                     u'stored': True,
                     u'type': u'float'},
                    {u'indexed': True,
                     u'name': u'*_d',
                     u'stored': True,
                     u'type': u'double'},
                    {u'indexed': True,
                     u'name': u'*_p',
                     u'stored': True,
                     u'type': u'location'},
                    {u'indexed': True,
                     u'name': u'*_c',
                     u'stored': True,
                     u'type': u'currency'}],
 u'fieldTypes': [{u'class': u'solr.TrieDoubleField',
                  u'docValues': True,
                  u'name': u'_bbox_coord',
                  u'precisionStep': u'8',
                  u'stored': False},
                 {u'analyzer': {u'filters': [{u'class': u'solr.LowerCaseFilterFactory'},
                                             {u'class': u'solr.TrimFilterFactory'},
                                             {u'class': u'solr.PatternReplaceFilterFactory',
                                              u'pattern': u'([^a-z])',
                                              u'replace': u'all',
                                              u'replacement': u''}],
                                u'tokenizer': {u'class': u'solr.KeywordTokenizerFactory'}},
                  u'class': u'solr.TextField',
                  u'name': u'alphaOnlySort',
                  u'omitNorms': True,
                  u'sortMissingLast': True},
                 {u'class': u'solr.TextField',
                  u'indexAnalyzer': {u'tokenizer': {u'class': u'solr.KeywordTokenizerFactory'}},
                  u'name': u'ancestor_path',
                  u'queryAnalyzer': {u'tokenizer': {u'class': u'solr.PathHierarchyTokenizerFactory',
                                                    u'delimiter': u'/'}}},
                 {u'class': u'solr.BBoxField',
                  u'geo': u'true',
                  u'name': u'bbox',
                  u'numberType': u'_bbox_coord',
                  u'units': u'degrees'},
                 {u'class': u'solr.BinaryField', u'name': u'binary'},
                 {u'class': u'solr.BoolField',
                  u'name': u'boolean',
                  u'sortMissingLast': True},
                 {u'class': u'solr.CurrencyField',
                  u'currencyConfig': u'currency.xml',
                  u'defaultCurrency': u'USD',
                  u'name': u'currency',
                  u'precisionStep': u'8'},
                 {u'class': u'solr.TrieDateField',
                  u'name': u'date',
                  u'positionIncrementGap': u'0',
                  u'precisionStep': u'0'},
                 {u'class': u'solr.TextField',
                  u'indexAnalyzer': {u'tokenizer': {u'class': u'solr.PathHierarchyTokenizerFactory',
                                                    u'delimiter': u'/'}},
                  u'name': u'descendent_path',
                  u'queryAnalyzer': {u'tokenizer': {u'class': u'solr.KeywordTokenizerFactory'}}},
                 {u'class': u'solr.TrieDoubleField',
                  u'name': u'double',
                  u'positionIncrementGap': u'0',
                  u'precisionStep': u'0'},
                 {u'class': u'solr.TrieFloatField',
                  u'name': u'float',
                  u'positionIncrementGap': u'0',
                  u'precisionStep': u'0'},
                 {u'class': u'solr.StrField',
                  u'indexed': False,
                  u'multiValued': True,
                  u'name': u'ignored',
                  u'stored': False},
                 {u'class': u'solr.TrieIntField',
                  u'name': u'int',
                  u'positionIncrementGap': u'0',
                  u'precisionStep': u'0'},
                 {u'class': u'solr.LatLonType',
                  u'name': u'location',
                  u'subFieldSuffix': u'_coordinate'},
                 {u'class': u'solr.SpatialRecursivePrefixTreeFieldType',
                  u'distErrPct': u'0.025',
                  u'geo': u'true',
                  u'maxDistErr': u'0.000009',
                  u'name': u'location_rpt',
                  u'units': u'degrees'},
                 {u'class': u'solr.TrieLongField',
                  u'name': u'long',
                  u'positionIncrementGap': u'0',
                  u'precisionStep': u'0'},
                 {u'analyzer': {u'filters': [{u'class': u'solr.LowerCaseFilterFactory'}],
                                u'tokenizer': {u'class': u'solr.KeywordTokenizerFactory'}},
                  u'class': u'solr.TextField',
                  u'name': u'lowercase',
                  u'positionIncrementGap': u'100'},
                 {u'analyzer': {u'filters': [{u'class': u'solr.ManagedStopFilterFactory',
                                              u'managed': u'english'},
                                             {u'class': u'solr.ManagedSynonymFilterFactory',
                                              u'managed': u'english'}],
                                u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}},
                  u'class': u'solr.TextField',
                  u'name': u'managed_en',
                  u'positionIncrementGap': u'100'},
                 {u'analyzer': {u'filters': [{u'class': u'solr.DelimitedPayloadTokenFilterFactory',
                                              u'encoder': u'float'}],
                                u'tokenizer': {u'class': u'solr.WhitespaceTokenizerFactory'}},
                  u'class': u'solr.TextField',
                  u'indexed': True,
                  u'name': u'payloads',
                  u'stored': False},
                 {u'analyzer': {u'filters': [{u'class': u'solr.DoubleMetaphoneFilterFactory',
                                              u'inject': u'false'}],
                                u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}},
                  u'class': u'solr.TextField',
                  u'indexed': True,
                  u'name': u'phonetic',
                  u'stored': False},
                 {u'class': u'solr.PointType',
                  u'dimension': u'2',
                  u'name': u'point',
                  u'subFieldSuffix': u'_d'},
                 {u'class': u'solr.RandomSortField',
                  u'indexed': True,
                  u'name': u'random'},
                 {u'class': u'solr.StrField',
                  u'name': u'string',
                  u'sortMissingLast': True},
                 {u'class': u'solr.TrieDateField',
                  u'name': u'tdate',
                  u'positionIncrementGap': u'0',
                  u'precisionStep': u'6'},
                 {u'class': u'solr.TrieDoubleField',
                  u'name': u'tdouble',
                  u'positionIncrementGap': u'0',
                  u'precisionStep': u'8'},
                 {u'analyzer': {u'filters': [{u'class': u'solr.LowerCaseFilterFactory'},
                                             {u'class': u'solr.StopFilterFactory',
                                              u'ignoreCase': u'true',
                                              u'words': u'lang/stopwords_ar.txt'},
                                             {u'class': u'solr.ArabicNormalizationFilterFactory'},
                                             {u'class': u'solr.ArabicStemFilterFactory'}],
                                u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}},
                  u'class': u'solr.TextField',
                  u'name': u'text_ar',
                  u'positionIncrementGap': u'100'},
                 {u'analyzer': {u'filters': [{u'class': u'solr.LowerCaseFilterFactory'},
                                             {u'class': u'solr.StopFilterFactory',
                                              u'ignoreCase': u'true',
                                              u'words': u'lang/stopwords_bg.txt'},
                                             {u'class': u'solr.BulgarianStemFilterFactory'}],
                                u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}},
                  u'class': u'solr.TextField',
                  u'name': u'text_bg',
                  u'positionIncrementGap': u'100'},
                 {u'analyzer': {u'filters': [{u'articles': u'lang/contractions_ca.txt',
                                              u'class': u'solr.ElisionFilterFactory',
                                              u'ignoreCase': u'true'},
                                             {u'class': u'solr.LowerCaseFilterFactory'},
                                             {u'class': u'solr.StopFilterFactory',
                                              u'ignoreCase': u'true',
                                              u'words': u'lang/stopwords_ca.txt'},
                                             {u'class': u'solr.SnowballPorterFilterFactory',
                                              u'language': u'Catalan'}],
                                u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}},
                  u'class': u'solr.TextField',
                  u'name': u'text_ca',
                  u'positionIncrementGap': u'100'},
                 {u'analyzer': {u'filters': [{u'class': u'solr.CJKWidthFilterFactory'},
                                             {u'class': u'solr.LowerCaseFilterFactory'},
                                             {u'class': u'solr.CJKBigramFilterFactory'}],
                                u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}},
                  u'class': u'solr.TextField',
                  u'name': u'text_cjk',
                  u'positionIncrementGap': u'100'},
                 {u'analyzer': {u'filters': [{u'class': u'solr.SoraniNormalizationFilterFactory'},
                                             {u'class': u'solr.LowerCaseFilterFactory'},
                                             {u'class': u'solr.StopFilterFactory',
                                              u'ignoreCase': u'true',
                                              u'words': u'lang/stopwords_ckb.txt'},
                                             {u'class': u'solr.SoraniStemFilterFactory'}],
                                u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}},
                  u'class': u'solr.TextField',
                  u'name': u'text_ckb',
                  u'positionIncrementGap': u'100'},
                 {u'analyzer': {u'filters': [{u'class': u'solr.LowerCaseFilterFactory'},
                                             {u'class': u'solr.StopFilterFactory',
                                              u'ignoreCase': u'true',
                                              u'words': u'lang/stopwords_cz.txt'},
                                             {u'class': u'solr.CzechStemFilterFactory'}],
                                u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}},
                  u'class': u'solr.TextField',
                  u'name': u'text_cz',
                  u'positionIncrementGap': u'100'},
                 {u'analyzer': {u'filters': [{u'class': u'solr.LowerCaseFilterFactory'},
                                             {u'class': u'solr.StopFilterFactory',
                                              u'format': u'snowball',
                                              u'ignoreCase': u'true',
                                              u'words': u'lang/stopwords_da.txt'},
                                             {u'class': u'solr.SnowballPorterFilterFactory',
                                              u'language': u'Danish'}],
                                u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}},
                  u'class': u'solr.TextField',
                  u'name': u'text_da',
                  u'positionIncrementGap': u'100'},
                 {u'analyzer': {u'filters': [{u'class': u'solr.LowerCaseFilterFactory'},
                                             {u'class': u'solr.StopFilterFactory',
                                              u'format': u'snowball',
                                              u'ignoreCase': u'true',
                                              u'words': u'lang/stopwords_de.txt'},
                                             {u'class': u'solr.GermanNormalizationFilterFactory'},
                                             {u'class': u'solr.GermanLightStemFilterFactory'}],
                                u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}},
                  u'class': u'solr.TextField',
                  u'name': u'text_de',
                  u'positionIncrementGap': u'100'},
                 {u'analyzer': {u'filters': [{u'class': u'solr.GreekLowerCaseFilterFactory'},
                                             {u'class': u'solr.StopFilterFactory',
                                              u'ignoreCase': u'false',
                                              u'words': u'lang/stopwords_el.txt'},
                                             {u'class': u'solr.GreekStemFilterFactory'}],
                                u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}},
                  u'class': u'solr.TextField',
                  u'name': u'text_el',
                  u'positionIncrementGap': u'100'},
                 {u'class': u'solr.TextField',
                  u'indexAnalyzer': {u'filters': [{u'class': u'solr.StopFilterFactory',
                                                   u'ignoreCase': u'true',
                                                   u'words': u'lang/stopwords_en.txt'},
                                                  {u'class': u'solr.LowerCaseFilterFactory'},
                                                  {u'class': u'solr.EnglishPossessiveFilterFactory'},
                                                  {u'class': u'solr.KeywordMarkerFilterFactory',
                                                   u'protected': u'protwords.txt'},
                                                  {u'class': u'solr.PorterStemFilterFactory'}],
                                     u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}},
                  u'name': u'text_en',
                  u'positionIncrementGap': u'100',
                  u'queryAnalyzer': {u'filters': [{u'class': u'solr.SynonymFilterFactory',
                                                   u'expand': u'true',
                                                   u'ignoreCase': u'true',
                                                   u'synonyms': u'synonyms.txt'},
                                                  {u'class': u'solr.StopFilterFactory',
                                                   u'ignoreCase': u'true',
                                                   u'words': u'lang/stopwords_en.txt'},
                                                  {u'class': u'solr.LowerCaseFilterFactory'},
                                                  {u'class': u'solr.EnglishPossessiveFilterFactory'},
                                                  {u'class': u'solr.KeywordMarkerFilterFactory',
                                                   u'protected': u'protwords.txt'},
                                                  {u'class': u'solr.PorterStemFilterFactory'}],
                                     u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}}},
                 {u'autoGeneratePhraseQueries': u'true',
                  u'class': u'solr.TextField',
                  u'indexAnalyzer': {u'filters': [{u'class': u'solr.StopFilterFactory',
                                                   u'ignoreCase': u'true',
                                                   u'words': u'lang/stopwords_en.txt'},
                                                  {u'catenateAll': u'0',
                                                   u'catenateNumbers': u'1',
                                                   u'catenateWords': u'1',
                                                   u'class': u'solr.WordDelimiterFilterFactory',
                                                   u'generateNumberParts': u'1',
                                                   u'generateWordParts': u'1',
                                                   u'splitOnCaseChange': u'1'},
                                                  {u'class': u'solr.LowerCaseFilterFactory'},
                                                  {u'class': u'solr.KeywordMarkerFilterFactory',
                                                   u'protected': u'protwords.txt'},
                                                  {u'class': u'solr.PorterStemFilterFactory'}],
                                     u'tokenizer': {u'class': u'solr.WhitespaceTokenizerFactory'}},
                  u'name': u'text_en_splitting',
                  u'positionIncrementGap': u'100',
                  u'queryAnalyzer': {u'filters': [{u'class': u'solr.SynonymFilterFactory',
                                                   u'expand': u'true',
                                                   u'ignoreCase': u'true',
                                                   u'synonyms': u'synonyms.txt'},
                                                  {u'class': u'solr.StopFilterFactory',
                                                   u'ignoreCase': u'true',
                                                   u'words': u'lang/stopwords_en.txt'},
                                                  {u'catenateAll': u'0',
                                                   u'catenateNumbers': u'0',
                                                   u'catenateWords': u'0',
                                                   u'class': u'solr.WordDelimiterFilterFactory',
                                                   u'generateNumberParts': u'1',
                                                   u'generateWordParts': u'1',
                                                   u'splitOnCaseChange': u'1'},
                                                  {u'class': u'solr.LowerCaseFilterFactory'},
                                                  {u'class': u'solr.KeywordMarkerFilterFactory',
                                                   u'protected': u'protwords.txt'},
                                                  {u'class': u'solr.PorterStemFilterFactory'}],
                                     u'tokenizer': {u'class': u'solr.WhitespaceTokenizerFactory'}}},
                 {u'analyzer': {u'filters': [{u'class': u'solr.SynonymFilterFactory',
                                              u'expand': u'false',
                                              u'ignoreCase': u'true',
                                              u'synonyms': u'synonyms.txt'},
                                             {u'class': u'solr.StopFilterFactory',
                                              u'ignoreCase': u'true',
                                              u'words': u'lang/stopwords_en.txt'},
                                             {u'catenateAll': u'0',
                                              u'catenateNumbers': u'1',
                                              u'catenateWords': u'1',
                                              u'class': u'solr.WordDelimiterFilterFactory',
                                              u'generateNumberParts': u'0',
                                              u'generateWordParts': u'0'},
                                             {u'class': u'solr.LowerCaseFilterFactory'},
                                             {u'class': u'solr.KeywordMarkerFilterFactory',
                                              u'protected': u'protwords.txt'},
                                             {u'class': u'solr.EnglishMinimalStemFilterFactory'},
                                             {u'class': u'solr.RemoveDuplicatesTokenFilterFactory'}],
                                u'tokenizer': {u'class': u'solr.WhitespaceTokenizerFactory'}},
                  u'autoGeneratePhraseQueries': u'true',
                  u'class': u'solr.TextField',
                  u'name': u'text_en_splitting_tight',
                  u'positionIncrementGap': u'100'},
                 {u'analyzer': {u'filters': [{u'class': u'solr.LowerCaseFilterFactory'},
                                             {u'class': u'solr.StopFilterFactory',
                                              u'format': u'snowball',
                                              u'ignoreCase': u'true',
                                              u'words': u'lang/stopwords_es.txt'},
                                             {u'class': u'solr.SpanishLightStemFilterFactory'}],
                                u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}},
                  u'class': u'solr.TextField',
                  u'name': u'text_es',
                  u'positionIncrementGap': u'100'},
                 {u'analyzer': {u'filters': [{u'class': u'solr.LowerCaseFilterFactory'},
                                             {u'class': u'solr.StopFilterFactory',
                                              u'ignoreCase': u'true',
                                              u'words': u'lang/stopwords_eu.txt'},
                                             {u'class': u'solr.SnowballPorterFilterFactory',
                                              u'language': u'Basque'}],
                                u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}},
                  u'class': u'solr.TextField',
                  u'name': u'text_eu',
                  u'positionIncrementGap': u'100'},
                 {u'analyzer': {u'charFilters': [{u'class': u'solr.PersianCharFilterFactory'}],
                                u'filters': [{u'class': u'solr.LowerCaseFilterFactory'},
                                             {u'class': u'solr.ArabicNormalizationFilterFactory'},
                                             {u'class': u'solr.PersianNormalizationFilterFactory'},
                                             {u'class': u'solr.StopFilterFactory',
                                              u'ignoreCase': u'true',
                                              u'words': u'lang/stopwords_fa.txt'}],
                                u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}},
                  u'class': u'solr.TextField',
                  u'name': u'text_fa',
                  u'positionIncrementGap': u'100'},
                 {u'analyzer': {u'filters': [{u'class': u'solr.LowerCaseFilterFactory'},
                                             {u'class': u'solr.StopFilterFactory',
                                              u'format': u'snowball',
                                              u'ignoreCase': u'true',
                                              u'words': u'lang/stopwords_fi.txt'},
                                             {u'class': u'solr.SnowballPorterFilterFactory',
                                              u'language': u'Finnish'}],
                                u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}},
                  u'class': u'solr.TextField',
                  u'name': u'text_fi',
                  u'positionIncrementGap': u'100'},
                 {u'analyzer': {u'filters': [{u'articles': u'lang/contractions_fr.txt',
                                              u'class': u'solr.ElisionFilterFactory',
                                              u'ignoreCase': u'true'},
                                             {u'class': u'solr.LowerCaseFilterFactory'},
                                             {u'class': u'solr.StopFilterFactory',
                                              u'format': u'snowball',
                                              u'ignoreCase': u'true',
                                              u'words': u'lang/stopwords_fr.txt'},
                                             {u'class': u'solr.FrenchLightStemFilterFactory'}],
                                u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}},
                  u'class': u'solr.TextField',
                  u'name': u'text_fr',
                  u'positionIncrementGap': u'100'},
                 {u'analyzer': {u'filters': [{u'articles': u'lang/contractions_ga.txt',
                                              u'class': u'solr.ElisionFilterFactory',
                                              u'ignoreCase': u'true'},
                                             {u'class': u'solr.StopFilterFactory',
                                              u'ignoreCase': u'true',
                                              u'words': u'lang/hyphenations_ga.txt'},
                                             {u'class': u'solr.IrishLowerCaseFilterFactory'},
                                             {u'class': u'solr.StopFilterFactory',
                                              u'ignoreCase': u'true',
                                              u'words': u'lang/stopwords_ga.txt'},
                                             {u'class': u'solr.SnowballPorterFilterFactory',
                                              u'language': u'Irish'}],
                                u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}},
                  u'class': u'solr.TextField',
                  u'name': u'text_ga',
                  u'positionIncrementGap': u'100'},
                 {u'class': u'solr.TextField',
                  u'indexAnalyzer': {u'filters': [{u'class': u'solr.StopFilterFactory',
                                                   u'ignoreCase': u'true',
                                                   u'words': u'stopwords.txt'},
                                                  {u'class': u'solr.LowerCaseFilterFactory'}],
                                     u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}},
                  u'name': u'text_general',
                  u'positionIncrementGap': u'100',
                  u'queryAnalyzer': {u'filters': [{u'class': u'solr.StopFilterFactory',
                                                   u'ignoreCase': u'true',
                                                   u'words': u'stopwords.txt'},
                                                  {u'class': u'solr.SynonymFilterFactory',
                                                   u'expand': u'true',
                                                   u'ignoreCase': u'true',
                                                   u'synonyms': u'synonyms.txt'},
                                                  {u'class': u'solr.LowerCaseFilterFactory'}],
                                     u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}}},
                 {u'class': u'solr.TextField',
                  u'indexAnalyzer': {u'filters': [{u'class': u'solr.StopFilterFactory',
                                                   u'ignoreCase': u'true',
                                                   u'words': u'stopwords.txt'},
                                                  {u'class': u'solr.LowerCaseFilterFactory'},
                                                  {u'class': u'solr.ReversedWildcardFilterFactory',
                                                   u'maxFractionAsterisk': u'0.33',
                                                   u'maxPosAsterisk': u'3',
                                                   u'maxPosQuestion': u'2',
                                                   u'withOriginal': u'true'}],
                                     u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}},
                  u'name': u'text_general_rev',
                  u'positionIncrementGap': u'100',
                  u'queryAnalyzer': {u'filters': [{u'class': u'solr.SynonymFilterFactory',
                                                   u'expand': u'true',
                                                   u'ignoreCase': u'true',
                                                   u'synonyms': u'synonyms.txt'},
                                                  {u'class': u'solr.StopFilterFactory',
                                                   u'ignoreCase': u'true',
                                                   u'words': u'stopwords.txt'},
                                                  {u'class': u'solr.LowerCaseFilterFactory'}],
                                     u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}}},
                 {u'analyzer': {u'filters': [{u'class': u'solr.LowerCaseFilterFactory'},
                                             {u'class': u'solr.StopFilterFactory',
                                              u'ignoreCase': u'true',
                                              u'words': u'lang/stopwords_gl.txt'},
                                             {u'class': u'solr.GalicianStemFilterFactory'}],
                                u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}},
                  u'class': u'solr.TextField',
                  u'name': u'text_gl',
                  u'positionIncrementGap': u'100'},
                 {u'analyzer': {u'filters': [{u'class': u'solr.LowerCaseFilterFactory'},
                                             {u'class': u'solr.IndicNormalizationFilterFactory'},
                                             {u'class': u'solr.HindiNormalizationFilterFactory'},
                                             {u'class': u'solr.StopFilterFactory',
                                              u'ignoreCase': u'true',
                                              u'words': u'lang/stopwords_hi.txt'},
                                             {u'class': u'solr.HindiStemFilterFactory'}],
                                u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}},
                  u'class': u'solr.TextField',
                  u'name': u'text_hi',
                  u'positionIncrementGap': u'100'},
                 {u'analyzer': {u'filters': [{u'class': u'solr.LowerCaseFilterFactory'},
                                             {u'class': u'solr.StopFilterFactory',
                                              u'format': u'snowball',
                                              u'ignoreCase': u'true',
                                              u'words': u'lang/stopwords_hu.txt'},
                                             {u'class': u'solr.SnowballPorterFilterFactory',
                                              u'language': u'Hungarian'}],
                                u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}},
                  u'class': u'solr.TextField',
                  u'name': u'text_hu',
                  u'positionIncrementGap': u'100'},
                 {u'analyzer': {u'filters': [{u'class': u'solr.LowerCaseFilterFactory'},
                                             {u'class': u'solr.StopFilterFactory',
                                              u'ignoreCase': u'true',
                                              u'words': u'lang/stopwords_hy.txt'},
                                             {u'class': u'solr.SnowballPorterFilterFactory',
                                              u'language': u'Armenian'}],
                                u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}},
                  u'class': u'solr.TextField',
                  u'name': u'text_hy',
                  u'positionIncrementGap': u'100'},
                 {u'analyzer': {u'filters': [{u'class': u'solr.LowerCaseFilterFactory'},
                                             {u'class': u'solr.StopFilterFactory',
                                              u'ignoreCase': u'true',
                                              u'words': u'lang/stopwords_id.txt'},
                                             {u'class': u'solr.IndonesianStemFilterFactory',
                                              u'stemDerivational': u'true'}],
                                u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}},
                  u'class': u'solr.TextField',
                  u'name': u'text_id',
                  u'positionIncrementGap': u'100'},
                 {u'analyzer': {u'filters': [{u'articles': u'lang/contractions_it.txt',
                                              u'class': u'solr.ElisionFilterFactory',
                                              u'ignoreCase': u'true'},
                                             {u'class': u'solr.LowerCaseFilterFactory'},
                                             {u'class': u'solr.StopFilterFactory',
                                              u'format': u'snowball',
                                              u'ignoreCase': u'true',
                                              u'words': u'lang/stopwords_it.txt'},
                                             {u'class': u'solr.ItalianLightStemFilterFactory'}],
                                u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}},
                  u'class': u'solr.TextField',
                  u'name': u'text_it',
                  u'positionIncrementGap': u'100'},
                 {u'analyzer': {u'filters': [{u'class': u'solr.JapaneseBaseFormFilterFactory'},
                                             {u'class': u'solr.JapanesePartOfSpeechStopFilterFactory',
                                              u'tags': u'lang/stoptags_ja.txt'},
                                             {u'class': u'solr.CJKWidthFilterFactory'},
                                             {u'class': u'solr.StopFilterFactory',
                                              u'ignoreCase': u'true',
                                              u'words': u'lang/stopwords_ja.txt'},
                                             {u'class': u'solr.JapaneseKatakanaStemFilterFactory',
                                              u'minimumLength': u'4'},
                                             {u'class': u'solr.LowerCaseFilterFactory'}],
                                u'tokenizer': {u'class': u'solr.JapaneseTokenizerFactory',
                                               u'mode': u'search'}},
                  u'autoGeneratePhraseQueries': u'false',
                  u'class': u'solr.TextField',
                  u'name': u'text_ja',
                  u'positionIncrementGap': u'100'},
                 {u'analyzer': {u'filters': [{u'class': u'solr.LowerCaseFilterFactory'},
                                             {u'class': u'solr.StopFilterFactory',
                                              u'ignoreCase': u'true',
                                              u'words': u'lang/stopwords_lv.txt'},
                                             {u'class': u'solr.LatvianStemFilterFactory'}],
                                u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}},
                  u'class': u'solr.TextField',
                  u'name': u'text_lv',
                  u'positionIncrementGap': u'100'},
                 {u'analyzer': {u'filters': [{u'class': u'solr.LowerCaseFilterFactory'},
                                             {u'class': u'solr.StopFilterFactory',
                                              u'format': u'snowball',
                                              u'ignoreCase': u'true',
                                              u'words': u'lang/stopwords_nl.txt'},
                                             {u'class': u'solr.StemmerOverrideFilterFactory',
                                              u'dictionary': u'lang/stemdict_nl.txt',
                                              u'ignoreCase': u'false'},
                                             {u'class': u'solr.SnowballPorterFilterFactory',
                                              u'language': u'Dutch'}],
                                u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}},
                  u'class': u'solr.TextField',
                  u'name': u'text_nl',
                  u'positionIncrementGap': u'100'},
                 {u'analyzer': {u'filters': [{u'class': u'solr.LowerCaseFilterFactory'},
                                             {u'class': u'solr.StopFilterFactory',
                                              u'format': u'snowball',
                                              u'ignoreCase': u'true',
                                              u'words': u'lang/stopwords_no.txt'},
                                             {u'class': u'solr.SnowballPorterFilterFactory',
                                              u'language': u'Norwegian'}],
                                u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}},
                  u'class': u'solr.TextField',
                  u'name': u'text_no',
                  u'positionIncrementGap': u'100'},
                 {u'analyzer': {u'filters': [{u'class': u'solr.LowerCaseFilterFactory'},
                                             {u'class': u'solr.StopFilterFactory',
                                              u'format': u'snowball',
                                              u'ignoreCase': u'true',
                                              u'words': u'lang/stopwords_pt.txt'},
                                             {u'class': u'solr.PortugueseLightStemFilterFactory'}],
                                u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}},
                  u'class': u'solr.TextField',
                  u'name': u'text_pt',
                  u'positionIncrementGap': u'100'},
                 {u'analyzer': {u'filters': [{u'class': u'solr.LowerCaseFilterFactory'},
                                             {u'class': u'solr.StopFilterFactory',
                                              u'ignoreCase': u'true',
                                              u'words': u'lang/stopwords_ro.txt'},
                                             {u'class': u'solr.SnowballPorterFilterFactory',
                                              u'language': u'Romanian'}],
                                u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}},
                  u'class': u'solr.TextField',
                  u'name': u'text_ro',
                  u'positionIncrementGap': u'100'},
                 {u'analyzer': {u'filters': [{u'class': u'solr.LowerCaseFilterFactory'},
                                             {u'class': u'solr.StopFilterFactory',
                                              u'format': u'snowball',
                                              u'ignoreCase': u'true',
                                              u'words': u'lang/stopwords_ru.txt'},
                                             {u'class': u'solr.SnowballPorterFilterFactory',
                                              u'language': u'Russian'}],
                                u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}},
                  u'class': u'solr.TextField',
                  u'name': u'text_ru',
                  u'positionIncrementGap': u'100'},
                 {u'analyzer': {u'filters': [{u'class': u'solr.LowerCaseFilterFactory'},
                                             {u'class': u'solr.StopFilterFactory',
                                              u'format': u'snowball',
                                              u'ignoreCase': u'true',
                                              u'words': u'lang/stopwords_sv.txt'},
                                             {u'class': u'solr.SnowballPorterFilterFactory',
                                              u'language': u'Swedish'}],
                                u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}},
                  u'class': u'solr.TextField',
                  u'name': u'text_sv',
                  u'positionIncrementGap': u'100'},
                 {u'analyzer': {u'filters': [{u'class': u'solr.LowerCaseFilterFactory'},
                                             {u'class': u'solr.StopFilterFactory',
                                              u'ignoreCase': u'true',
                                              u'words': u'lang/stopwords_th.txt'}],
                                u'tokenizer': {u'class': u'solr.ThaiTokenizerFactory'}},
                  u'class': u'solr.TextField',
                  u'name': u'text_th',
                  u'positionIncrementGap': u'100'},
                 {u'analyzer': {u'filters': [{u'class': u'solr.ApostropheFilterFactory'},
                                             {u'class': u'solr.TurkishLowerCaseFilterFactory'},
                                             {u'class': u'solr.StopFilterFactory',
                                              u'ignoreCase': u'false',
                                              u'words': u'lang/stopwords_tr.txt'},
                                             {u'class': u'solr.SnowballPorterFilterFactory',
                                              u'language': u'Turkish'}],
                                u'tokenizer': {u'class': u'solr.StandardTokenizerFactory'}},
                  u'class': u'solr.TextField',
                  u'name': u'text_tr',
                  u'positionIncrementGap': u'100'},
                 {u'analyzer': {u'tokenizer': {u'class': u'solr.WhitespaceTokenizerFactory'}},
                  u'class': u'solr.TextField',
                  u'name': u'text_ws',
                  u'positionIncrementGap': u'100'},
                 {u'class': u'solr.TrieFloatField',
                  u'name': u'tfloat',
                  u'positionIncrementGap': u'0',
                  u'precisionStep': u'8'},
                 {u'class': u'solr.TrieIntField',
                  u'name': u'tint',
                  u'positionIncrementGap': u'0',
                  u'precisionStep': u'8'},
                 {u'class': u'solr.TrieLongField',
                  u'name': u'tlong',
                  u'positionIncrementGap': u'0',
                  u'precisionStep': u'8'}],
 u'fields': [{u'indexed': True,
              u'name': u'_root_',
              u'stored': False,
              u'type': u'string'},
             {u'indexed': True,
              u'name': u'_version_',
              u'stored': True,
              u'type': u'long'},
             {u'indexed': True,
              u'name': u'author',
              u'stored': True,
              u'type': u'text_general'},
             {u'indexed': True,
              u'multiValued': True,
              u'name': u'cat',
              u'stored': True,
              u'type': u'string'},
             {u'indexed': True,
              u'name': u'category',
              u'stored': True,
              u'type': u'text_general'},
             {u'indexed': True,
              u'name': u'comments',
              u'stored': True,
              u'type': u'text_general'},
             {u'indexed': False,
              u'multiValued': True,
              u'name': u'content',
              u'stored': True,
              u'type': u'text_general'},
             {u'indexed': True,
              u'multiValued': True,
              u'name': u'content_type',
              u'stored': True,
              u'type': u'string'},
             {u'indexed': True,
              u'name': u'description',
              u'stored': True,
              u'type': u'text_general'},
             {u'indexed': True,
              u'multiValued': True,
              u'name': u'features',
              u'stored': True,
              u'type': u'text_general'},
             {u'indexed': True,
              u'multiValued': False,
              u'name': u'id',
              u'required': True,
              u'stored': True,
              u'type': u'string'},
             {u'indexed': True,
              u'name': u'inStock',
              u'stored': True,
              u'type': u'boolean'},
             {u'indexed': True,
              u'name': u'includes',
              u'stored': True,
              u'termOffsets': True,
              u'termPositions': True,
              u'termVectors': True,
              u'type': u'text_general'},
             {u'indexed': True,
              u'name': u'keywords',
              u'stored': True,
              u'type': u'text_general'},
             {u'indexed': True,
              u'name': u'last_modified',
              u'stored': True,
              u'type': u'date'},
             {u'indexed': True,
              u'multiValued': True,
              u'name': u'links',
              u'stored': True,
              u'type': u'string'},
             {u'indexed': True,
              u'name': u'manu',
              u'omitNorms': True,
              u'stored': True,
              u'type': u'text_general'},
             {u'indexed': True,
              u'name': u'manu_exact',
              u'stored': False,
              u'type': u'string'},
             {u'indexed': True,
              u'name': u'name',
              u'stored': True,
              u'type': u'text_general'},
             {u'indexed': True,
              u'name': u'payloads',
              u'stored': True,
              u'type': u'payloads'},
             {u'indexed': True,
              u'name': u'popularity',
              u'stored': True,
              u'type': u'int'},
             {u'indexed': True,
              u'name': u'price',
              u'stored': True,
              u'type': u'float'},
             {u'indexed': True,
              u'name': u'resourcename',
              u'stored': True,
              u'type': u'text_general'},
             {u'indexed': True,
              u'name': u'sku',
              u'omitNorms': True,
              u'stored': True,
              u'type': u'text_en_splitting_tight'},
             {u'indexed': True,
              u'name': u'store',
              u'stored': True,
              u'type': u'location'},
             {u'indexed': True,
              u'name': u'subject',
              u'stored': True,
              u'type': u'text_general'},
             {u'indexed': True,
              u'multiValued': True,
              u'name': u'text',
              u'stored': False,
              u'type': u'text_general'},
             {u'indexed': True,
              u'multiValued': True,
              u'name': u'text_rev',
              u'stored': False,
              u'type': u'text_general_rev'},
             {u'indexed': True,
              u'multiValued': True,
              u'name': u'title',
              u'stored': True,
              u'type': u'text_general'},
             {u'indexed': True,
              u'name': u'url',
              u'stored': True,
              u'type': u'text_general'},
             {u'indexed': True,
              u'name': u'weight',
              u'stored': True,
              u'type': u'float'}],
 u'name': u'example',
 u'uniqueKey': u'id',
 u'version': 1.5}
