"""Functions that deal with getting the "keywords" for typeahead search

  Ultimately, this file will include all functions related to search. At the moment,
  it has two purposes:
    1. To hardcode the list of nltk stopwords in English
    2. Create a list of keywords from a list of words
"""
ENGLISH_STOPWORDS = ['i', 'me', 'my', 'myself', 'we', 'our', 'ours', 'ourselves',
                     'you', 'your', 'yours', 'yourself', 'yourselves', 'he', 'him',
                     'his', 'himself', 'she', 'her', 'hers', 'herself', 'it', 'its',
                     'itself', 'they', 'them', 'their', 'theirs', 'themselves', 'what',
                     'which', 'who', 'whom', 'this', 'that', 'these', 'those', 'am',
                     'is', 'are', 'was', 'were', 'be', 'been', 'being', 'have', 'has',
                     'had', 'having', 'do', 'does', 'did', 'doing', 'a', 'an', 'the',
                     'and', 'but', 'if', 'or', 'because', 'as', 'until', 'while',
                     'of', 'at', 'by', 'for', 'with', 'about', 'against', 'between',
                     'into', 'through', 'during', 'before', 'after', 'above', 'below',
                     'to', 'from', 'up', 'down', 'in', 'out', 'on', 'off', 'over',
                     'under', 'again', 'further', 'then', 'once', 'here', 'there',
                     'when', 'where', 'why', 'how', 'all', 'any', 'both', 'each',
                     'few', 'more', 'most', 'other', 'some', 'such', 'no', 'nor',
                     'not', 'only', 'own', 'same', 'so', 'than', 'too', 'very',
                     's', 't', 'can', 'will', 'just', 'don', 'should', 'now']


def get_keywords(post):
    " Given a post object return a space-separated string of keywords "
    author = [author.format_name for author in post.authors]
    title = post.title.split(" ")
    tldr = post.tldr.split(" ")
    tags = [tag.name for tag in post.tags]
    full_search_text = author + title + tldr + tags
    keywords = ' '.join([word for word in full_search_text if word not in ENGLISH_STOPWORDS])
    return keywords
