"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Instance = exports.InstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const memcache_generated_1 = require("./memcache.generated");
Object.defineProperty(exports, "InstanceProperty", { enumerable: true, get: function () { return memcache_generated_1.RosInstance; } });
/**
 * A ROS resource type:  `ALIYUN::Memcache::Instance`
 */
class Instance extends ros.Resource {
    /**
     * Create a new `ALIYUN::Memcache::Instance`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosInstance = new memcache_generated_1.RosInstance(this, id, {
            autoRenewPeriod: props.autoRenewPeriod,
            couponNo: props.couponNo,
            privateIpAddress: props.privateIpAddress,
            zoneId: props.zoneId,
            resourceGroupId: props.resourceGroupId,
            config: props.config,
            autoRenew: props.autoRenew,
            vSwitchId: props.vSwitchId,
            period: props.period,
            instanceClass: props.instanceClass,
            vpcPasswordFree: props.vpcPasswordFree,
            instanceName: props.instanceName,
            vpcId: props.vpcId,
            capacity: props.capacity,
            autoUseCoupon: props.autoUseCoupon,
            chargeType: props.chargeType,
            networkType: props.networkType,
            backupPolicy: props.backupPolicy,
            password: props.password,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosInstance;
        this.attrConnectionDomain = rosInstance.attrConnectionDomain;
        this.attrInstanceId = rosInstance.attrInstanceId;
        this.attrInstanceName = rosInstance.attrInstanceName;
        this.attrPort = rosInstance.attrPort;
        this.attrQps = rosInstance.attrQps;
    }
}
exports.Instance = Instance;
//# sourceMappingURL=data:application/json;base64,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