# This file was generated by mettle.genes.db.GenPy3 [ver 2.2] on Thu Aug 11 12:14:36 2022
#

import datetime
import uuid
import time
import dataclasses
import typing
import mettle.io
import mettle.db

from .col_key import tColKey

@dataclasses.dataclass(slots=True)
class tCol(mettle.io.ISerializable, mettle.db.IPrimaryKey):

    aud_id: int = dataclasses.field(default=0, compare=True, hash=True)
    name: str = dataclasses.field(default='', compare=True, hash=True)
    before: str = dataclasses.field(default='', compare=False)
    after: str = dataclasses.field(default='', compare=False)

    def clear(self):
        """
        Clears all member variables for this database record.
        """
        self.aud_id = 0
        self.name = ''
        self.before = ''
        self.after = ''

    def _name(self) -> str:
        """
        Name of the record.

        :return: The name.
        """
        return 'tCol'

    def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
        """
        Serialize record to a stream.

        :param _w:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _w.write_start(_oname)
        _w.write_int64("aud_id", self.aud_id)
        _w.write_string("name", self.name)
        _w.write_string("before", self.before)
        _w.write_string("after", self.after)
        _w.write_end(_oname)

    def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
        """
        Deserialize record from a stream.

        :param _r:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _r.read_start(_oname)
        self.aud_id = _r.read_int64("aud_id")
        self.name = _r.read_string("name")
        self.before = _r.read_string("before")
        self.after = _r.read_string("after")
        _r.read_end(_oname)

    def _copy_from(self, rec: "tCol"):
        """
        Copies the column from the rec into this record.

        :param rec: The source record.
        """
        self.aud_id = rec.aud_id
        self.name = rec.name
        self.before = rec.before
        self.after = rec.after

    def _write_pk(self, _key: "tCol"):
        """
        Write the primary key columns to the key object.

        :param _key:
        """
        self._write_key(_key)

    def _read_pk(self, _key: "tCol"):
        """
        Read the primary key columns from the key object.

        :param _key:
        """
        self._read_key(_key)

    def _serialize_key(self, _w: mettle.io.IWriter):
        """
        Serialize the primary key to a stream.

        :param _w:
        """
        _key = tColKey()

        self._write_key(_key)
        _key._serialize(_w)

    def _deserialize_key(self, _r: mettle.io.IReader):
        """
        Deserialize the primary key from a stream.

        :param _r:
        """
        _key = tColKey()

        _key._deserialize(_r)
        self._read_key(_key)

    @staticmethod
    def _cache_davs(dvc=None, for_ins: bool = False, key_only: bool = False):
        """
        Cache the DAV into the dav cache (or create one) and return it.

        :param dvc: (mettle.lib.DavCache), target cache, if None a new one is created and returned.
        :param for_ins: Davs for insert.
        :param key_only: Davs by key only, ie for delete/selectone.
        """
        if dvc is None:
            dvc = mettle.lib.DavCache()

        dvc.add_targ("aud_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("name", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        if key_only:
            return dvc


        return dvc

    def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
        tCol._cache_davs(dvc, for_ins, key_only)

    def _write_key(self, _key: tColKey):
        """
        Write primary key columns to _key.

        :param _key:
        """
        _key.aud_id = self.aud_id
        _key.name = self.name

    def _read_key(self, _key: tColKey):
        """
        Read the primary key columns from _key.

        :param _key:
        """
        self.aud_id = _key.aud_id
        self.name = _key.name

    @staticmethod
    def _pk_compare(x, y) -> int:
        """
        Compare function do primary key comparisons for list sorts and searches.

        :return: zero for x == y, negative for x < y, positive for x > y
        """
        rc = x.aud_id - y.aud_id

        if rc != 0:
            return rc

        rc = (x.name > y.name) - (x.name < y.name)

        return rc

    def __lt__(self, other):
        return other and self._pk_compare(self, other) < 0

    def __gt__(self, other):
        return other and self._pk_compare(self, other) > 0

    def __eq__(self, other):
        return other and self._pk_compare(self, other) == 0

    def __le__(self, other):
        return other and self._pk_compare(self, other) <= 0

    def __ge__(self, other):
        return other and self._pk_compare(self, other) >= 0

    def __ne__(self, other):
        return other == None or self._pk_compare(self, other)


    class List(list, mettle.io.ISerializable):
        """
        List Class
        """

        def _name(self) -> str:
            """
            Name of the list.

            :return: The name
            """
            return 'tCol.List'

        def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
            """
            Serialize the list to a stream.

            :param _w:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _w.write_start_list(_oname, len(self))

            for _rec in self:
                _rec._serialize(_w)

            _w.write_end(_oname)

        def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
            """
            Deserialize the list from a stream.

            :param _r:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _cnt = _r.read_start_list(_oname)

            while _cnt >= 1:
                _rec  = tCol()
                _cnt -= 1
                _rec._deserialize(_r)
                self.append(_rec)

            _r.read_end(_oname)

        def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
            return tCol._cache_davs(dvc, for_ins, key_only)

