# This file was generated by mettle.genes.db.GenPy3 [ver 2.2] on Thu Aug 11 12:14:36 2022
#  Target Database = postgresql
#
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_audit.db.tables.icfg_changed_since import iCfgChangedSince
from bs_audit.db.tables.ocfg_changed_since import oCfgChangedSince

class dCfgChangedSince:
    __slots__ = ("_dbcon", "_dbstmnt", "irec", "orec")

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = iCfgChangedSince()
        self.orec     = None

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        self._dbstmnt = None

    def exec_deft(self,
                  since: datetime.datetime,
                  criteria: str) -> "dCfgChangedSince":
        """
        Execute the query by setting all the inputs.

        :param since: datetime.datetime
        :param criteria: str
        :return: Self for convenience.
        """
        self.irec.since = since
        self.irec.criteria = criteria

        return self.exec()

    def exec(self, irec: iCfgChangedSince = None) -> "dCfgChangedSince":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("CfgChangedSince", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  c.id,
from
  audit.cfg c
where
  last_chg >= :since
  [criteria]""")

        self._dbstmnt.dynamic("[criteria]", self.irec.criteria)

        self._dbstmnt.bind_in("since", self.irec.since, datetime.datetime)

        self._dbstmnt.bind_out("id", str)

        self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    def fetch(self, must_exist: bool = False) -> bool:
        """
        Fetches the next row from the executed query.

        :param must_exist:
        :return: True if a row was fetched, else False.
        """
        if not self._dbcon.fetch(self._dbstmnt):
            if must_exist:
                raise mettle.lib.xMettle(f"Record not found: [table:Cfg, proc:ChangedSince, row:{self.irec}]", err_code=mettle.lib.xMettle.eCode.DBNotFound)
            return False

        self.orec = oCfgChangedSince()

        self.orec.id = self._dbstmnt.result[0]

        return True

    def fetch_iter(self) -> oCfgChangedSince:
        """
        Yield all the rows one at a time.

        :return: Iterator for output rows
        """
        while self.fetch():
            yield self.orec

    def fetch_all(self, out_list: oCfgChangedSince.List, clear_list: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param out_list:
        :param clear_list:
        :return: Number of rows fetched.
        """
        if clear_list:
            out_list.clear()

        while self.fetch():
            out_list.append(self.orec)

        return len(out_list)

