# Security Policy

## Reporting a Vulnerability

If you discover a security vulnerability in this package, please report it to us.

**DO NOT** create a public GitHub issue for security vulnerabilities.

### How to Report

Email: support@revenium.io

Please include:
- Package name and version
- Description of the vulnerability
- Steps to reproduce (if applicable)
- Potential impact
- Suggested fix (if available)

We will review and respond to security reports in a timely manner.

## Security Best Practices

When using this middleware:

1. **API Keys**: Never commit API keys to version control
2. **Environment Variables**: Use environment variables for sensitive configuration
3. **PII Handling**: Ensure no PII is sent to Revenium unless explicitly configured for billing purposes
4. **Network Security**: Always use HTTPS connections
5. **Updates**: Keep the package updated to the latest version

## Additional Resources

- [Revenium Documentation](https://docs.revenium.io)
