/*
 * Decompiled with CFR 0.152.
 */
package org.happy.controllers.impl;

import com.google.common.base.Preconditions;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.happy.collections.decorators.UnmodifiableStrategy_1x0;
import org.happy.collections.lists.decorators.UnmodifiableList_1x0;
import org.happy.commons.patterns.Factory_1x3;
import org.happy.commons.patterns.Lockable_1x0;
import org.happy.commons.patterns.executable.Executable_1x2;
import org.happy.commons.patterns.executable.decorators.ManyRetryExecutable_1x2;
import org.happy.commons.patterns.observer.Delegate_1x0;
import org.happy.commons.patterns.observer.Delegate_1x0Impl;
import org.happy.commons.patterns.observer.decorators.SynchronizedDelegate_1x0;
import org.happy.commons.patterns.observer.decorators.UnfireableDelegate_1x3;
import org.happy.commons.patterns.observer.event.ActionEventAfter_1x0;
import org.happy.commons.patterns.observer.event.ActionEventBefore_1x0;
import org.happy.commons.patterns.observer.listener.ActionListener_1x0;
import org.happy.controllers.Controller_1x3;
import org.happy.controllers.impl.AbstractController_1x3;

public class RetryController_1x3<P, R>
extends AbstractController_1x3<P, R>
implements Lockable_1x0 {
    private int maxTryNumber;
    private List<Throwable> exceptionsList;
    private ExecutorService executor;
    private CountDownLatch finishedLatch = new CountDownLatch(1);
    private AtomicInteger tryCounter = new AtomicInteger(0);
    private Factory_1x3<Controller_1x3<P, R>> factory;
    private AtomicReference<Controller_1x3<P, R>> currentTryController = new AtomicReference<Object>(null);
    private Object lockObject;
    private long delayBeforeNextTry;
    private AtomicInteger idGenerator = new AtomicInteger(0);
    private Delegate_1x0<ActionEventBefore_1x0<Integer>> onRetryEvent;
    private Delegate_1x0<ActionEventBefore_1x0<Integer>> unfireableOnRetryEvent;

    public static <P, R> RetryController_1x3<P, R> of(int maxRetryNumber, long delayBeforeNextTry, Factory_1x3<Controller_1x3<P, R>> factrory) {
        return new RetryController_1x3<P, R>(maxRetryNumber, delayBeforeNextTry, factrory, new Object());
    }

    public static <P, R> RetryController_1x3<P, R> of(int maxRetryNumber, long delayBeforeNextTry, Factory_1x3<Controller_1x3<P, R>> factrory, Object lockObject) {
        return new RetryController_1x3<P, R>(maxRetryNumber, delayBeforeNextTry, factrory, lockObject);
    }

    protected RetryController_1x3(int maxTryNumber, long delayBeforeNextTry, Factory_1x3<Controller_1x3<P, R>> factrory, Object lockObject) {
        Preconditions.checkArgument((0 < maxTryNumber ? 1 : 0) != 0);
        Preconditions.checkNotNull(factrory);
        Preconditions.checkNotNull((Object)lockObject);
        Preconditions.checkArgument((0L <= delayBeforeNextTry ? 1 : 0) != 0);
        this.maxTryNumber = maxTryNumber;
        this.factory = factrory;
        this.lockObject = lockObject;
        this.delayBeforeNextTry = delayBeforeNextTry;
    }

    protected void finalize() throws Throwable {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        super.finalize();
    }

    @Override
    public Boolean start() {
        this.setState(Controller_1x3.State_1x3.Started);
        if (this.executor != null) {
            return false;
        }
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                String threadName = "RetryController_1x3 id=" + RetryController_1x3.this.getID() + " retry=" + RetryController_1x3.this.tryCounter.get();
                return new Thread(r, threadName);
            }
        };
        this.executor = Executors.newSingleThreadScheduledExecutor(threadFactory);
        if (this.retryConditionFulfilled()) {
            this.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        RetryController_1x3.this.executeRetries();
                    }
                    finally {
                        if (RetryController_1x3.this.executor != null) {
                            RetryController_1x3.this.executor.shutdown();
                        }
                    }
                }
            });
        }
        return this.retryConditionFulfilled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void executeRetries() {
        Object exceptionAddedToTheList;
        Object result = null;
        while (true) {
            AtomicBoolean exceptionThrown;
            Controller_1x3<P, R> c;
            block32: {
                block31: {
                    Object object;
                    block30: {
                        block29: {
                            if (this.failConditionFulfilled()) {
                                this.finishedLatch.countDown();
                                return;
                            }
                            exceptionAddedToTheList = new AtomicBoolean(false);
                            c = null;
                            if (0 >= this.tryCounter.get() || !this.fireOnRetryEvent(this.tryCounter.get())) break block29;
                            try {
                                this.cancel();
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                            if (c == null) break;
                            result = c.getResult();
                            break;
                        }
                        this.tryCounter.incrementAndGet();
                        exceptionThrown = new AtomicBoolean(false);
                        object = this.lockObject;
                        // MONITORENTER : object
                        Controller_1x3.State_1x3 state = this.getState();
                        if (!Controller_1x3.State_1x3.Canceled.equals((Object)state) && !Controller_1x3.State_1x3.Finished.equals((Object)state)) break block30;
                        // MONITOREXIT : object
                        if (c == null) break;
                        result = c.getResult();
                        break;
                    }
                    try {
                        c = this.factory.create();
                        Preconditions.checkNotNull(c);
                        c.getOnErrorEvent().add(new ActionListener_1x0<ActionEventAfter_1x0<Throwable>>((AtomicBoolean)exceptionAddedToTheList, exceptionThrown){
                            final /* synthetic */ AtomicBoolean val$exceptionAddedToTheList;
                            final /* synthetic */ AtomicBoolean val$exceptionThrown;
                            {
                                this.val$exceptionAddedToTheList = atomicBoolean;
                                this.val$exceptionThrown = atomicBoolean2;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void actionPerformedImpl(ActionEventAfter_1x0<Throwable> event) {
                                Object object = RetryController_1x3.this.lockObject;
                                synchronized (object) {
                                    if (!this.val$exceptionAddedToTheList.get()) {
                                        RetryController_1x3.this.getExceptionsList().add(event.getData());
                                        this.val$exceptionAddedToTheList.set(true);
                                    }
                                    this.val$exceptionThrown.set(true);
                                }
                            }
                        });
                        if (!Controller_1x3.State_1x3.Canceled.equals((Object)this.getState())) break block31;
                        // MONITOREXIT : object
                        if (c == null) break;
                    }
                    catch (Throwable e) {
                        object = this.lockObject;
                        // MONITORENTER : object
                        if (((AtomicBoolean)exceptionAddedToTheList).get()) continue;
                        this.getExceptionsList().add(e);
                        ((AtomicBoolean)exceptionAddedToTheList).set(true);
                        if (this.maxTryNumber >= this.tryCounter.get() + 1) continue;
                        // MONITOREXIT : object
                        break;
                    }
                    result = c.getResult();
                    break;
                }
                this.currentTryController.set(c);
                if (c.start().booleanValue()) break block32;
                // MONITOREXIT : object
                if (c == null) return;
                result = c.getResult();
                return;
            }
            try {
                boolean b;
                // MONITOREXIT : object
                c.waitForFinish();
                if (exceptionThrown.get()) continue;
                Controller_1x3.State_1x3 state = c.getState();
                boolean bl = b = Controller_1x3.State_1x3.Finished.equals((Object)state) || Controller_1x3.State_1x3.Canceled.equals((Object)state);
                if (b) break;
                Preconditions.checkState((boolean)b, (Object)("state was " + (Object)((Object)state)));
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (c == null) continue;
                result = c.getResult();
                continue;
            }
            break;
        }
        try {
            exceptionAddedToTheList = this.getLockObject();
            // MONITORENTER : exceptionAddedToTheList
            this.setResult(result);
            if (!Controller_1x3.State_1x3.Canceled.equals((Object)this.getState())) {
                Controller_1x3<P, R> currentController = this.currentTryController.get();
                Preconditions.checkNotNull(currentController);
                Controller_1x3.State_1x3 state = currentController.getState();
                Preconditions.checkState((Controller_1x3.State_1x3.Finished.equals((Object)state) || Controller_1x3.State_1x3.Canceled.equals((Object)state) ? 1 : 0) != 0);
                if (!Controller_1x3.State_1x3.Canceled.equals((Object)this.getState())) {
                    this.setState(currentController.getState());
                }
            }
            // MONITOREXIT : exceptionAddedToTheList
            return;
        }
        catch (Throwable e) {
            this.fireOnErrorEvent(e);
            return;
        }
        finally {
            this.finishedLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean cancel() {
        try {
            Executable_1x2<Boolean, Void> decorated = new Executable_1x2<Boolean, Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Boolean execute(Void parameter) {
                    Object object = RetryController_1x3.this.lockObject;
                    synchronized (object) {
                        if (Controller_1x3.State_1x3.Finished.equals((Object)RetryController_1x3.this.getState())) {
                            return false;
                        }
                        RetryController_1x3.this.setState(Controller_1x3.State_1x3.Canceled);
                        Controller_1x3 c = (Controller_1x3)RetryController_1x3.this.currentTryController.get();
                        if (c != null) {
                            Boolean r = false;
                            try {
                                r = c.cancel();
                                RetryController_1x3.this.setResult(c.getResult());
                            }
                            catch (Throwable t) {
                                if (RetryController_1x3.this.executor != null) {
                                    RetryController_1x3.this.executor.shutdownNow();
                                }
                                if (t instanceof RuntimeException) {
                                    throw (RuntimeException)t;
                                }
                                throw new IllegalStateException(t);
                            }
                            return r;
                        }
                    }
                    return true;
                }
            };
            ManyRetryExecutable_1x2<Boolean, Void> executeable = ManyRetryExecutable_1x2.of(decorated, this.maxTryNumber, this.delayBeforeNextTry);
            Boolean bl = (Boolean)executeable.execute(null);
            return bl;
        }
        finally {
            if (this.finishedLatch != null) {
                this.finishedLatch.countDown();
            }
        }
    }

    @Override
    public R waitForFinish() {
        try {
            this.finishedLatch.await();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        if (this.failConditionFulfilled()) {
            Throwable cause = null;
            if (!this.getExceptionsList().isEmpty()) {
                cause = this.getExceptionsList().get(this.getExceptionsList().size() - 1);
            }
            throw new ManyRetriesException(cause, this.getExceptionsList());
        }
        Controller_1x3.State_1x3 state = this.getState();
        Preconditions.checkState((Controller_1x3.State_1x3.Canceled.equals((Object)state) || Controller_1x3.State_1x3.Finished.equals((Object)state) ? 1 : 0) != 0, (Object)("state was: " + (Object)((Object)state)));
        return this.getResult();
    }

    private boolean retryConditionFulfilled() {
        return this.tryCounter.get() <= this.maxTryNumber;
    }

    private boolean failConditionFulfilled() {
        Controller_1x3.State_1x3 state = this.getState();
        if (Controller_1x3.State_1x3.Finished.equals((Object)state) || Controller_1x3.State_1x3.Canceled.equals((Object)state)) {
            return false;
        }
        return this.maxTryNumber < this.tryCounter.get() + 1;
    }

    public List<Throwable> getExceptionsList() {
        if (this.exceptionsList == null) {
            this.exceptionsList = UnmodifiableList_1x0.of(new ArrayList(), UnmodifiableStrategy_1x0.AddAllowed);
        }
        return this.exceptionsList;
    }

    public int getCurrentRetry() {
        return this.tryCounter.get();
    }

    public int getMaxTryNumber() {
        return this.maxTryNumber;
    }

    public int getTryCounter() {
        return this.tryCounter.get();
    }

    public Controller_1x3<P, R> getCurrentTryController() {
        return this.currentTryController.get();
    }

    @Override
    public Object getLockObject() {
        return this.lockObject;
    }

    @Override
    public void setLockObject(Object lockObject) {
        if (!Controller_1x3.State_1x3.Created.equals((Object)this.getState())) {
            throw new IllegalStateException("the lockObject can't be setted in " + this.getClass().getCanonicalName() + " if the current state of controller is: " + (Object)((Object)this.getState()));
        }
        this.lockObject = lockObject;
    }

    @Override
    protected void setState(Controller_1x3.State_1x3 state) {
        super.setState(state);
        if ((Controller_1x3.State_1x3.Finished.equals((Object)state) || Controller_1x3.State_1x3.Canceled.equals((Object)state)) && this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    public long getDelayBeforeNextTry() {
        return this.delayBeforeNextTry;
    }

    protected boolean fireOnRetryEvent(Integer retrynumber) {
        Preconditions.checkNotNull((Object)retrynumber);
        Preconditions.checkArgument((0 < retrynumber ? 1 : 0) != 0);
        if (this.onRetryEvent != null) {
            RetryController_1x3 surce = this;
            int id = this.idGenerator.incrementAndGet();
            String command = "Next Retry event";
            ActionEventBefore_1x0<Integer> e = new ActionEventBefore_1x0<Integer>((Object)surce, id, command, retrynumber);
            this.onRetryEvent.fire(e);
            return e.isCanceled();
        }
        return false;
    }

    public Delegate_1x0<ActionEventBefore_1x0<Integer>> getOnRetryEvent() {
        if (this.onRetryEvent == null) {
            this.onRetryEvent = SynchronizedDelegate_1x0.of(new Delegate_1x0Impl());
            this.unfireableOnRetryEvent = UnfireableDelegate_1x3.of(this.onRetryEvent);
        }
        return this.unfireableOnRetryEvent;
    }

    public static class ManyRetriesException
    extends RuntimeException {
        private static final long serialVersionUID = 6212595060238100011L;
        private List<Throwable> throwableList = new ArrayList<Throwable>();

        protected ManyRetriesException(Throwable cause, Collection<Throwable> exceptionsCol) {
            super(cause);
            Preconditions.checkNotNull(exceptionsCol);
            for (Throwable ex : exceptionsCol) {
                Preconditions.checkNotNull((Object)ex);
            }
            this.throwableList.addAll(exceptionsCol);
        }

        public List<Throwable> getThrowableList() {
            return this.throwableList;
        }

        @Override
        public void printStackTrace() {
            super.printStackTrace();
            System.err.println("coused by folowing exceptions:");
            for (Throwable ex : this.getThrowableList()) {
                ex.printStackTrace();
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(super.toString());
            sb.append("caused by exceptions:\n");
            int number = 0;
            for (Throwable t : this.throwableList) {
                sb.append("(" + number + ")" + t.toString() + "\n");
                ++number;
            }
            return sb.toString();
        }

        @Override
        public String getMessage() {
            return super.getMessage();
        }

        @Override
        public StackTraceElement[] getStackTrace() {
            return super.getStackTrace();
        }

        @Override
        public void printStackTrace(PrintStream arg0) {
            super.printStackTrace(arg0);
        }

        @Override
        public void printStackTrace(PrintWriter arg0) {
            super.printStackTrace(arg0);
        }
    }
}

