/*
 * Decompiled with CFR 0.152.
 */
package org.happy.controllers.impl;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.happy.commons.patterns.dataholder.impl.DataHolder_1x0Impl;
import org.happy.commons.patterns.observer.Delegate_1x0;
import org.happy.commons.patterns.observer.Delegate_1x0Impl;
import org.happy.commons.patterns.observer.decorators.SynchronizedDelegate_1x0;
import org.happy.commons.patterns.observer.event.ActionEventAfter_1x0;
import org.happy.controllers.Controller_1x3;

public abstract class AbstractController_1x3<P, R>
extends DataHolder_1x0Impl<Object>
implements Controller_1x3<P, R> {
    private Controller_1x3.State_1x3 state = Controller_1x3.State_1x3.Created;
    private static final AtomicLong idGenerator = new AtomicLong(0L);
    private Long id;
    private P progress;
    protected AtomicInteger eventID = new AtomicInteger(0);
    private Delegate_1x0<ActionEventAfter_1x0<Controller_1x3.State_1x3>> onStateChanged;
    private Delegate_1x0<ActionEventAfter_1x0<P>> onProgressChanged;
    private Delegate_1x0<ActionEventAfter_1x0<Throwable>> onError;
    private String strStateAbstract = "";
    private R result;

    public AbstractController_1x3() {
        super(null);
        this.id = idGenerator.incrementAndGet();
    }

    @Override
    public P getProgress() {
        return this.progress;
    }

    public void setProgress(P progress) {
        Preconditions.checkNotNull(progress);
        boolean changed = false;
        if (this.progress == null || !this.progress.equals(progress)) {
            changed = true;
        }
        this.progress = progress;
        if (changed) {
            this.fireOnProgressChangedEvent(this.progress);
        }
    }

    @Override
    public Long getID() {
        return this.id;
    }

    @Override
    public Delegate_1x0<ActionEventAfter_1x0<P>> getOnProgressChanged() {
        if (this.onProgressChanged == null) {
            this.onProgressChanged = SynchronizedDelegate_1x0.of(new Delegate_1x0Impl());
        }
        return this.onProgressChanged;
    }

    protected void fireOnProgressChangedEvent(P progress) {
        if (this.onProgressChanged == null) {
            return;
        }
        this.onProgressChanged.fire(new ActionEventAfter_1x0<P>((Object)this, this.eventID.getAndIncrement(), "Progress changed", progress));
    }

    @Override
    public Delegate_1x0<ActionEventAfter_1x0<Controller_1x3.State_1x3>> getOnStateChanged() {
        if (this.onStateChanged == null) {
            this.onStateChanged = SynchronizedDelegate_1x0.of(new Delegate_1x0Impl());
        }
        return this.onStateChanged;
    }

    @Override
    public Controller_1x3.State_1x3 getState() {
        return this.state;
    }

    protected void setState(Controller_1x3.State_1x3 state) {
        this.strStateAbstract = this.strStateAbstract + (Object)((Object)state) + ", ";
        boolean changed = !this.getState().equals((Object)state);
        this.strStateAbstract = this.strStateAbstract + changed + ", ";
        if (changed) {
            if (Controller_1x3.State_1x3.Finished.equals((Object)this.state) && Controller_1x3.State_1x3.Canceled.equals((Object)state)) {
                throw new IllegalArgumentException("The controller was already finished and can't be canceled!");
            }
            this.strStateAbstract = this.strStateAbstract + "1, ";
            if (Controller_1x3.State_1x3.Canceled.equals((Object)this.state) && Controller_1x3.State_1x3.Finished.equals((Object)state)) {
                throw new IllegalArgumentException("The controller was already canceled and can't be finished!");
            }
            if (Controller_1x3.State_1x3.Created.equals((Object)this.state) && Controller_1x3.State_1x3.Canceled.equals((Object)state)) {
                throw new IllegalArgumentException("The controller was not started and can't be canceled!");
            }
            this.strStateAbstract = this.strStateAbstract + "2, ";
            Preconditions.checkState((this.state.ordinal() < state.ordinal() ? 1 : 0) != 0, (Object)("existing state: " + (Object)((Object)this.state) + " can't be replaced by new state: " + (Object)((Object)state)));
            this.state = state;
            this.strStateAbstract = this.strStateAbstract + "3, ";
            this.fireOnStateChanged(state);
            this.strStateAbstract = this.strStateAbstract + "4, ";
        }
    }

    protected void fireOnStateChanged(Controller_1x3.State_1x3 state) {
        if (this.onStateChanged == null) {
            return;
        }
        this.onStateChanged.fire(new ActionEventAfter_1x0<Controller_1x3.State_1x3>((Object)this, this.eventID.getAndIncrement(), "process state has changed", state));
    }

    @Override
    public Delegate_1x0<ActionEventAfter_1x0<Throwable>> getOnErrorEvent() {
        if (this.onError == null) {
            this.onError = SynchronizedDelegate_1x0.of(new Delegate_1x0Impl());
        }
        return this.onError;
    }

    protected void fireOnErrorEvent(Throwable e) {
        if (this.onError == null) {
            return;
        }
        this.onError.fire(new ActionEventAfter_1x0<Throwable>((Object)this, this.eventID.getAndIncrement(), "Error occurred!", e));
    }

    protected void setResult(R result) {
        this.result = result;
    }

    @Override
    public R getResult() {
        return this.result;
    }

    public String toString() {
        return "AbstractController_1x3 [state=" + (Object)((Object)this.state) + ", id=" + this.id + ", progress=" + this.progress + ", result=" + this.result + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractController_1x3 other = (AbstractController_1x3)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    @Override
    public Float getVersion() {
        return Float.valueOf(1.3f);
    }
}

