/*
 * Decompiled with CFR 0.152.
 */
package org.happy.controllers;

import java.util.concurrent.atomic.AtomicReference;
import org.happy.commons.patterns.Cancelable_1x0;
import org.happy.commons.patterns.Identifiable_1x0;
import org.happy.commons.patterns.Startable_1x0;
import org.happy.commons.patterns.dataholder.DataHolder_1x0;
import org.happy.commons.patterns.observer.Delegate_1x0;
import org.happy.commons.patterns.observer.event.ActionEventAfter_1x0;
import org.happy.commons.patterns.observer.listener.ActionListener_1x0;
import org.happy.commons.patterns.version.Version_1x0;

public interface Controller_1x3<P, R>
extends Startable_1x0<Boolean>,
Cancelable_1x0<Boolean>,
Identifiable_1x0<Long>,
DataHolder_1x0<Object>,
Version_1x0<Float> {
    public Delegate_1x0<ActionEventAfter_1x0<P>> getOnProgressChanged();

    public Delegate_1x0<ActionEventAfter_1x0<Throwable>> getOnErrorEvent();

    public Delegate_1x0<ActionEventAfter_1x0<State_1x3>> getOnStateChanged();

    public P getProgress();

    public State_1x3 getState();

    @Override
    public Long getID();

    public R waitForFinish();

    public R getResult();

    @Override
    public Boolean start();

    @Override
    public Boolean cancel();

    public static enum State_1x3 {
        Created,
        Started,
        Finished,
        Canceled;

    }

    public static class Utils {
        private Utils() {
        }

        public static <R> R executeController(Controller_1x3<?, R> c) {
            final AtomicReference exceptionThrown = new AtomicReference();
            c.getOnErrorEvent().add(new ActionListener_1x0<ActionEventAfter_1x0<Throwable>>(){

                @Override
                public void actionPerformedImpl(ActionEventAfter_1x0<Throwable> event) {
                    exceptionThrown.set(event.getData());
                }
            });
            c.start();
            R result = c.waitForFinish();
            Throwable thrownable = (Throwable)exceptionThrown.get();
            if (thrownable != null) {
                if (thrownable instanceof RuntimeException) {
                    throw (RuntimeException)thrownable;
                }
                throw new IllegalStateException(thrownable);
            }
            return result;
        }
    }
}

