/*
 * Decompiled with CFR 0.152.
 */
package org.happy.concurrent.synchronizers.decorators;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.Map;
import org.happy.commons.patterns.executable.Executable_1x2;
import org.happy.concurrent.synchronizers.MultiLock_1x3;
import org.happy.concurrent.synchronizers.Synchronizer_1x3;
import org.happy.concurrent.synchronizers.decorators.SynchronizerDecorator_1x3;
import org.happy.concurrent.synchronizers.exception.MultiLockException_1x3;

public class LegacySynchronizer_1x3<L>
extends SynchronizerDecorator_1x3<L> {
    private Object globalLock = new Object();

    public static <L> LegacySynchronizer_1x3<L> of(Synchronizer_1x3<L> s) {
        return new LegacySynchronizer_1x3<L>(s);
    }

    public LegacySynchronizer_1x3(Synchronizer_1x3<L> decorated) {
        super(decorated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R synchronize(Map<L, MultiLock_1x3.Permission_1x3> locksMap, Executable_1x2<R, MultiLock_1x3<L>> command) throws MultiLockException_1x3 {
        Preconditions.checkNotNull(locksMap);
        if (locksMap.isEmpty()) {
            return super.synchronize(locksMap, command);
        }
        Object object = this.globalLock;
        synchronized (object) {
            Iterator<Map.Entry<L, MultiLock_1x3.Permission_1x3>> it = locksMap.entrySet().iterator();
            return this.synchronizeRecursivelly(it, locksMap, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R synchronizeRecursivelly(Iterator<Map.Entry<L, MultiLock_1x3.Permission_1x3>> it, Map<L, MultiLock_1x3.Permission_1x3> locksMap, Executable_1x2<R, MultiLock_1x3<L>> command) {
        Preconditions.checkNotNull(it);
        Preconditions.checkArgument((boolean)it.hasNext());
        Object lock = null;
        while (it.hasNext()) {
            Map.Entry<L, MultiLock_1x3.Permission_1x3> entry = it.next();
            if (MultiLock_1x3.Permission_1x3.Unlocked.equals((Object)entry.getValue())) continue;
            lock = entry.getKey();
            break;
        }
        if (lock == null) {
            return super.synchronize(locksMap, command);
        }
        Object var5_5 = lock;
        synchronized (var5_5) {
            if (it.hasNext()) {
                return this.synchronizeRecursivelly(it, locksMap, command);
            }
            return super.synchronize(locksMap, command);
        }
    }
}

