/*
 * Decompiled with CFR 0.152.
 */
package org.happy.commons.sort.algorithms;

import java.util.Comparator;

public class ShellSort_1x0 {
    private ShellSort_1x0() {
    }

    public static <T> void sort(T[] a, Comparator<T> comparator) {
        ShellSort_1x0.sort(a, 0, a.length, comparator);
    }

    public static <T> void sort(T[] a, int fromIndex, int toIndex, Comparator<T> comparator) {
        int size = toIndex - fromIndex;
        int h = 1;
        while (h * 3 + 1 < size) {
            h = 3 * h + 1;
        }
        while (h > 0) {
            for (int i = h - 1; i < size; ++i) {
                T tmp = a[i + fromIndex];
                int j = i;
                for (j = i; j >= h && 0 < comparator.compare(a[j - h + fromIndex], tmp); j -= h) {
                    a[j + fromIndex] = a[j - h + fromIndex];
                }
                a[j + fromIndex] = tmp;
            }
            h /= 3;
        }
    }

    public static void sort(byte[] a) {
        ShellSort_1x0.sort(a, 0, a.length);
    }

    public static void sort(byte[] a, int fromIndex, int toIndex) {
        int size = toIndex - fromIndex;
        int h = 1;
        while (h * 3 + 1 < size) {
            h = 3 * h + 1;
        }
        while (h > 0) {
            for (int i = h - 1; i < size; ++i) {
                byte tmp = a[i + fromIndex];
                int j = i;
                for (j = i; j >= h && tmp < a[j - h + fromIndex]; j -= h) {
                    a[j + fromIndex] = a[j - h + fromIndex];
                }
                a[j + fromIndex] = tmp;
            }
            h /= 3;
        }
    }

    public static void sort(short[] a) {
        ShellSort_1x0.sort(a, 0, a.length);
    }

    public static void sort(short[] a, int fromIndex, int toIndex) {
        int size = toIndex - fromIndex;
        int h = 1;
        while (h * 3 + 1 < size) {
            h = 3 * h + 1;
        }
        while (h > 0) {
            for (int i = h - 1; i < size; ++i) {
                short tmp = a[i + fromIndex];
                int j = i;
                for (j = i; j >= h && tmp < a[j - h + fromIndex]; j -= h) {
                    a[j + fromIndex] = a[j - h + fromIndex];
                }
                a[j + fromIndex] = tmp;
            }
            h /= 3;
        }
    }

    public static void sort(int[] a) {
        ShellSort_1x0.sort(a, 0, a.length);
    }

    public static void sort(int[] a, int fromIndex, int toIndex) {
        int size = toIndex - fromIndex;
        int h = 1;
        while (h * 3 + 1 < size) {
            h = 3 * h + 1;
        }
        while (h > 0) {
            for (int i = h - 1; i < size; ++i) {
                int tmp = a[i + fromIndex];
                int j = i;
                for (j = i; j >= h && tmp < a[j - h + fromIndex]; j -= h) {
                    a[j + fromIndex] = a[j - h + fromIndex];
                }
                a[j + fromIndex] = tmp;
            }
            h /= 3;
        }
    }

    public static void sort(long[] a) {
        ShellSort_1x0.sort(a, 0, a.length);
    }

    public static void sort(long[] a, int fromIndex, int toIndex) {
        int size = toIndex - fromIndex;
        int h = 1;
        while (h * 3 + 1 < size) {
            h = 3 * h + 1;
        }
        while (h > 0) {
            for (int i = h - 1; i < size; ++i) {
                long tmp = a[i + fromIndex];
                int j = i;
                for (j = i; j >= h && tmp < a[j - h + fromIndex]; j -= h) {
                    a[j + fromIndex] = a[j - h + fromIndex];
                }
                a[j + fromIndex] = tmp;
            }
            h /= 3;
        }
    }

    public static void sort(float[] a) {
        ShellSort_1x0.sort(a, 0, a.length);
    }

    public static void sort(float[] a, int fromIndex, int toIndex) {
        int size = toIndex - fromIndex;
        int h = 1;
        while (h * 3 + 1 < size) {
            h = 3 * h + 1;
        }
        while (h > 0) {
            for (int i = h - 1; i < size; ++i) {
                float tmp = a[i + fromIndex];
                int j = i;
                for (j = i; j >= h && tmp < a[j - h + fromIndex]; j -= h) {
                    a[j + fromIndex] = a[j - h + fromIndex];
                }
                a[j + fromIndex] = tmp;
            }
            h /= 3;
        }
    }

    public static void sort(double[] a) {
        ShellSort_1x0.sort(a, 0, a.length);
    }

    public static void sort(double[] a, int fromIndex, int toIndex) {
        int size = toIndex - fromIndex;
        int h = 1;
        while (h * 3 + 1 < size) {
            h = 3 * h + 1;
        }
        while (h > 0) {
            for (int i = h - 1; i < size; ++i) {
                double tmp = a[i + fromIndex];
                int j = i;
                for (j = i; j >= h && tmp < a[j - h + fromIndex]; j -= h) {
                    a[j + fromIndex] = a[j - h + fromIndex];
                }
                a[j + fromIndex] = tmp;
            }
            h /= 3;
        }
    }

    public static void sort(char[] a) {
        ShellSort_1x0.sort(a, 0, a.length);
    }

    public static <T> void sort(char[] a, int fromIndex, int toIndex) {
        int size = toIndex - fromIndex;
        int h = 1;
        while (h * 3 + 1 < size) {
            h = 3 * h + 1;
        }
        while (h > 0) {
            for (int i = h - 1; i < size; ++i) {
                char tmp = a[i + fromIndex];
                int j = i;
                for (j = i; j >= h && tmp < a[j - h + fromIndex]; j -= h) {
                    a[j + fromIndex] = a[j - h + fromIndex];
                }
                a[j + fromIndex] = tmp;
            }
            h /= 3;
        }
    }
}

