/*
 * Decompiled with CFR 0.152.
 */
package org.happy.commons.io.streams.decorators;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.happy.commons.concurrent.ConcurrentUtils_1x2;
import org.happy.commons.io.streams.decorators.InputStreamDecorator_1x2;
import org.happy.commons.patterns.Stoppable_1x3;

public class StoppableInputStream_1x3
extends InputStreamDecorator_1x2
implements Stoppable_1x3<Boolean> {
    private Set<CountDownLatch> latchesSet = new HashSet<CountDownLatch>();
    private ExecutorService executor;
    private AtomicBoolean stoped = new AtomicBoolean(false);
    private AtomicInteger lockObject = new AtomicInteger(0);

    public static StoppableInputStream_1x3 of(InputStream is) {
        return new StoppableInputStream_1x3(is);
    }

    public StoppableInputStream_1x3(InputStream is) {
        super(is);
        this.executor = ConcurrentUtils_1x2.createFixedExecutorService(1, this.getClass().getSimpleName() + "-Thread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        AtomicInteger atomicInteger = this.lockObject;
        synchronized (atomicInteger) {
            if (this.executor != null) {
                this.executor.shutdownNow();
            }
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        AtomicInteger atomicInteger = this.lockObject;
        synchronized (atomicInteger) {
            if (this.isStoped()) {
                return -1;
            }
        }
        final AtomicReference<Object> exceptionThrown = new AtomicReference<Object>(null);
        final CountDownLatch latch = this.createLatch();
        final AtomicInteger b = new AtomicInteger(0);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    b.set(StoppableInputStream_1x3.super.read());
                }
                catch (Exception e) {
                    exceptionThrown.set(e);
                }
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.removeLatch(latch);
        }
        if (exceptionThrown.get() != null) {
            throw new IllegalStateException(exceptionThrown.get());
        }
        if (this.stoped.get()) {
            return -1;
        }
        return b.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(final byte[] bytes) throws IOException {
        final AtomicInteger res = new AtomicInteger(0);
        final CountDownLatch latch = this.createLatch();
        final AtomicReference<Object> exceptionThrown = new AtomicReference<Object>(null);
        AtomicInteger atomicInteger = this.lockObject;
        synchronized (atomicInteger) {
            if (this.isStoped()) {
                return -1;
            }
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        res.set(StoppableInputStream_1x3.super.read(bytes));
                    }
                    catch (Exception e) {
                        exceptionThrown.set(e);
                    }
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.removeLatch(latch);
        }
        if (exceptionThrown.get() != null) {
            throw new IllegalStateException(exceptionThrown.get());
        }
        if (this.stoped.get()) {
            return -1;
        }
        return res.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(final byte[] bytes, final int off, final int len) throws IOException {
        AtomicInteger atomicInteger = this.lockObject;
        synchronized (atomicInteger) {
            if (this.isStoped()) {
                return -1;
            }
        }
        final AtomicReference<Object> exceptionThrown = new AtomicReference<Object>(null);
        final CountDownLatch latch = this.createLatch();
        final AtomicInteger res = new AtomicInteger(0);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    res.set(StoppableInputStream_1x3.super.read(bytes, off, len));
                }
                catch (Exception e) {
                    exceptionThrown.set(e);
                }
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.removeLatch(latch);
        }
        if (exceptionThrown.get() != null) {
            throw new IllegalStateException(exceptionThrown.get());
        }
        if (this.stoped.get()) {
            return -1;
        }
        return res.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CountDownLatch createLatch() {
        AtomicInteger atomicInteger = this.lockObject;
        synchronized (atomicInteger) {
            this.lockObject.incrementAndGet();
        }
        CountDownLatch latch = new CountDownLatch(1);
        Set<CountDownLatch> set = this.latchesSet;
        synchronized (set) {
            this.latchesSet.add(latch);
        }
        return latch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeLatch(CountDownLatch latch) {
        Object object = this.latchesSet;
        synchronized (object) {
            this.latchesSet.remove(latch);
        }
        object = this.lockObject;
        synchronized (object) {
            this.lockObject.decrementAndGet();
            this.lockObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean stop() {
        this.stoped.set(true);
        Object object = this.latchesSet;
        synchronized (object) {
            for (CountDownLatch latch : this.latchesSet) {
                latch.countDown();
            }
            this.latchesSet.clear();
        }
        object = this.lockObject;
        synchronized (object) {
            if (this.executor != null) {
                this.executor.shutdown();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForStop() throws InterruptedException {
        AtomicInteger atomicInteger = this.lockObject;
        synchronized (atomicInteger) {
            while (0 < this.lockObject.get()) {
                this.lockObject.wait();
            }
        }
    }

    public boolean isStoped() {
        return this.stoped.get();
    }

    @Override
    public Float getVersion() {
        return Float.valueOf(1.3f);
    }
}

