/*
 * Decompiled with CFR 0.152.
 */
package org.happy.collections.sets.decorators;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.happy.collections.decorators.BufferedCollection_1x0;
import org.happy.collections.sets.decorators.BufferedSet_1x0;
import org.happy.collections.sets.decorators.EventSortedSet_1x0;
import org.happy.commons.patterns.observer.event.ActionEventBefore_1x0;
import org.happy.commons.patterns.observer.listener.ActionListener_1x0;
import org.happy.commons.util.Pair_1x0;
import org.happy.commons.util.comparators.ObjectComparator;

public class BufferedSortedSet_1x0<E>
extends BufferedSet_1x0<E>
implements SortedSet<E> {
    private E first;
    private E last;
    private E toElement;
    private E fromElement;

    public static <E> BufferedSortedSet_1x0<E> of(SortedSet<E> decorateable) {
        return new BufferedSortedSet_1x0<E>(decorateable);
    }

    public BufferedSortedSet_1x0(SortedSet<E> decorateable) {
        this(decorateable, null, null);
    }

    protected BufferedSortedSet_1x0(SortedSet<E> decorateable, E fromElement, E toElement) {
        super(decorateable);
        this.fromElement = fromElement;
        this.toElement = toElement;
        this.updateFirstLastElements();
    }

    @Override
    protected void addCommand(Pair_1x0<E, BufferedCollection_1x0.Operation> command) {
        Preconditions.checkNotNull(command.getFst(), (Object)"element can't be null in a SortedSet");
        ObjectComparator c = this.comparator();
        if (c == null) {
            c = ObjectComparator.getSingelton();
        }
        E elem = command.getFst();
        Preconditions.checkState((boolean)BufferedSortedSet_1x0.checkIsInsideBoundries(elem, this.fromElement, this.toElement, c), (Object)"element should be inside boundries!");
        super.addCommand(command);
        if (BufferedCollection_1x0.Operation.Add.equals((Object)command.getSnd())) {
            int cmp;
            if (this.first == null) {
                this.first = elem;
            } else {
                cmp = c.compare(elem, this.first);
                if (cmp < 0) {
                    this.first = elem;
                }
            }
            if (this.last == null) {
                this.last = elem;
            } else {
                cmp = c.compare(elem, this.last);
                if (0 < cmp) {
                    this.last = elem;
                }
            }
        } else if (BufferedCollection_1x0.Operation.Remove.equals((Object)command.getSnd())) {
            this.updateFirstLastElements();
        } else {
            Preconditions.checkState((boolean)false, (Object)("there is no operation " + (Object)((Object)command.getSnd()) + " allowed!"));
        }
    }

    private void updateFirstLastElements() {
        ObjectComparator c = this.comparator();
        if (c == null) {
            c = ObjectComparator.getSingelton();
        }
        this.first = null;
        this.last = null;
        for (E e : this) {
            int cmp;
            if (this.first == null) {
                this.first = e;
            } else {
                cmp = c.compare(e, this.first);
                if (cmp < 0) {
                    this.first = e;
                }
            }
            if (this.last == null) {
                this.last = e;
                continue;
            }
            cmp = c.compare(e, this.last);
            if (0 >= cmp) continue;
            this.last = e;
        }
    }

    @Override
    public Comparator<? super E> comparator() {
        return ((SortedSet)this.decorated).comparator();
    }

    private SortedSet<E> decorateViewSet(final E fromElement, final E toElement, SortedSet<E> subSet) {
        final Comparator<E> comparator = subSet.comparator();
        EventSortedSet_1x0 eventSortedSet = EventSortedSet_1x0.of(new BufferedSortedSet_1x0<E>(subSet, fromElement, toElement){

            @Override
            protected void addCommand(Pair_1x0<E, BufferedCollection_1x0.Operation> command) {
                BufferedSortedSet_1x0.this.addCommand(command);
            }
        });
        eventSortedSet.getOnBeforeAddEvent().add(new ActionListener_1x0<ActionEventBefore_1x0<E>>(){

            @Override
            public void actionPerformedImpl(ActionEventBefore_1x0<E> event) {
                if (!BufferedSortedSet_1x0.checkIsInsideBoundries(event.getData(), fromElement, toElement, comparator)) {
                    throw new IllegalArgumentException("The element " + event.getData() + " is out of defined range of SortedSet!");
                }
            }
        });
        eventSortedSet.getOnBeforeRemoveEvent().add(new ActionListener_1x0<ActionEventBefore_1x0<E>>(){

            @Override
            public void actionPerformedImpl(ActionEventBefore_1x0<E> event) {
                if (!BufferedSortedSet_1x0.checkIsInsideBoundries(event.getData(), fromElement, toElement, comparator)) {
                    event.setCanceled(true);
                }
            }
        });
        return eventSortedSet;
    }

    private static <E> boolean checkIsInsideBoundries(E elem, E fromElement, E toElement, Comparator<? super E> c) {
        int cmp;
        if (elem == null) {
            throw new IllegalArgumentException("element can't be null in a SortedSet");
        }
        if (fromElement != null && 0 < (cmp = c.compare(fromElement, elem))) {
            return false;
        }
        return toElement == null || 0 > (cmp = c.compare(elem, toElement));
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        SortedSet<E> subSet = ((SortedSet)this.decorated).subSet(fromElement, toElement);
        return this.decorateViewSet(fromElement, toElement, subSet);
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        SortedSet<E> headSet = ((SortedSet)this.decorated).headSet(toElement);
        return this.decorateViewSet(null, toElement, headSet);
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        SortedSet<E> tailSet = ((SortedSet)this.decorated).tailSet(fromElement);
        return this.decorateViewSet(fromElement, null, tailSet);
    }

    @Override
    public E first() {
        return this.first;
    }

    @Override
    public E last() {
        return this.last;
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator itDecorated = ((Collection)this.decorated).iterator();
        final HashMap transactionObjectMapCopy = new HashMap();
        for (Map.Entry entry : this.objectMap.entrySet()) {
            transactionObjectMapCopy.put(entry.getKey(), new AtomicInteger(((AtomicInteger)entry.getValue()).get()));
        }
        TreeSet treeSet = new TreeSet(this.comparator());
        List createBufferList = this.createBufferList();
        treeSet.addAll(createBufferList);
        final Iterator<E> bufferIterator = treeSet.iterator();
        return new Iterator<E>(){
            private E nextElem = null;
            private boolean hasNextSolved = false;
            private boolean hasNext = false;
            private boolean nextExecuted = false;
            private E nextDecorated = null;
            private E nextBuffered = null;
            private Comparator<? super E> comparator = BufferedSortedSet_1x0.this.comparator();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                if (this.hasNextSolved) {
                    return this.hasNext;
                }
                try {
                    AtomicInteger value = (AtomicInteger)transactionObjectMapCopy.get(this.nextElem);
                    if (this.nextDecorated == null) {
                        while (itDecorated.hasNext()) {
                            this.nextDecorated = itDecorated.next();
                            if (value == null || value.get() >= 0) break;
                            value.decrementAndGet();
                        }
                    }
                    if (this.nextBuffered == null && bufferIterator.hasNext()) {
                        this.nextBuffered = bufferIterator.next();
                    }
                    this.hasNext = this.nextDecorated != null || this.nextBuffered != null;
                }
                finally {
                    this.hasNextSolved = true;
                }
                return this.hasNext;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("no more lements, the iterator has riched the end!");
                }
                this.nextExecuted = true;
                this.hasNextSolved = false;
                if (this.nextDecorated != null && this.nextBuffered != null) {
                    int cmp = this.comparator.compare(this.nextDecorated, this.nextBuffered);
                    if (cmp <= 0) {
                        this.nextElem = this.nextDecorated;
                        this.nextDecorated = null;
                    } else {
                        this.nextElem = this.nextBuffered;
                        this.nextBuffered = null;
                    }
                } else if (this.nextDecorated != null) {
                    this.nextElem = this.nextDecorated;
                    this.nextDecorated = null;
                } else if (this.nextBuffered != null) {
                    this.nextElem = this.nextBuffered;
                    this.nextBuffered = null;
                }
                return this.nextElem;
            }

            @Override
            public void remove() {
                if (!this.nextExecuted) {
                    throw new IllegalStateException("you have to excute iterator.next() before you can call remove() method");
                }
                AtomicInteger value = (AtomicInteger)transactionObjectMapCopy.get(this.nextElem);
                if (value != null) {
                    value.decrementAndGet();
                }
                BufferedSortedSet_1x0.this.addCommand(new Pair_1x0(this.nextElem, BufferedCollection_1x0.Operation.Remove));
                this.nextExecuted = false;
            }
        };
    }
}

