/*
 * Decompiled with CFR 0.152.
 */
package org.happy.collections.maps;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.happy.commons.patterns.version.Version_1x0;

public class DataMap_1x2<K, V>
extends AbstractMap<K, V>
implements Version_1x0<Float> {
    private DataAdapter<K, V> adapter;
    private int fetchElementsNumberPerRequest;

    public static <K, V> DataMap_1x2<K, V> of(DataAdapter<K, V> adapter, int fetchElementsNumberPerRequest) {
        return new DataMap_1x2<K, V>(adapter, fetchElementsNumberPerRequest);
    }

    public DataMap_1x2(DataAdapter<K, V> mapper, int fetchElementsNumberPerRequest) {
        Preconditions.checkNotNull(mapper);
        Preconditions.checkArgument((0 < fetchElementsNumberPerRequest ? 1 : 0) != 0);
        this.adapter = mapper;
        this.fetchElementsNumberPerRequest = fetchElementsNumberPerRequest;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private int startIndex = 0;
                    private int endIndex;
                    private boolean freshLoaded;
                    Iterator<Map.Entry<K, V>> it;
                    private Map.Entry<K, V> current;
                    private int removedElements;
                    {
                        this.endIndex = DataMap_1x2.this.fetchElementsNumberPerRequest;
                        this.freshLoaded = false;
                        this.it = this.loadIterator();
                        this.removedElements = 0;
                    }

                    @Override
                    public void remove() {
                        Preconditions.checkState((this.current != null ? 1 : 0) != 0, (Object)"the current element is null ant can't be removed, call next() and then remove() again!");
                        boolean changed = DataMap_1x2.this.adapter.remove(this.current.getKey());
                        Preconditions.checkState((boolean)changed, (Object)("there was a problem during deleting of the mdoel with id = " + this.current.getKey()));
                        ++this.removedElements;
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        if (!this.it.hasNext()) {
                            if (this.freshLoaded) {
                                this.it.next();
                            }
                            this.it = this.loadIterator();
                        }
                        this.current = this.it.next();
                        Preconditions.checkState((this.current != null ? 1 : 0) != 0, (Object)"model can't be null at this state!");
                        this.freshLoaded = false;
                        return this.current;
                    }

                    @Override
                    public boolean hasNext() {
                        if (!this.it.hasNext() && !this.freshLoaded) {
                            this.it = this.loadIterator();
                        }
                        return this.it.hasNext();
                    }

                    private Iterator<Map.Entry<K, V>> loadIterator() {
                        this.startIndex -= this.removedElements;
                        this.endIndex -= this.removedElements;
                        this.freshLoaded = true;
                        Collection entryCollection = DataMap_1x2.this.adapter.getBetween(this.startIndex, this.endIndex);
                        if (entryCollection == null) {
                            return new ArrayList(0).iterator();
                        }
                        this.startIndex = this.endIndex;
                        this.endIndex += DataMap_1x2.this.fetchElementsNumberPerRequest;
                        this.removedElements = 0;
                        return ImmutableList.copyOf(entryCollection).iterator();
                    }
                };
            }

            @Override
            public int size() {
                return DataMap_1x2.this.adapter.size();
            }

            @Override
            public boolean contains(Object o) {
                if (o == null || !(o instanceof Map.Entry)) {
                    return false;
                }
                boolean containsKey = DataMap_1x2.this.adapter.containsKey(((Map.Entry)o).getKey());
                if (!containsKey) {
                    return false;
                }
                boolean containsValue = DataMap_1x2.this.adapter.containsValue(((Map.Entry)o).getValue());
                return containsValue;
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                return super.removeAll(c);
            }

            @Override
            public boolean remove(Object o) {
                if (!this.contains(o)) {
                    return false;
                }
                if (o == null || !(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                return DataMap_1x2.this.adapter.remove(entry.getKey());
            }

            @Override
            public void clear() {
                DataMap_1x2.this.adapter.clear();
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){
            private Set<Map.Entry<K, V>> entrySet;
            {
                this.entrySet = DataMap_1x2.this.entrySet();
            }

            @Override
            public Iterator<V> iterator() {
                final Iterator it = this.entrySet.iterator();
                return new Iterator<V>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public V next() {
                        Map.Entry v = (Map.Entry)it.next();
                        Preconditions.checkState((v != null ? 1 : 0) != 0, (Object)"value can't be null!");
                        return v.getValue();
                    }

                    @Override
                    public void remove() {
                        it.remove();
                    }
                };
            }

            @Override
            public int size() {
                return this.entrySet.size();
            }

            @Override
            public void clear() {
                DataMap_1x2.this.adapter.clear();
            }
        };
    }

    @Override
    public V remove(Object key) {
        V old = this.adapter.get(key);
        boolean changed = this.adapter.remove(key);
        if (!changed) {
            return null;
        }
        return old;
    }

    @Override
    public V put(K key, V value) throws IllegalArgumentException, IllegalStateException {
        return this.adapter.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (m == null) {
            return;
        }
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.adapter.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.adapter.containsValue(value);
    }

    @Override
    public Float getVersion() {
        return Float.valueOf(1.0f);
    }

    public DataAdapter<K, V> getAdapter() {
        return this.adapter;
    }

    public void setAdapter(DataAdapter<K, V> mapper) {
        this.adapter = mapper;
    }

    public int getFetchElementsNumberPerRequest() {
        return this.fetchElementsNumberPerRequest;
    }

    public void setFetchElementsNumberPerRequest(int fetchElementsNumberPerRequest) {
        this.fetchElementsNumberPerRequest = fetchElementsNumberPerRequest;
    }

    public static interface DataAdapter<K, V> {
        public boolean remove(Object var1);

        public Collection<Map.Entry<K, V>> getBetween(int var1, int var2);

        public int size();

        public V get(Object var1);

        public void clear();

        public V put(K var1, V var2);

        public boolean containsKey(Object var1);

        public boolean containsValue(Object var1);
    }
}

