/*
 * Decompiled with CFR 0.152.
 */
package org.happy.collections.lists.decorators;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.happy.collections.decorators.UnmodifiableStrategy_1x0;
import org.happy.collections.lists.decorators.EventList_1x0;
import org.happy.collections.lists.decorators.ListDecorator_1x0;
import org.happy.commons.patterns.observer.Delegate_1x0Impl;
import org.happy.commons.patterns.observer.event.ActionEventAfter_1x0;

public class UnmodifiableList_1x0<E>
extends ListDecorator_1x0<E, List<E>> {
    private EventList_1x0<E> eventList;
    private Delegate_1x0Impl<ActionEventAfter_1x0<UnmodifiableStrategy_1x0>> onStrategyChanged = null;
    private UnmodifiableStrategy_1x0 strategy;
    protected ActionListener beforeAddListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            throw new UnsupportedOperationException("The collection can't be modified! Choose another strategy as " + UnmodifiableList_1x0.this.strategy.toString() + ", if you want to add elements");
        }
    };
    protected ActionListener beforeRemoveListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            throw new UnsupportedOperationException("The collection can't be modified! Choose another strategy as " + UnmodifiableList_1x0.this.strategy.toString() + ", if you want to reove elements");
        }
    };

    public static <E> UnmodifiableList_1x0<E> of(List<E> decorateable) {
        return new UnmodifiableList_1x0<E>(decorateable);
    }

    public static <E> UnmodifiableList_1x0<E> of(List<E> decorateable, UnmodifiableStrategy_1x0 strategy) {
        return new UnmodifiableList_1x0<E>(decorateable, strategy);
    }

    public UnmodifiableList_1x0(List<E> list) {
        this(list, UnmodifiableStrategy_1x0.Unmodifiable);
    }

    public UnmodifiableList_1x0(List<E> list, UnmodifiableStrategy_1x0 strategy) {
        super(list);
        this.eventList = EventList_1x0.of(list);
        this.setStrategy(strategy);
    }

    protected void removeAllListeners() {
        this.eventList.getOnBeforeAddEvent().remove(this.beforeAddListener);
        this.eventList.getOnBeforeRemoveEvent().remove(this.beforeRemoveListener);
        this.eventList.getOnBeforeClearEvent().remove(this.beforeRemoveListener);
    }

    public UnmodifiableStrategy_1x0 getStrategy() {
        return this.strategy;
    }

    public void setStrategy(UnmodifiableStrategy_1x0 strategy) {
        boolean strategyHasChanged = false;
        strategyHasChanged = this.strategy == null ? true : !this.strategy.equals(strategy);
        this.strategy = strategy;
        this.removeAllListeners();
        if (UnmodifiableStrategy_1x0.RemoveAllowed.equals(this.strategy) || UnmodifiableStrategy_1x0.Unmodifiable.equals(this.strategy)) {
            this.eventList.getOnBeforeAddEvent().add(this.beforeAddListener);
        }
        if (UnmodifiableStrategy_1x0.AddAllowed.equals(this.strategy) || UnmodifiableStrategy_1x0.Unmodifiable.equals(this.strategy)) {
            this.eventList.getOnBeforeRemoveEvent().add(this.beforeRemoveListener);
            this.eventList.getOnBeforeClearEvent().add(this.beforeRemoveListener);
        }
        if (strategyHasChanged) {
            this.fireOnStrategyChanged(strategy);
        }
    }

    protected void fireOnStrategyChanged(UnmodifiableStrategy_1x0 newStragegy) {
        if (this.onStrategyChanged == null) {
            return;
        }
        this.onStrategyChanged.fire(new ActionEventAfter_1x0<UnmodifiableStrategy_1x0>((Object)this, 0, "unmodifiable-strategy has changed", newStragegy));
    }

    public Delegate_1x0Impl<ActionEventAfter_1x0<UnmodifiableStrategy_1x0>> getOnStrategyChanged() {
        if (this.onStrategyChanged == null) {
            this.onStrategyChanged = new Delegate_1x0Impl();
        }
        return this.onStrategyChanged;
    }

    @Override
    protected ListIterator<E> listIteratorImpl(int index) {
        throw new Error("this code shuold be never called, because the listIterator() - method is overriden");
    }

    @Override
    protected Iterator<E> iteratorImpl() {
        throw new Error("this code shuold be never called, because the listIterator() - method is overriden");
    }

    @Override
    public void setDecorated(List<E> decorated) {
        this.eventList.setDecorated(decorated);
        super.setDecorated(decorated);
    }

    @Override
    public void add(int index, E o) {
        this.eventList.add(index, o);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.eventList.addAll(index, c);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.eventList.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.eventList.listIterator(index);
    }

    @Override
    public E remove(int index) {
        return this.eventList.remove(index);
    }

    @Override
    public E set(int index, E o) {
        return this.eventList.set(index, o);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.eventList.subList(fromIndex, toIndex);
    }

    @Override
    public boolean add(E o) {
        return this.eventList.add(o);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.eventList.addAll(c);
    }

    @Override
    public void clear() {
        this.eventList.clear();
    }

    @Override
    public boolean remove(Object o) {
        return this.eventList.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.eventList.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.eventList.retainAll(c);
    }

    @Override
    public Iterator<E> iterator() {
        return this.eventList.iterator();
    }
}

