/*
 * Decompiled with CFR 0.152.
 */
package org.happy.collections.decorators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.happy.collections.decorators.CollectionDecorator_1x0;
import org.happy.collections.decorators.iterators.IteratorDecorator_1x0;
import org.happy.commons.patterns.observer.Delegate_1x0;
import org.happy.commons.patterns.observer.Delegate_1x0Impl;
import org.happy.commons.patterns.observer.event.ActionEventAfter_1x0;
import org.happy.commons.patterns.observer.event.ActionEventBefore_1x0;
import org.happy.commons.patterns.observer.listener.ActionListener_1x0;
import org.happy.commons.util.ObjectPointer_1x0;

public class EventCollection_1x0<E>
extends CollectionDecorator_1x0<E, Collection<E>> {
    private boolean iteratorLock = false;
    protected static int eventID = 0;
    public static final String CM_BEFORE_ADD = "before add";
    public static final String CM_AFTER_ADD = "after add";
    public static final String CM_BEFORE_REMOVE = "before remove";
    public static final String CM_AFTER_REMOVE = "after remove";
    public static final String CM_BEFORE_CLEAR = "before clear";
    public static final String CM_AFTER_CLEAR = "after clear";
    public static final String CM_BEFORE_GET = "before get";
    public static final String CM_AFTER_GET = "after get";
    protected Delegate_1x0<ActionEventBefore_1x0<E>> onBeforeAddEvent = null;
    protected Delegate_1x0<ActionEventAfter_1x0<E>> onAfterAddEvent = null;
    protected Delegate_1x0<ActionEventBefore_1x0<Collection<E>>> onBeforeClearEvent = null;
    protected Delegate_1x0<ActionEventAfter_1x0<Collection<E>>> onAfterClearEvent = null;
    protected Delegate_1x0<ActionEventBefore_1x0<E>> onBeforeRemoveEvent = null;
    protected Delegate_1x0<ActionEventAfter_1x0<E>> onAfterRemoveEvent = null;
    protected Delegate_1x0<ActionEventBefore_1x0<E>> onBeforeModifyEvent = null;
    protected Delegate_1x0<ActionEventAfter_1x0<E>> onAfterModifyEvent = null;
    protected Delegate_1x0<ActionEventBefore_1x0<E>> onBeforeGetEvent = null;
    protected Delegate_1x0<ActionEventAfter_1x0<E>> onAfterGetEvent = null;

    public static <E> EventCollection_1x0<E> of(Collection<E> c) {
        return new EventCollection_1x0<E>(c);
    }

    public static <E> EventCollection_1x0<E> of(Collection<E> c, boolean decorateIterators) {
        return new EventCollection_1x0<E>(c, decorateIterators);
    }

    public EventCollection_1x0(Collection<E> c) {
        this(c, true);
    }

    public EventCollection_1x0(Collection<E> c, boolean decorateIterators) {
        super(c, decorateIterators);
    }

    @Override
    public boolean add(E o) {
        if (this.iteratorLock) {
            return ((Collection)this.decorated).add(o);
        }
        ObjectPointer_1x0<E> p = ObjectPointer_1x0.of(o);
        if (this.fireOnBeforeAddEvent(p)) {
            return false;
        }
        o = p.getObject();
        boolean ret = ((Collection)this.decorated).add(o);
        if (!ret) {
            return false;
        }
        this.fireOnAfterAddEvent(o);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean r = false;
        for (E elem : c) {
            r = this.add(elem) || r;
        }
        return r;
    }

    @Override
    public void clear() {
        if (this.fireOnBeforeClearEvent()) {
            return;
        }
        ArrayList listCanceled = new ArrayList();
        ArrayList listRemoved = new ArrayList();
        ObjectPointer_1x0<Object> p = new ObjectPointer_1x0<Object>(null);
        for (Object obj : this) {
            p.setObject(obj);
            boolean canceled = this.fireOnBeforeRemoveEvent(p);
            obj = p.getObject();
            if (canceled) {
                listCanceled.add(obj);
                continue;
            }
            listRemoved.add(obj);
        }
        ((Collection)this.decorated).clear();
        if (0 < listCanceled.size()) {
            ((Collection)this.decorated).addAll(listCanceled);
        }
        if (this.onAfterRemoveEvent != null) {
            for (Object obj : listRemoved) {
                this.fireOnAfterRemoveEvent(obj);
            }
        }
        this.fireOnAfterClearEvent();
    }

    @Override
    public boolean remove(Object o) {
        if (this.iteratorLock) {
            return super.remove(o);
        }
        Object obj = o;
        ObjectPointer_1x0<Object> p = ObjectPointer_1x0.of(obj);
        if (this.fireOnBeforeRemoveEvent(p)) {
            return false;
        }
        obj = p.getObject();
        if (!this.contains(obj)) {
            return false;
        }
        boolean ret = ((Collection)this.decorated).remove(obj);
        this.fireOnAfterRemoveEvent(obj);
        return ret;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean r = false;
        for (Object elem : c) {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (elem == null || obj == null) {
                    if (elem != obj) continue;
                    it.remove();
                    r = true;
                    continue;
                }
                if (!elem.equals(obj)) continue;
                it.remove();
                r = true;
            }
        }
        return r;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        ArrayList list_toRemove = new ArrayList();
        for (Object obj : this) {
            if (c.contains(obj)) continue;
            list_toRemove.add(obj);
        }
        if (list_toRemove.size() <= 0) {
            return false;
        }
        for (Object obj : list_toRemove) {
            this.remove(obj);
        }
        return true;
    }

    protected IndexOutOfBoundsException checkIndex(int index) {
        int length = ((Collection)this.decorated).size();
        if (index < 0) {
            return new IndexOutOfBoundsException("index must be grater then 0");
        }
        if (length < index) {
            return new IndexOutOfBoundsException("index must be smaler then list.size()");
        }
        return null;
    }

    @Override
    public boolean contains(Object o) {
        ObjectPointer_1x0<Object> p = new ObjectPointer_1x0<Object>(o);
        if (this.fireOnBeforeGetEvent(p)) {
            return false;
        }
        o = p.getObject();
        boolean contains = ((Collection)this.decorated).contains(o);
        this.fireOnAfterGetEvent(o);
        return contains;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        ObjectPointer_1x0<Object> p = new ObjectPointer_1x0<Object>(null);
        ArrayList colToProof = new ArrayList();
        for (Object obj : c) {
            p.setObject(obj);
            if (this.fireOnBeforeGetEvent(p)) {
                return false;
            }
            colToProof.add(p.getObject());
        }
        boolean contains = ((Collection)this.decorated).containsAll(colToProof);
        for (Object obj : colToProof) {
            this.fireOnAfterGetEvent(obj);
        }
        return contains;
    }

    @Override
    protected Iterator<E> iteratorImpl() {
        IteratorDecorator_1x0 it = new IteratorDecorator_1x0<E>(super.iterator()){
            private E obj;

            @Override
            public E next() {
                ObjectPointer_1x0<Object> p;
                block1: {
                    p = ObjectPointer_1x0.of(null);
                    do {
                        this.obj = super.next();
                        p.setObject(this.obj);
                        if (!EventCollection_1x0.this.fireOnBeforeGetEvent(p)) break block1;
                    } while (super.hasNext());
                    throw new NoSuchElementException("the EventCollection.Iterator.next() caused runntime exception, because it reached the nunmberOfTasks of the collection, but couldn't return the last element because the get-operation for it was canceled in BeforeGetEvent!");
                }
                this.obj = p.getObject();
                EventCollection_1x0.this.fireOnAfterGetEvent(this.obj);
                return this.obj;
            }

            @Override
            public void remove() {
                ObjectPointer_1x0 p = ObjectPointer_1x0.of(this.obj);
                if (EventCollection_1x0.this.fireOnBeforeRemoveEvent(p)) {
                    return;
                }
                if (!(this.obj == p.getObject() || this.obj != null && this.obj.equals(p.getObject()))) {
                    throw new IllegalStateException("the object which should be removed was changed in the beforeRemoveEvent and can't be removed, because the iterator points to other object!!");
                }
                this.obj = p.getObject();
                EventCollection_1x0.this.iteratorLock = true;
                super.remove();
                EventCollection_1x0.this.iteratorLock = false;
                EventCollection_1x0.this.fireOnAfterRemoveEvent(this.obj);
            }
        };
        return it;
    }

    @Override
    public Object[] toArray() {
        if (this.onBeforeGetEvent != null) {
            ArrayList c = new ArrayList();
            ObjectPointer_1x0<Object> p = ObjectPointer_1x0.of(null);
            for (Object obj : this) {
                p.setObject(obj);
                if (this.fireOnBeforeGetEvent(p)) continue;
                obj = p.getObject();
                c.add(obj);
            }
            for (Object e : c) {
                this.fireOnAfterGetEvent(e);
            }
            return c.toArray();
        }
        for (Object e : this) {
        }
        return super.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length == 0) {
            return super.toArray(a);
        }
        Object[] arr = this.toArray();
        Arrays.fill(a, null);
        for (int i = 0; i < a.length && i < arr.length; ++i) {
            a[i] = arr[i];
        }
        return a;
    }

    protected boolean fireOnBeforeAddEvent(ObjectPointer_1x0<E> p) {
        if (this.onBeforeAddEvent != null && 0 < this.onBeforeAddEvent.getListenerCount()) {
            ActionEventBefore_1x0<E> e = new ActionEventBefore_1x0<E>(this, eventID++, CM_BEFORE_ADD);
            e.setData(p.getObject());
            this.onBeforeAddEvent.fire(e);
            p.setObject(e.getData());
            return e.isCanceled();
        }
        return false;
    }

    protected void fireOnAfterAddEvent(E obj) {
        if (this.onAfterAddEvent != null && 0 < this.onAfterAddEvent.getListenerCount()) {
            ActionEventAfter_1x0<E> e = new ActionEventAfter_1x0<E>(this, eventID++, CM_AFTER_ADD);
            e.setData(obj);
            this.onAfterAddEvent.fire(e);
        }
    }

    protected boolean fireOnBeforeClearEvent() {
        if (this.onBeforeClearEvent != null && 0 < this.onBeforeClearEvent.getListenerCount()) {
            ActionEventBefore_1x0<EventCollection_1x0> e = new ActionEventBefore_1x0<EventCollection_1x0>(this, eventID++, CM_BEFORE_CLEAR);
            e.setData(this);
            this.onBeforeClearEvent.fire(e);
            return e.isCanceled();
        }
        return false;
    }

    protected void fireOnAfterClearEvent() {
        if (this.onAfterClearEvent != null && 0 < this.onAfterClearEvent.getListenerCount()) {
            ActionEventAfter_1x0<EventCollection_1x0> e = new ActionEventAfter_1x0<EventCollection_1x0>(this, eventID++, CM_AFTER_CLEAR);
            e.setData(this);
            this.onAfterClearEvent.fire(e);
        }
    }

    protected boolean fireOnBeforeRemoveEvent(ObjectPointer_1x0<E> p) {
        if (this.onBeforeRemoveEvent != null && 0 < this.onBeforeRemoveEvent.getListenerCount()) {
            ActionEventBefore_1x0<E> e = new ActionEventBefore_1x0<E>(this, eventID++, CM_BEFORE_REMOVE);
            e.setData(p.getObject());
            this.onBeforeRemoveEvent.fire(e);
            p.setObject(e.getData());
            return e.isCanceled();
        }
        return false;
    }

    protected void fireOnAfterRemoveEvent(E obj) {
        if (this.onAfterRemoveEvent != null && 0 < this.onAfterRemoveEvent.getListenerCount()) {
            ActionEventAfter_1x0<E> e = new ActionEventAfter_1x0<E>(this, eventID++, CM_AFTER_REMOVE);
            e.setData(obj);
            this.onAfterRemoveEvent.fire(e);
        }
    }

    protected boolean fireOnBeforeGetEvent(ObjectPointer_1x0<E> p) {
        if (this.onBeforeGetEvent != null && 0 < this.onBeforeGetEvent.getListenerCount()) {
            ActionEventBefore_1x0<E> e = new ActionEventBefore_1x0<E>(this, eventID++, CM_BEFORE_GET);
            e.setData(p.getObject());
            this.onBeforeGetEvent.fire(e);
            p.setObject(e.getData());
            return e.isCanceled();
        }
        return false;
    }

    protected void fireOnAfterGetEvent(E obj) {
        if (this.onAfterGetEvent != null && 0 < this.onAfterGetEvent.getListenerCount()) {
            ActionEventAfter_1x0<E> e = new ActionEventAfter_1x0<E>(this, eventID++, CM_AFTER_GET);
            e.setData(obj);
            this.onAfterGetEvent.fire(e);
        }
    }

    public Delegate_1x0<ActionEventBefore_1x0<E>> getOnBeforeAddEvent() {
        if (this.onBeforeAddEvent == null) {
            this.onBeforeAddEvent = new Delegate_1x0Impl<ActionEventBefore_1x0<E>>();
        }
        return this.onBeforeAddEvent;
    }

    public Delegate_1x0<ActionEventAfter_1x0<E>> getOnAfterAddEvent() {
        if (this.onAfterAddEvent == null) {
            this.onAfterAddEvent = new Delegate_1x0Impl<ActionEventAfter_1x0<E>>();
        }
        return this.onAfterAddEvent;
    }

    public Delegate_1x0<ActionEventBefore_1x0<Collection<E>>> getOnBeforeClearEvent() {
        if (this.onBeforeClearEvent == null) {
            this.onBeforeClearEvent = new Delegate_1x0Impl<ActionEventBefore_1x0<Collection<E>>>();
        }
        return this.onBeforeClearEvent;
    }

    public Delegate_1x0<ActionEventAfter_1x0<Collection<E>>> getOnAfterClearEvent() {
        if (this.onAfterClearEvent == null) {
            this.onAfterClearEvent = new Delegate_1x0Impl<ActionEventAfter_1x0<Collection<E>>>();
        }
        return this.onAfterClearEvent;
    }

    public Delegate_1x0<ActionEventBefore_1x0<E>> getOnBeforeRemoveEvent() {
        if (this.onBeforeRemoveEvent == null) {
            this.onBeforeRemoveEvent = new Delegate_1x0Impl<ActionEventBefore_1x0<E>>();
        }
        return this.onBeforeRemoveEvent;
    }

    public Delegate_1x0<ActionEventAfter_1x0<E>> getOnAfterRemoveEvent() {
        if (this.onAfterRemoveEvent == null) {
            this.onAfterRemoveEvent = new Delegate_1x0Impl<ActionEventAfter_1x0<E>>();
        }
        return this.onAfterRemoveEvent;
    }

    public Delegate_1x0<ActionEventBefore_1x0<E>> getOnBeforeModifyEvent() {
        if (this.onBeforeModifyEvent == null) {
            this.onBeforeModifyEvent = new Delegate_1x0Impl<ActionEventBefore_1x0<E>>();
            this.getOnBeforeAddEvent().add(new ActionListener_1x0<ActionEventBefore_1x0<E>>(){

                @Override
                public void actionPerformedImpl(ActionEventBefore_1x0<E> event) {
                    EventCollection_1x0.this.onBeforeModifyEvent.fire(event);
                }
            });
            this.getOnBeforeRemoveEvent().add(new ActionListener_1x0<ActionEventBefore_1x0<E>>(){

                @Override
                public void actionPerformedImpl(ActionEventBefore_1x0<E> event) {
                    EventCollection_1x0.this.onBeforeModifyEvent.fire(event);
                }
            });
        }
        return this.onBeforeModifyEvent;
    }

    public Delegate_1x0<ActionEventAfter_1x0<E>> getOnAfterModifyEvent() {
        if (this.onAfterModifyEvent == null) {
            this.onAfterModifyEvent = new Delegate_1x0Impl<ActionEventAfter_1x0<E>>();
            this.getOnAfterAddEvent().add(new ActionListener_1x0<ActionEventAfter_1x0<E>>(){

                @Override
                public void actionPerformedImpl(ActionEventAfter_1x0<E> event) {
                    EventCollection_1x0.this.onAfterModifyEvent.fire(event);
                }
            });
            this.getOnAfterRemoveEvent().add(new ActionListener_1x0<ActionEventAfter_1x0<E>>(){

                @Override
                public void actionPerformedImpl(ActionEventAfter_1x0<E> event) {
                    EventCollection_1x0.this.onAfterModifyEvent.fire(event);
                }
            });
        }
        return this.onAfterModifyEvent;
    }

    public Delegate_1x0<ActionEventBefore_1x0<E>> getOnBeforeGetEvent() {
        if (this.onBeforeGetEvent == null) {
            this.onBeforeGetEvent = new Delegate_1x0Impl<ActionEventBefore_1x0<E>>();
        }
        return this.onBeforeGetEvent;
    }

    public Delegate_1x0<ActionEventAfter_1x0<E>> getOnAfterGetEvent() {
        if (this.onAfterGetEvent == null) {
            this.onAfterGetEvent = new Delegate_1x0Impl<ActionEventAfter_1x0<E>>();
        }
        return this.onAfterGetEvent;
    }
}

