/*
 * Decompiled with CFR 0.152.
 */
package motifSets;

import java.util.ArrayList;
import motifSets.ClusterMK;
import motifSets.Distance;
import motifSets.ScanMK;
import motifSets.SetFinder;
import motifSets.SlidingWindow;

public class Experiments {
    public static void main(String[] args) {
        String dataSet = "data/time_series_0.csv";
        int w = 50;
        double r = Math.sqrt(0.8);
        int topK = 5;
        for (String arg : args) {
            String[] stringArray = arg.split("=");
            if (stringArray[0].compareTo("w") == 0) {
                w = Integer.parseInt(stringArray[1]);
                continue;
            }
            if (stringArray[0].compareTo("r") == 0) {
                r = Math.sqrt(Double.parseDouble(stringArray[1]));
                continue;
            }
            if (stringArray[0].compareTo("k") != 0) continue;
            topK = Integer.parseInt(stringArray[1]);
        }
        double[][] data = SlidingWindow.loadSegments(dataSet, w);
        System.out.println("\nScan MK");
        ScanMK smk = new ScanMK(data, w, r, topK);
        smk.scanTimeSeries();
        ArrayList<ArrayList<Integer>> sets = smk.getMotifSet();
        for (ArrayList arrayList : sets) {
            for (Integer n : arrayList) {
                System.out.print(n + " ");
            }
            System.out.println("next");
        }
        System.out.println("end");
        Experiments.checkPairWiseDistances(sets, data, r);
        System.out.println("\nSet Finder");
        SetFinder sf = new SetFinder(data, r, w);
        sf.findMotifSets();
        sets = sf.getMotifSet();
        for (ArrayList<Integer> arrayList : sets) {
            for (Integer s : arrayList) {
                System.out.print(s + " ");
            }
            System.out.println("next");
        }
        System.out.println("end");
        Experiments.checkPairWiseDistances(sets, data, r);
        System.out.println("\nCluster MK");
        ClusterMK clusterMK = new ClusterMK(data, w, r);
        sets = clusterMK.getMotifSet();
        for (ArrayList<Integer> arrayList : sets) {
            for (Integer s : arrayList) {
                System.out.print(s + " ");
            }
            System.out.println("next");
        }
        System.out.println("end");
        Experiments.checkPairWiseDistances(sets, data, r);
    }

    public static void checkPairWiseDistances(ArrayList<ArrayList<Integer>> motifSets, double[][] data, double r) {
        for (ArrayList<Integer> set : motifSets) {
            for (Integer offset : set) {
                for (Integer offset2 : set) {
                    double[] seq2;
                    double[] seq1;
                    double dist;
                    if (offset.equals(offset2) || offset >= data.length || offset2 >= data.length || !((dist = Distance.distanceEuclidean(seq1 = data[offset], seq2 = data[offset2])) > 2.0 * r)) continue;
                    System.err.println("Motif error:" + offset + " " + offset2 + " " + dist);
                }
            }
        }
    }
}

