/*
 * Decompiled with CFR 0.152.
 */
package motifSets;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import motifSets.MK;

public class ClusterMK {
    private ArrayList<ClusterNode> tree = new ArrayList();
    private double[][] data;
    private int count;
    private int w;
    private double r;
    private ArrayList<ArrayList<Integer>> motifSet;

    public ClusterMK(double[][] data, int w, double r) {
        int i;
        MK mk;
        this.w = w;
        this.r = r;
        this.data = data;
        this.count = 0;
        while (this.count < this.data.length) {
            this.tree.add(new ClusterNode(this.data[this.count], this.count));
            ++this.count;
        }
        ArrayList<ClusterNode> temp = this.traverse();
        while (this.data.length > 1 && !((mk = new MK(this.data, 1, w)).getDistance() > r)) {
            double[] avg = this.merge(temp.get(mk.getLocations()[0]).getPosition(), temp.get(mk.getLocations()[1]).getPosition());
            int[] cur = this.changeLocations(mk, temp);
            this.tree.add(new ClusterNode(avg, mk.getDistance(), cur, this.count, this.getChildren(cur)));
            this.tree.get(cur[0]).setParent(this.count);
            this.tree.get(cur[1]).setParent(this.count);
            ++this.count;
            temp = this.traverse();
            this.data = this.formData(temp);
        }
        ArrayList<ArrayList<Integer>> clus = new ArrayList<ArrayList<Integer>>();
        for (i = 0; i < this.tree.size(); ++i) {
            if (this.tree.get(i).isLeaf() || this.tree.get(i).getParent() != -1) continue;
            ArrayList tmp = this.getLeaves(this.tree.get(i));
            tmp.add(0, i);
            clus.add(tmp);
        }
        for (i = 0; i < clus.size(); ++i) {
            clus.add(i, this.removeTrivialMatches((ArrayList)clus.get(i)));
            clus.remove(i + 1);
        }
        clus = this.sortBySize(clus);
        clus = this.removeOverlap(clus, 29);
        for (i = 0; i < clus.size(); ++i) {
            if (clus.get(i).size() >= 2) continue;
            clus.remove(i);
            --i;
        }
        this.motifSet = clus;
    }

    public ArrayList<ArrayList<Integer>> getMotifSet() {
        return this.motifSet;
    }

    public int size() {
        return this.tree.size();
    }

    public ClusterNode get(int index) {
        return this.tree.get(index);
    }

    public ArrayList getTree() {
        return this.tree;
    }

    public ArrayList getLeaves(ClusterNode c) {
        ArrayList<Integer> temp = new ArrayList<Integer>();
        if (!c.isLeaf()) {
            temp.addAll(this.getLeaves(this.tree.get(c.getLocations()[0])));
            temp.addAll(this.getLeaves(this.tree.get(c.getLocations()[1])));
        } else {
            temp.add(c.getPosition());
        }
        return temp;
    }

    public void outputFile(String outFile) throws IOException {
        PrintWriter cout = new PrintWriter((Writer)new FileWriter(outFile), true);
        for (int i = 0; i < this.tree.size(); ++i) {
            if (this.tree.get(i).isLeaf()) continue;
            cout.println("Node " + i);
            cout.println("Parent: " + this.tree.get(i).getParent());
            cout.println("Child 1: " + this.tree.get(i).getLocations()[0]);
            cout.println("Child 2: " + this.tree.get(i).getLocations()[1]);
            cout.println("Distance: " + this.tree.get(i).getDistance());
            cout.println("-----------------------------");
        }
    }

    public final int getChildren(int[] index) {
        int num = this.tree.get(index[0]).getNoOfChildren() + this.tree.get(index[1]).getNoOfChildren();
        return num;
    }

    public final double[][] formData(ArrayList<ClusterNode> inp) {
        double[][] datum = new double[inp.size()][];
        for (int i = 0; i < inp.size(); ++i) {
            datum[i] = inp.get(i).getMotif();
        }
        return datum;
    }

    public final int[] changeLocations(MK mk, ArrayList<ClusterNode> temp) {
        int[] locs = new int[]{temp.get(mk.getLocations()[0]).getPosition(), temp.get(mk.getLocations()[1]).getPosition()};
        return locs;
    }

    public final ArrayList<ClusterNode> traverse() {
        ArrayList<ClusterNode> timeSeries = new ArrayList<ClusterNode>();
        for (int i = 0; i < this.tree.size(); ++i) {
            if (this.tree.get(i).getParent() != -1) continue;
            timeSeries.add(this.tree.get(i));
        }
        return timeSeries;
    }

    public final double[] merge(int one, int two) {
        double[] newDat = new double[this.tree.get(one).getMotif().length];
        int first = this.tree.get(one).getNoOfChildren();
        int second = this.tree.get(two).getNoOfChildren();
        ++first;
        ++second;
        for (int i = 0; i < newDat.length; ++i) {
            newDat[i] = (this.tree.get(one).getMotif()[i] * (double)first + this.tree.get(two).getMotif()[i] * (double)second) / (double)(first + second);
        }
        return newDat;
    }

    private ArrayList removeTrivialMatches(ArrayList orig) {
        int i;
        ArrayList rev = new ArrayList();
        for (i = orig.size() - 1; i >= 0; --i) {
            rev.add(orig.get(i));
        }
        for (i = 0; i < rev.size(); ++i) {
            for (int j = i + 1; j < rev.size(); ++j) {
                if (Math.abs((Integer)rev.get(i) - (Integer)rev.get(j)) >= this.w) continue;
                rev.remove(j);
                --j;
            }
        }
        return rev;
    }

    private ArrayList sortBySize(ArrayList<ArrayList<Integer>> clust) {
        ArrayList<ArrayList<Integer>> sorted = new ArrayList<ArrayList<Integer>>();
        int best = Integer.MIN_VALUE;
        int pos = -1;
        int num = clust.size();
        while (sorted.size() < num) {
            for (int i = 0; i < clust.size(); ++i) {
                if (clust.get(i).size() <= best) continue;
                pos = i;
                best = clust.get(i).size();
            }
            sorted.add(clust.get(pos));
            clust.remove(pos);
            best = Integer.MIN_VALUE;
            pos = -1;
        }
        return sorted;
    }

    private ArrayList<ArrayList<Integer>> removeOverlap(ArrayList<ArrayList<Integer>> clust, int n) {
        for (int i = 0; i < clust.size(); ++i) {
            for (int j = 0; j < clust.get(i).size(); ++j) {
                for (int k = i + 1; k < clust.size(); ++k) {
                    for (int l = 0; l < clust.get(k).size(); ++l) {
                        if (Math.abs(clust.get(i).get(j) - clust.get(k).get(l)) >= n) continue;
                        clust.get(k).remove(l);
                        --l;
                    }
                }
            }
        }
        return clust;
    }

    public class ClusterNode {
        private double[] motif;
        private boolean leaf;
        private double distance;
        private int[] locations;
        private int position;
        private int parent;
        private int noOfChildren;

        public ClusterNode(double[] data, int pos) {
            this.motif = data;
            this.leaf = true;
            this.distance = 0.0;
            this.locations = null;
            this.position = pos;
            this.parent = -1;
            this.noOfChildren = 0;
        }

        public ClusterNode(double[] motif, double dist, int[] loc, int pos, int child) {
            this.motif = motif;
            this.leaf = false;
            this.distance = dist;
            this.locations = loc;
            this.position = pos;
            this.parent = -1;
            this.noOfChildren = child;
        }

        public int getNoOfChildren() {
            return this.noOfChildren;
        }

        public void setNoOfChildren(int noOfChildren) {
            this.noOfChildren = noOfChildren;
        }

        public double getDistance() {
            return this.distance;
        }

        public void setDistance(double distance) {
            this.distance = distance;
        }

        public boolean isLeaf() {
            return this.leaf;
        }

        public void setLeaf(boolean leaf) {
            this.leaf = leaf;
        }

        public int[] getLocations() {
            return this.locations;
        }

        public double[] getMotif() {
            return this.motif;
        }

        public void setMotif(double[] motif) {
            this.motif = motif;
        }

        public int getParent() {
            return this.parent;
        }

        public void setParent(int parent) {
            this.parent = parent;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int position) {
            this.position = position;
        }

        public String toString() {
            return "" + this.position;
        }
    }
}

