/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax.parallel;

import net.seninp.jmotif.sax.NumerosityReductionStrategy;
import net.seninp.jmotif.sax.SAXProcessor;
import net.seninp.jmotif.sax.TSProcessor;
import net.seninp.jmotif.sax.alphabet.NormalAlphabet;
import net.seninp.jmotif.sax.datastructure.SAXRecords;
import net.seninp.jmotif.sax.parallel.ParallelSAXImplementation;
import org.junit.Assert;
import org.junit.Test;

public class TestParallelSAXImplementation {
    private static final String TEST_DATA = "src/resources/test-data/ecg0606_1.csv";
    private static final int[] THREADS_NUM = new int[]{2, 3, 4, 5};
    private static final int WINDOW_SIZE = 100;
    private static final int PAA_SIZE = 4;
    private static final int ALPHABET_SIZE = 3;
    private static final double NORM_THRESHOLD = 0.001;

    @Test
    public void testParallelSAXNONE() throws Exception {
        SAXProcessor sp = new SAXProcessor();
        NormalAlphabet na = new NormalAlphabet();
        double[] ts = TSProcessor.readFileColumn(TEST_DATA, 0, 0);
        SAXRecords sequentialRes = sp.ts2saxViaWindow(ts, 100, 4, na.getCuts(3), NumerosityReductionStrategy.NONE, 0.001);
        String sequentialString = sequentialRes.getSAXString(" ");
        ParallelSAXImplementation ps1 = new ParallelSAXImplementation();
        for (int threadsNum : THREADS_NUM) {
            SAXRecords parallelRes = ps1.process(ts, threadsNum, 100, 4, 3, NumerosityReductionStrategy.NONE, 0.001);
            String parallelStr = parallelRes.getSAXString(" ");
            if (sequentialString.equalsIgnoreCase(parallelStr)) {
                Assert.assertTrue("assert correctness", sequentialString.equalsIgnoreCase(parallelStr));
                continue;
            }
            String[] arr1 = sequentialString.split(" ");
            String[] arr2 = parallelStr.split(" ");
            for (int i = 0; i < Math.min(arr1.length, arr2.length); ++i) {
                if (arr1[i].equalsIgnoreCase(arr2[i])) continue;
                System.out.println("Error in index " + i + ", string " + arr1[i] + " versus " + arr2[i] + ", threads: " + threadsNum);
                Assert.assertTrue("assert correctness", arr1[i].equalsIgnoreCase(arr2[i]));
            }
        }
    }

    @Test
    public void testParallelSAXExact() throws Exception {
        SAXProcessor sp = new SAXProcessor();
        NormalAlphabet na = new NormalAlphabet();
        double[] ts = TSProcessor.readFileColumn(TEST_DATA, 0, 0);
        SAXRecords sequentialRes = sp.ts2saxViaWindow(ts, 100, 4, na.getCuts(3), NumerosityReductionStrategy.EXACT, 0.001);
        String sequentialString = sequentialRes.getSAXString(" ");
        ParallelSAXImplementation ps1 = new ParallelSAXImplementation();
        for (int threadsNum : THREADS_NUM) {
            SAXRecords parallelRes = ps1.process(ts, threadsNum, 100, 4, 3, NumerosityReductionStrategy.EXACT, 0.001);
            String parallelStr = parallelRes.getSAXString(" ");
            if (sequentialString.equalsIgnoreCase(parallelStr)) {
                Assert.assertTrue("assert correctness", sequentialString.equalsIgnoreCase(parallelStr));
                continue;
            }
            String[] arr1 = sequentialString.split(" ");
            String[] arr2 = parallelStr.split(" ");
            for (int i = 0; i < Math.min(arr1.length, arr2.length); ++i) {
                if (arr1[i].equalsIgnoreCase(arr2[i])) continue;
                System.out.println("Error in index " + i + ", string " + arr1[i] + " versus " + arr2[i] + ", threads: " + threadsNum);
                Assert.assertTrue("assert correctness", arr1[i].equalsIgnoreCase(arr2[i]));
            }
        }
    }

    @Test
    public void testParallelSAXMINDIST() throws Exception {
        SAXProcessor sp = new SAXProcessor();
        NormalAlphabet na = new NormalAlphabet();
        double[] ts = TSProcessor.readFileColumn(TEST_DATA, 0, 0);
        SAXRecords sequentialRes = sp.ts2saxViaWindow(ts, 100, 4, na.getCuts(3), NumerosityReductionStrategy.MINDIST, 0.001);
        String sequentialString = sequentialRes.getSAXString(" ");
        ParallelSAXImplementation ps1 = new ParallelSAXImplementation();
        for (int threadsNum : THREADS_NUM) {
            SAXRecords parallelRes = ps1.process(ts, threadsNum, 100, 4, 3, NumerosityReductionStrategy.MINDIST, 0.001);
            String parallelStr = parallelRes.getSAXString(" ");
            if (sequentialString.equalsIgnoreCase(parallelStr)) {
                Assert.assertTrue("assert correctness", sequentialString.equalsIgnoreCase(parallelStr));
                continue;
            }
            String[] arr1 = sequentialString.split(" ");
            String[] arr2 = parallelStr.split(" ");
            for (int i = 0; i < Math.min(arr1.length, arr2.length); ++i) {
                if (arr1[i].equalsIgnoreCase(arr2[i])) continue;
                System.out.println("Error in index " + i + ", string " + arr1[i] + " versus " + arr2[i] + ", threads: " + threadsNum);
                Assert.assertTrue("assert correctness", arr1[i].equalsIgnoreCase(arr2[i]));
            }
        }
    }

    @Test
    public void testParallelSAXrollbac() throws Exception {
        ParallelSAXImplementation ps1;
        SAXRecords parallelRes;
        String parallelStr;
        SAXProcessor sp = new SAXProcessor();
        NormalAlphabet na = new NormalAlphabet();
        int threadsNum = 10;
        int slidingWindowSize = 300;
        double[] ts = TSProcessor.readFileColumn(TEST_DATA, 0, 0);
        SAXRecords sequentialResMINDIST = sp.ts2saxViaWindow(ts, slidingWindowSize, 4, na.getCuts(3), NumerosityReductionStrategy.EXACT, 0.001);
        String sequentialStringMINDIST = sequentialResMINDIST.getSAXString(" ");
        if (sequentialStringMINDIST.equalsIgnoreCase(parallelStr = (parallelRes = (ps1 = new ParallelSAXImplementation()).process(ts, threadsNum, slidingWindowSize, 4, 3, NumerosityReductionStrategy.EXACT, 0.001)).getSAXString(" "))) {
            Assert.assertTrue("assert correctness", sequentialStringMINDIST.equalsIgnoreCase(parallelStr));
        } else {
            String[] arr1 = sequentialStringMINDIST.split(" ");
            String[] arr2 = parallelStr.split(" ");
            for (int i = 0; i < Math.min(arr1.length, arr2.length); ++i) {
                if (arr1[i].equalsIgnoreCase(arr2[i])) continue;
                System.out.println("Error in index " + i + ", string " + arr1[i] + " versus " + arr2[i] + ", threads: " + threadsNum);
                Assert.assertTrue("assert correctness", arr1[i].equalsIgnoreCase(arr2[i]));
            }
        }
    }
}

