/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax.parallel;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import net.seninp.jmotif.sax.NumerosityReductionStrategy;
import net.seninp.jmotif.sax.TSProcessor;
import net.seninp.jmotif.sax.datastructure.SAXRecords;
import net.seninp.jmotif.sax.parallel.ParallelSAXImplementation;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestParallelInterruption {
    private static double[] ts;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        FileInputStream fileStream = new FileInputStream("src/resources/dataset/300_signal1.txt.gz");
        GZIPInputStream gzipStream = new GZIPInputStream(fileStream);
        InputStreamReader decoder = new InputStreamReader((InputStream)gzipStream, "US-ASCII");
        BufferedReader buffered = new BufferedReader(decoder);
        ts = TSProcessor.readTS(buffered, 0, 10000);
    }

    @Test
    public void test() {
        ParallelSAXImplementation ps = new ParallelSAXImplementation();
        try {
            SAXRecords res = ps.process(ts, 2, 50, 5, 5, NumerosityReductionStrategy.NONE, 0.005);
            Thread.sleep(1L);
            ps.cancel();
        }
        catch (Exception e) {
            Assert.fail("Shouldn't throw any exception");
        }
    }
}

