/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax.motif;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.seninp.jmotif.distance.EuclideanDistance;
import net.seninp.jmotif.sax.SAXProcessor;
import net.seninp.jmotif.sax.TSProcessor;
import net.seninp.jmotif.sax.alphabet.NormalAlphabet;
import net.seninp.jmotif.sax.motif.MotifRecord;
import net.seninp.util.JmotifMapEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMMAImplementation {
    private static final Logger LOGGER = LoggerFactory.getLogger(EMMAImplementation.class);
    private static TSProcessor tp = new TSProcessor();
    private static SAXProcessor sp = new SAXProcessor();
    private static NormalAlphabet normalA = new NormalAlphabet();
    private static EuclideanDistance ed = new EuclideanDistance();
    public static int eaCounter;
    public static int distCounter;

    public static void calcIncrementalMeanStddev(int windowLength, double[] tsData, double[] means, double[] stds) {
        double sum = 0.0;
        double squareSum = 0.0;
        double rWindowLength = 1.0 / (double)windowLength;
        for (int ww = 0; ww < Math.min(tsData.length, windowLength); ++ww) {
            sum += tsData[ww];
            squareSum += tsData[ww] * tsData[ww];
        }
        means[0] = sum * rWindowLength;
        double buf = squareSum * rWindowLength - means[0] * means[0];
        stds[0] = buf > 0.0 ? Math.sqrt(buf) : 0.0;
        int end = tsData.length - windowLength + 1;
        for (int w = 1; w < end; ++w) {
            means[w] = (sum += tsData[w + windowLength - 1] - tsData[w - 1]) * rWindowLength;
            buf = (squareSum += tsData[w + windowLength - 1] * tsData[w + windowLength - 1] - tsData[w - 1] * tsData[w - 1]) * rWindowLength - means[w] * means[w];
            stds[w] = buf > 0.0 ? Math.sqrt(buf) : 0.0;
        }
    }

    public static MotifRecord series2EMMAMotifs(double[] series, int motifSize, double range, int paaSize, int alphabetSize, double znormThreshold) throws Exception {
        int size = series.length - motifSize + 1;
        double[] means = new double[size];
        double[] stddevs = new double[size];
        EMMAImplementation.calcIncrementalMeanStddev(motifSize, series, means, stddevs);
        MotifRecord res = new MotifRecord(-1, new ArrayList<Integer>());
        boolean finished = false;
        HashMap buckets = new HashMap((int)Math.pow(paaSize, alphabetSize));
        for (int i = 0; i < series.length - motifSize; ++i) {
            String sax = String.valueOf(tp.ts2String(tp.paa(tp.znorm(tp.subseriesByCopy(series, i, i + motifSize), means[i], stddevs[i], znormThreshold), paaSize), normalA.getCuts(alphabetSize)));
            if (null == buckets.get(sax)) {
                buckets.put(sax, new ArrayList());
            }
            ((ArrayList)buckets.get(sax)).add(i);
        }
        ArrayList bucketsOrder = new ArrayList(buckets.size());
        for (Map.Entry e : buckets.entrySet()) {
            bucketsOrder.add(new JmotifMapEntry(((ArrayList)e.getValue()).size(), e.getKey()));
        }
        Collections.sort(bucketsOrder, new Comparator<JmotifMapEntry<Integer, String>>(){

            @Override
            public int compare(JmotifMapEntry<Integer, String> a, JmotifMapEntry<Integer, String> b) {
                return b.getKey().compareTo(a.getKey());
            }
        });
        double[][] dm = normalA.getDistanceMatrix(alphabetSize);
        int currBucketIdx = 0;
        JmotifMapEntry MPC = (JmotifMapEntry)bucketsOrder.get(currBucketIdx);
        ArrayList<Integer> neighborhood = new ArrayList<Integer>((Collection)buckets.get(MPC.getValue()));
        while (!finished && currBucketIdx < bucketsOrder.size() && neighborhood.size() > 2) {
            if (currBucketIdx < bucketsOrder.size() - 1) {
                for (int i = currBucketIdx + 1; i < bucketsOrder.size(); ++i) {
                    String cWord = (String)((JmotifMapEntry)bucketsOrder.get(i)).getValue();
                    if (!(range > sp.saxMinDist(((String)MPC.getValue()).toCharArray(), cWord.toCharArray(), dm, motifSize, paaSize))) continue;
                    neighborhood.addAll((Collection)buckets.get(cWord));
                }
            }
            LOGGER.debug("current bucket {} at {}", MPC.getValue(), (Object)neighborhood);
            MotifRecord tmpRes = EMMAImplementation.ADM(series, neighborhood, motifSize, range, means, stddevs, znormThreshold);
            LOGGER.debug("current tmp motif {} ", (Object)tmpRes.toString());
            if (tmpRes.getFrequency() > res.getFrequency() || res.isEmpty()) {
                res = tmpRes;
                LOGGER.debug("updating the best motif to {} ", (Object)res.toString());
            } else if (tmpRes.getFrequency() == res.getFrequency() && !res.isEmpty()) {
                LOGGER.debug(" ** its's a tie, checking for variation...");
                double[] motifA = tp.subseriesByCopy(series, res.getLocation(), res.getLocation() + motifSize);
                double[] distancesA = new double[res.getFrequency()];
                double[] motifB = tp.subseriesByCopy(series, tmpRes.getLocation(), tmpRes.getLocation() + motifSize);
                double[] distancesB = new double[res.getFrequency()];
                ArrayList<Integer> bestMotifOccurrences = res.getOccurrences();
                ArrayList<Integer> tmpMotifOccurrences = tmpRes.getOccurrences();
                for (int j = 0; j < res.getFrequency(); ++j) {
                    double distB;
                    double distA;
                    Integer locA = bestMotifOccurrences.get(j);
                    distancesA[j] = distA = ed.distance(tp.znorm(motifA, znormThreshold), tp.znorm(tp.subseriesByCopy(series, locA, locA + motifSize), znormThreshold));
                    Integer locB = tmpMotifOccurrences.get(j);
                    distancesB[j] = distB = ed.distance(tp.znorm(motifB, znormThreshold), tp.znorm(tp.subseriesByCopy(series, locB, locB + motifSize), znormThreshold));
                }
                double varA = tp.var(distancesA);
                double varB = tp.var(distancesB);
                if (varB < varA) {
                    LOGGER.debug("updated current best motif to {}", (Object)tmpRes);
                    res = tmpRes;
                }
            }
            if (currBucketIdx < bucketsOrder.size() - 1 && tmpRes.getFrequency() > (Integer)((JmotifMapEntry)bucketsOrder.get(currBucketIdx + 1)).getKey()) {
                finished = true;
                continue;
            }
            if (++currBucketIdx == bucketsOrder.size()) break;
            MPC = (JmotifMapEntry)bucketsOrder.get(currBucketIdx);
            neighborhood = new ArrayList((Collection)buckets.get(MPC.getValue()));
        }
        return res;
    }

    private static MotifRecord ADM(double[] series, ArrayList<Integer> neighborhood, int motifSize, double range, double[] means, double[] stds, double znormThreshold) throws Exception {
        int i;
        MotifRecord res = new MotifRecord(-1, new ArrayList<Integer>());
        ArrayList<BitSet> admDistances = new ArrayList<BitSet>(neighborhood.size());
        for (i = 0; i < neighborhood.size(); ++i) {
            admDistances.add(new BitSet(i));
        }
        for (i = 0; i < neighborhood.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                boolean isMatch = EMMAImplementation.isNonTrivialMatch(series, neighborhood.get(i), neighborhood.get(j), motifSize, range, means, stds, znormThreshold);
                if (!isMatch) continue;
                ((BitSet)admDistances.get(i)).set(j);
                ((BitSet)admDistances.get(j)).set(i);
            }
        }
        int maxCount = 0;
        for (int i2 = 0; i2 < neighborhood.size(); ++i2) {
            int tmpCounter = 0;
            for (int j = 0; j < neighborhood.size(); ++j) {
                if (!((BitSet)admDistances.get(i2)).get(j)) continue;
                ++tmpCounter;
            }
            if (tmpCounter <= maxCount) continue;
            maxCount = tmpCounter;
            ArrayList<Integer> occurrences = new ArrayList<Integer>();
            for (int j = 0; j < neighborhood.size(); ++j) {
                if (!((BitSet)admDistances.get(i2)).get(j)) continue;
                occurrences.add(neighborhood.get(j));
            }
            res = new MotifRecord(neighborhood.get(i2), occurrences);
        }
        return res;
    }

    private static boolean isNonTrivialMatch(double[] series, int i, int j, int motifSize, double range, double[] means, double[] stds, double znormThreshold) {
        if (Math.abs(i - j) < motifSize / 2) {
            return false;
        }
        return EMMAImplementation.eaDistance(series, i, j, motifSize, range, means, stds, znormThreshold);
    }

    private static boolean eaDistance(double[] series, int a, int b, int motifSize, double range, double[] means, double[] stds, double znormThreshold) {
        ++distCounter;
        double cutOff2 = range * range;
        double res = 0.0;
        for (int i = 0; i < motifSize; ++i) {
            double val_a = (series[a + i] - means[a]) / stds[a];
            double val_b = (series[b + i] - means[b]) / stds[b];
            double buf = val_a - val_b;
            if (!((res += buf * buf) > cutOff2)) continue;
            ++eaCounter;
            return false;
        }
        return true;
    }

    private static double distance2(double p1, double p2) {
        double buf = p1 - p2;
        return buf * buf;
    }
}

