/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax.datastructures;

import java.util.Set;
import net.seninp.jmotif.sax.datastructure.SAXRecord;
import org.junit.Assert;
import org.junit.Test;

public class TestSAXRecord {
    private static final Integer iNum1 = 7;
    private static final Integer iNum2 = 3;
    private static final String str11 = "abggfecbb";
    private static final String str1 = "aaabbaa";
    private static final String str2 = "aaabbba";
    private static final Integer ONE = 1;
    private static final Integer ZERO = 0;

    @Test
    public void testSAXFrequencyEntry() {
        SAXRecord se = new SAXRecord(str11.toCharArray(), iNum2);
        Assert.assertTrue("Testing SAXRecord", str11.equalsIgnoreCase(String.valueOf(se.getPayload())));
        Set<Integer> freqs = se.getIndexes();
        Assert.assertEquals("Testing SAXRecord", 1L, freqs.size());
        Assert.assertTrue("Testing SAXRecord", freqs.contains(iNum2));
        se.addIndex(iNum1);
        Set<Integer> freqs1 = se.getIndexes();
        Assert.assertEquals("Testing SAXRecord", 2L, freqs1.size());
        Assert.assertTrue("Testing SAXRecord", freqs.contains(iNum2));
        Assert.assertTrue("Testing SAXRecord", freqs.contains(iNum1));
        se.addIndex(iNum2);
        Set<Integer> freqs2 = se.getIndexes();
        Assert.assertEquals("Testing SAXRecord", 2L, freqs2.size());
        Assert.assertTrue("Testing SAXRecord", freqs.contains(iNum2));
        Assert.assertTrue("Testing SAXRecord", freqs.contains(iNum1));
    }

    @Test
    public void setUp() {
        SAXRecord sfe1 = new SAXRecord(str1.toCharArray(), 0);
        Assert.assertTrue("Testing constructor", String.valueOf(sfe1.getPayload()).equalsIgnoreCase(str1));
        Assert.assertFalse("Testing constructor", String.valueOf(sfe1.getPayload()).equalsIgnoreCase(str2));
        Assert.assertEquals("Testing constructor", (Object)sfe1.getIndexes().size(), ONE);
        Assert.assertTrue("Testing constructor", sfe1.getIndexes().contains(ZERO));
        sfe1.addIndex(15);
        Assert.assertTrue("Testing setter", sfe1.getIndexes().contains(15));
        Assert.assertFalse("Testing setter", sfe1.getIndexes().contains(11));
    }

    @Test
    public void testCompare() {
        SAXRecord sfe1 = new SAXRecord(str1.toCharArray(), 0);
        SAXRecord sfe2 = new SAXRecord(str1.toCharArray(), 0);
        SAXRecord sfe3 = new SAXRecord(str2.toCharArray(), 0);
        Assert.assertTrue("testing equals", sfe1.equals(sfe2));
        Assert.assertEquals("testing hashCode", sfe1.hashCode(), sfe2.hashCode());
        Assert.assertSame("testing comparison", sfe1.compareTo(sfe1), 0);
        Assert.assertTrue("testing comparison", sfe1.compareTo(sfe3) == 0);
        sfe2.addIndex(11);
        Assert.assertFalse("testing equals", sfe1.equals(sfe2));
        Assert.assertNotSame("testing hashCode", sfe1.hashCode(), sfe2.hashCode());
        Assert.assertTrue("testing comparison", sfe1.compareTo(sfe2) < 0);
        Assert.assertTrue("testing comparison", sfe2.compareTo(sfe1) > 0);
        Assert.assertFalse("testing equals", sfe1.equals(sfe2));
    }

    @Test
    public void testHash() {
        SAXRecord sfe1 = new SAXRecord("".toCharArray(), 0);
        SAXRecord sfe2 = new SAXRecord("".toCharArray(), 0);
        sfe1.removeIndex(0);
        sfe2.removeIndex(0);
        Assert.assertEquals(sfe1.hashCode(), sfe2.hashCode());
    }

    @Test
    public void testToString() {
        SAXRecord se = new SAXRecord(str11.toCharArray(), iNum2);
        Assert.assertTrue(se.toString().contains(str11));
    }
}

