/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax.bitmap;

import java.util.HashMap;
import java.util.Map;
import net.seninp.jmotif.sax.SAXProcessor;
import net.seninp.jmotif.sax.TSProcessor;

public class Shingles {
    private Map<String, int[]> shingles = new HashMap<String, int[]>();
    private HashMap<String, Integer> indexTable = new HashMap();

    public Shingles(int alphabetSize, int shingleSize) {
        String[] alphabet = new String[alphabetSize];
        for (int i = 0; i < alphabetSize; ++i) {
            alphabet[i] = String.valueOf(TSProcessor.ALPHABET[i]);
        }
        String[] allStrings = SAXProcessor.getAllPermutations(alphabet, shingleSize);
        for (int i = 0; i < allStrings.length; ++i) {
            this.indexTable.put(allStrings[i], i);
        }
    }

    public HashMap<String, Integer> getShinglesIndex() {
        return this.indexTable;
    }

    public void addShingledSeries(String key, int[] counts) {
        this.shingles.put(key, counts);
    }

    public void addShingledSeries(String key, Map<String, Integer> shingledSeries) {
        int[] counts = new int[this.indexTable.size()];
        for (String str : shingledSeries.keySet()) {
            Integer idx = this.indexTable.get(str);
            if (null == idx) {
                throw new IndexOutOfBoundsException("the requested shingle " + str + " doesn't exist!");
            }
            counts[idx.intValue()] = shingledSeries.get(str);
        }
        this.shingles.put(key, counts);
    }

    public int[] get(String key) {
        return this.shingles.get(key);
    }

    public Map<String, int[]> getShingles() {
        return this.shingles;
    }
}

