/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax;

import java.util.Arrays;
import java.util.Map;
import net.seninp.jmotif.sax.NumerosityReductionStrategy;
import net.seninp.jmotif.sax.SAXProcessor;
import net.seninp.jmotif.sax.TSProcessor;
import net.seninp.jmotif.sax.alphabet.Alphabet;
import net.seninp.jmotif.sax.alphabet.NormalAlphabet;
import net.seninp.jmotif.sax.datastructure.SAXRecord;
import net.seninp.jmotif.sax.datastructure.SAXRecords;
import org.junit.Assert;
import org.junit.Test;

public class TestShingling {
    private static final String ts1File = "src/resources/test-data/timeseries01.csv";
    private static final int length = 15;

    @Test
    public void testPermutations() throws Exception {
        String[] arr = new String[]{"a", "b", "c"};
        Object[] perm2 = SAXProcessor.getAllPermutations(arr, 2);
        Assert.assertEquals("Testing the resulting array's length.", 9L, perm2.length);
        String asString2 = Arrays.toString(perm2);
        Assert.assertTrue("Testing the specific word is present.", asString2.contains("ca"));
        Object[] perm5 = SAXProcessor.getAllPermutations(arr, 5);
        Assert.assertEquals("Testing the resulting array's length.", 243L, perm5.length);
        String asString5 = Arrays.toString(perm5);
        Assert.assertTrue("Testing the specific word is present.", asString5.contains("caaca"));
    }

    @Test
    public void testShingling() throws Exception {
        SAXProcessor sp = new SAXProcessor();
        NormalAlphabet a = new NormalAlphabet();
        double[] ts1 = TSProcessor.readFileColumn(ts1File, 0, 15);
        SAXRecords sax = sp.ts2saxViaWindow(ts1, 3, 3, ((Alphabet)a).getCuts(3), NumerosityReductionStrategy.NONE, 0.001);
        Map<String, Integer> shingles = sp.ts2Shingles(ts1, 3, 3, 3, NumerosityReductionStrategy.NONE, 0.001, 3);
        for (Map.Entry<String, Integer> shinglesEntry : shingles.entrySet()) {
            SAXRecord saxEntry = sax.getByWord(shinglesEntry.getKey());
            if (null != saxEntry) {
                Assert.assertEquals("testing shingling", (Object)saxEntry.getIndexes().size(), shinglesEntry.getValue());
                continue;
            }
            Assert.assertEquals("testing shingling", (Object)0, shinglesEntry.getValue());
        }
    }
}

