/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.sax;

import net.seninp.jmotif.sax.SAXException;
import net.seninp.jmotif.sax.alphabet.NormalAlphabet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestNormalAlphabet {
    private NormalAlphabet a;

    @Before
    public void setUp() throws Exception {
        this.a = new NormalAlphabet();
    }

    @Test
    public void testGetMaxSize() {
        Assert.assertEquals(this.a.getMaxSize(), (Object)20);
    }

    @Test
    public void testGetCuts() {
        double[] dd2;
        try {
            for (int i = 2; i < this.a.getMaxSize(); ++i) {
                Assert.assertTrue(this.a.getCuts(i).length > 0);
            }
        }
        catch (SAXException e) {
            Assert.fail("Should not throw exception");
        }
        try {
            dd2 = this.a.getCuts(1);
            Assert.fail("Should throw an exception");
        }
        catch (SAXException dd2) {
            // empty catch block
        }
        try {
            dd2 = this.a.getCuts(21);
            Assert.fail("Should throw an exception");
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    @Test
    public void testGetDistanceMatrix() {
        double[][] dd2;
        try {
            for (int i = 2; i < this.a.getMaxSize(); ++i) {
                Assert.assertTrue(this.a.getDistanceMatrix(i).length > 0);
            }
        }
        catch (SAXException e) {
            Assert.fail("Should not throw exception");
        }
        try {
            dd2 = this.a.getDistanceMatrix(1);
            Assert.fail("Should throw an exception");
        }
        catch (SAXException dd2) {
            // empty catch block
        }
        try {
            dd2 = this.a.getDistanceMatrix(21);
            Assert.fail("Should throw an exception");
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    @Test
    public void testException() {
        double[] cuts12;
        try {
            cuts12 = this.a.getCuts(1);
            Assert.fail("exception is not thrown");
        }
        catch (SAXException cuts12) {
            // empty catch block
        }
        try {
            cuts12 = this.a.getCentralCuts(1);
            Assert.fail("exception is not thrown");
        }
        catch (SAXException cuts13) {
            // empty catch block
        }
        try {
            cuts12 = this.a.getCuts(1);
            Assert.fail("exception is not thrown");
        }
        catch (SAXException cuts14) {
            // empty catch block
        }
        try {
            double[][] dist1 = this.a.getDistanceMatrix(1);
            Assert.fail("exception is not thrown");
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    @Test
    public void testVarCutsAndDistances() {
        double[] cuts;
        int i;
        try {
            for (i = 2; i < 21; ++i) {
                cuts = this.a.getCuts(i);
                Assert.assertEquals(i - 1, cuts.length);
            }
        }
        catch (SAXException e) {
            Assert.fail("exception shall not be thrown!");
        }
        try {
            for (i = 2; i < 21; ++i) {
                cuts = this.a.getCentralCuts(i);
                Assert.assertEquals(i, cuts.length);
            }
        }
        catch (SAXException e) {
            Assert.fail("exception shall not be thrown!");
        }
        try {
            for (int i2 = 2; i2 < 21; ++i2) {
                double[][] dist = this.a.getDistanceMatrix(i2);
                Assert.assertEquals(i2, dist[0].length);
            }
        }
        catch (SAXException e) {
            Assert.fail("exception shall not be thrown!");
        }
    }
}

