/*
 * Decompiled with CFR 0.152.
 */
package net.seninp.jmotif.cbf;

import net.seninp.util.StdRandom;

public class CBFGenerator {
    public static synchronized int getA() {
        return (int)Math.round(StdRandom.uniform(0.0, 16.0) + 16.0);
    }

    public static synchronized int getB(int a) {
        return (int)Math.round(StdRandom.uniform(32.0, 96.0) + (double)a);
    }

    public static synchronized double eks(int t, int a, int b) {
        if (a <= t && t <= b) {
            return 1.0;
        }
        return 0.0;
    }

    public static synchronized double[] cylinder(int[] t) {
        int a = CBFGenerator.getA();
        int b = CBFGenerator.getB(a);
        double[] res = new double[t.length];
        for (int i = 0; i < t.length; ++i) {
            res[i] = (6.0 + StdRandom.gaussian()) * CBFGenerator.eks(t[i], a, b) + StdRandom.gaussian();
        }
        return res;
    }

    public static synchronized double[] bell(int[] t) {
        int a = CBFGenerator.getA();
        int b = CBFGenerator.getB(a);
        double[] res = new double[t.length];
        for (int i = 0; i < t.length; ++i) {
            res[i] = (6.0 + StdRandom.gaussian()) * CBFGenerator.eks(t[i], a, b) * ((double)(t[i] - a) / (double)(b - a)) + StdRandom.gaussian();
        }
        return res;
    }

    public static synchronized double[] funnel(int[] t) {
        int a = CBFGenerator.getA();
        int b = CBFGenerator.getB(a);
        double[] res = new double[t.length];
        for (int i = 0; i < t.length; ++i) {
            res[i] = (6.0 + StdRandom.gaussian()) * CBFGenerator.eks(t[i], a, b) * ((double)(b - t[i]) / (double)(b - a)) + StdRandom.gaussian();
        }
        return res;
    }
}

