/*
 * Decompiled with CFR 0.152.
 */
package org.happy.controllers.impl;

import com.google.common.base.Preconditions;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import org.happy.commons.patterns.executable.Executable_1x2;
import org.happy.controllers.Controller_1x3;
import org.happy.controllers.impl.AbstractController_1x3;

public class ExecutableController_1x3<R>
extends AbstractController_1x3<Float, R> {
    private Executable_1x2<R, Void> executeable;
    private CountDownLatch waitForFinishLatch = new CountDownLatch(1);
    private ExecutorService executor;

    public static <R> ExecutableController_1x3<R> of(Executable_1x2<R, Void> executable, ExecutorService executor) {
        Preconditions.checkNotNull(executable);
        return new ExecutableController_1x3<R>(executable, executor);
    }

    public static ExecutableController_1x3<Void> of(Runnable r, ExecutorService executor) {
        return new ExecutableController_1x3<Void>(Executable_1x2.Utils.of(r), executor);
    }

    public ExecutableController_1x3(Executable_1x2<R, Void> executeable, ExecutorService executor) {
        Preconditions.checkNotNull(executeable);
        Preconditions.checkNotNull((Object)executor);
        this.executor = executor;
        this.executeable = executeable;
        this.setProgress(Float.valueOf(0.0f));
    }

    @Override
    public R waitForFinish() {
        try {
            this.waitForFinishLatch.await();
        }
        catch (InterruptedException e) {
            this.fireOnErrorEvent(e);
        }
        return this.getResult();
    }

    @Override
    public Boolean start() {
        this.setState(Controller_1x3.State_1x3.Started);
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object result = null;
                try {
                    result = ExecutableController_1x3.this.executeable.execute(null);
                    ExecutableController_1x3.this.setResult(result);
                    ExecutableController_1x3.this.setState(Controller_1x3.State_1x3.Finished);
                    ExecutableController_1x3.this.setProgress(Float.valueOf(1.0f));
                }
                catch (Throwable e) {
                    ExecutableController_1x3.this.fireOnErrorEvent(e);
                    Controller_1x3.State_1x3 s = ExecutableController_1x3.this.getState();
                    if (!Controller_1x3.State_1x3.Finished.equals((Object)s) && !Controller_1x3.State_1x3.Canceled.equals((Object)s)) {
                        ExecutableController_1x3.this.setState(Controller_1x3.State_1x3.Canceled);
                    }
                }
                finally {
                    ExecutableController_1x3.this.waitForFinishLatch.countDown();
                }
            }
        });
        return true;
    }

    @Override
    public Boolean cancel() {
        throw new UnsupportedOperationException();
    }
}

