/*
 * Decompiled with CFR 0.152.
 */
package org.happy.commons.util;

import java.util.Arrays;
import java.util.Comparator;
import org.happy.commons.concurrent.loops.Parallel_1x0;
import org.happy.commons.patterns.version.Version_1x0;
import org.happy.commons.sort.algorithms.QuickSortParallel_1x0;
import org.happy.commons.util.comparators.Comparator_1x0;

public class Arrays_1x0
implements Version_1x0<Float> {
    public static <T extends Comparable<T>> void sort(T[] a) {
        if (a.length == 0) {
            return;
        }
        if (SorterHolder.availableProcessors <= 1) {
            Arrays.sort(a);
            return;
        }
        SorterHolder.sorterObject.sort(a, new Comparator_1x0());
    }

    public <T extends Comparable<T>> void sort(T[] a, int fromIndex, int toIndex) {
        if (a.length == 0) {
            return;
        }
        if (SorterHolder.availableProcessors <= 1) {
            Arrays.sort(a, fromIndex, toIndex);
            return;
        }
        SorterHolder.sorterObject.sort(a, fromIndex, toIndex, new Comparator_1x0());
    }

    public static <T> void sort(T[] a, Comparator<T> c) {
        if (a.length == 0) {
            return;
        }
        if (SorterHolder.availableProcessors <= 1) {
            Arrays.sort(a);
            return;
        }
        SorterHolder.sorterObject.sort(a, c);
    }

    public static <T> void sort(T[] a, int fromIndex, int toIndex, Comparator<T> comparator) {
        if (a.length == 0) {
            return;
        }
        if (SorterHolder.availableProcessors <= 1) {
            Arrays.sort(a, fromIndex, toIndex);
            return;
        }
        SorterHolder.sorterObject.sort(a, fromIndex, toIndex, comparator, Parallel_1x0.getTaskGroup());
    }

    public static void sort(byte[] a) {
        if (a.length == 0) {
            return;
        }
        if (SorterHolder.availableProcessors <= 1) {
            Arrays.sort(a);
            return;
        }
        SorterHolder.sorterPrimitiv.sort(a);
    }

    public static void sort(byte[] a, int fromIndex, int toIndex) {
        if (a.length == 0) {
            return;
        }
        if (SorterHolder.availableProcessors <= 1) {
            Arrays.sort(a, fromIndex, toIndex);
            return;
        }
        SorterHolder.sorterPrimitiv.sort(a, fromIndex, toIndex);
    }

    public static void sort(short[] a) {
        if (a.length == 0) {
            return;
        }
        if (SorterHolder.availableProcessors <= 1) {
            Arrays.sort(a);
            return;
        }
        SorterHolder.sorterPrimitiv.sort(a);
    }

    public static void sort(short[] a, int fromIndex, int toIndex) {
        if (a.length == 0) {
            return;
        }
        if (SorterHolder.availableProcessors <= 1) {
            Arrays.sort(a, fromIndex, toIndex);
            return;
        }
        SorterHolder.sorterPrimitiv.sort(a, fromIndex, toIndex);
    }

    public static void sort(int[] a) {
        if (a.length == 0) {
            return;
        }
        if (SorterHolder.availableProcessors <= 1) {
            Arrays.sort(a);
            return;
        }
        SorterHolder.sorterPrimitiv.sort(a);
    }

    public static void sort(int[] a, int fromIndex, int toIndex) {
        if (a.length == 0) {
            return;
        }
        if (SorterHolder.availableProcessors <= 1) {
            Arrays.sort(a, fromIndex, toIndex);
            return;
        }
        SorterHolder.sorterPrimitiv.sort(a, fromIndex, toIndex);
    }

    public static void sort(long[] a) {
        if (a.length == 0) {
            return;
        }
        if (SorterHolder.availableProcessors <= 1) {
            Arrays.sort(a);
            return;
        }
        SorterHolder.sorterPrimitiv.sort(a);
    }

    public static void sort(long[] a, int fromIndex, int toIndex) {
        if (a.length == 0) {
            return;
        }
        if (SorterHolder.availableProcessors <= 1) {
            Arrays.sort(a, fromIndex, toIndex);
            return;
        }
        SorterHolder.sorterPrimitiv.sort(a, fromIndex, toIndex);
    }

    public static void sort(float[] a) {
        if (a.length == 0) {
            return;
        }
        if (SorterHolder.availableProcessors <= 1) {
            Arrays.sort(a);
            return;
        }
        SorterHolder.sorterPrimitiv.sort(a);
    }

    public static void sort(float[] a, int fromIndex, int toIndex) {
        if (a.length == 0) {
            return;
        }
        if (SorterHolder.availableProcessors <= 1) {
            Arrays.sort(a, fromIndex, toIndex);
            return;
        }
        SorterHolder.sorterPrimitiv.sort(a, fromIndex, toIndex);
    }

    public static void sort(double[] a) {
        if (a.length == 0) {
            return;
        }
        if (SorterHolder.availableProcessors <= 1) {
            Arrays.sort(a);
            return;
        }
        SorterHolder.sorterPrimitiv.sort(a);
    }

    public static void sort(double[] a, int fromIndex, int toIndex) {
        if (a.length == 0) {
            return;
        }
        if (SorterHolder.availableProcessors <= 1) {
            Arrays.sort(a, fromIndex, toIndex);
            return;
        }
        SorterHolder.sorterPrimitiv.sort(a, fromIndex, toIndex);
    }

    public static void sort(char[] a) {
        if (a.length == 0) {
            return;
        }
        if (SorterHolder.availableProcessors <= 1) {
            Arrays.sort(a);
            return;
        }
        SorterHolder.sorterPrimitiv.sort(a);
    }

    public static void sort(char[] a, int fromIndex, int toIndex) {
        if (a.length == 0) {
            return;
        }
        if (SorterHolder.availableProcessors <= 1) {
            Arrays.sort(a, fromIndex, toIndex);
            return;
        }
        SorterHolder.sorterPrimitiv.sort(a, fromIndex, toIndex);
    }

    public static <T extends Comparable<T>> boolean compare(T[] a, T[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (0 == a[i].compareTo(b[i])) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean compare(T[] a, T[] b, Comparator<T> c) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (0 == c.compare(a[i], b[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean compare(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean compare(int[] a, int[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean compare(long[] a, long[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean compare(char[] a, char[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean compare(float[] a, float[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean compare(double[] a, double[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean compare(double[][] a, double[][] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (Arrays_1x0.compare(a[0], b[0])) continue;
            return false;
        }
        return true;
    }

    public static String toString(Object[] array) {
        return Arrays_1x0.toString(array, true);
    }

    public static String toString(Object[] array, boolean doFormat) {
        String str = "";
        if (doFormat) {
            str = str + "[";
        }
        int i = 0;
        for (Object obj : array) {
            str = str + obj.toString();
            if (!doFormat || ++i >= array.length) continue;
            str = str + ",";
        }
        if (doFormat) {
            str = str + "]";
        }
        return str;
    }

    public static String toString(byte[] array) {
        return Arrays_1x0.toString(array, true);
    }

    public static String toString(byte[] array, boolean doFormat) {
        String str = "";
        if (doFormat) {
            str = str + "[";
        }
        int i = 0;
        byte[] arr$ = array;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Byte obj = arr$[i$];
            str = str + ((Object)obj).toString();
            if (!doFormat || ++i >= array.length) continue;
            str = str + ",";
        }
        if (doFormat) {
            str = str + "]";
        }
        return str;
    }

    public static String toString(short[] array) {
        return Arrays_1x0.toString(array, true);
    }

    public static String toString(short[] array, boolean doFormat) {
        String str = "";
        if (doFormat) {
            str = str + "[";
        }
        int i = 0;
        short[] arr$ = array;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Short obj = arr$[i$];
            str = str + ((Object)obj).toString();
            if (!doFormat || ++i >= array.length) continue;
            str = str + ",";
        }
        if (doFormat) {
            str = str + "]";
        }
        return str;
    }

    public static String toString(int[] array) {
        return Arrays_1x0.toString(array, true);
    }

    public static String toString(int[] array, boolean doFormat) {
        String str = "";
        if (doFormat) {
            str = str + "[";
        }
        int i = 0;
        int[] arr$ = array;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer obj = arr$[i$];
            str = str + ((Object)obj).toString();
            if (!doFormat || ++i >= array.length) continue;
            str = str + ",";
        }
        if (doFormat) {
            str = str + "]";
        }
        return str;
    }

    public static String toString(long[] array) {
        return Arrays_1x0.toString(array, true);
    }

    public static String toString(long[] array, boolean doFormat) {
        String str = "";
        if (doFormat) {
            str = str + "[";
        }
        int i = 0;
        long[] arr$ = array;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Long obj = arr$[i$];
            str = str + ((Object)obj).toString();
            if (!doFormat || ++i >= array.length) continue;
            str = str + ",";
        }
        if (doFormat) {
            str = str + "]";
        }
        return str;
    }

    public static String toString(float[] array) {
        return Arrays_1x0.toString(array, true);
    }

    public static String toString(float[] array, boolean doFormat) {
        String str = "";
        if (doFormat) {
            str = str + "[";
        }
        int i = 0;
        float[] arr$ = array;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Float obj = Float.valueOf(arr$[i$]);
            str = str + ((Object)obj).toString();
            if (!doFormat || ++i >= array.length) continue;
            str = str + ",";
        }
        if (doFormat) {
            str = str + "]";
        }
        return str;
    }

    public static String toString(double[] array) {
        return Arrays_1x0.toString(array, true);
    }

    public static String toString(double[] array, boolean doFormat) {
        String str = "";
        if (doFormat) {
            str = str + "[";
        }
        int i = 0;
        double[] arr$ = array;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Double obj = arr$[i$];
            str = str + ((Object)obj).toString();
            if (!doFormat || ++i >= array.length) continue;
            str = str + ",";
        }
        if (doFormat) {
            str = str + "]";
        }
        return str;
    }

    public static String toString(boolean[] array) {
        return Arrays_1x0.toString(array, true);
    }

    public static String toString(boolean[] array, boolean doFormat) {
        String str = "";
        if (doFormat) {
            str = str + "[";
        }
        int i = 0;
        boolean[] arr$ = array;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Boolean obj = arr$[i$];
            str = str + ((Object)obj).toString();
            if (!doFormat || ++i >= array.length) continue;
            str = str + ",";
        }
        if (doFormat) {
            str = str + "]";
        }
        return str;
    }

    public static String toString(char[] array) {
        return Arrays_1x0.toString(array, true);
    }

    public static String toString(char[] array, boolean doFormat) {
        String str = "";
        if (doFormat) {
            str = str + "[";
        }
        int i = 0;
        char[] arr$ = array;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Character obj = Character.valueOf(arr$[i$]);
            str = str + ((Object)obj).toString();
            if (!doFormat || ++i >= array.length) continue;
            str = str + ",";
        }
        if (doFormat) {
            str = str + "]";
        }
        return str;
    }

    public static void shuffle(Object[] a, int operationNumber) {
        for (int i = 0; i < operationNumber; ++i) {
            int index1 = (int)(Math.random() * (double)a.length);
            int index2 = (int)(Math.random() * (double)a.length);
            Arrays_1x0.swap(a, index1, index2);
        }
    }

    public static void swap(Object[] a, int index1, int index2) {
        Object tmp = a[index1];
        a[index1] = a[index2];
        a[index2] = tmp;
    }

    public static void swap(byte[] a, int index1, int index2) {
        byte tmp = a[index1];
        a[index1] = a[index2];
        a[index2] = tmp;
    }

    public static void swap(short[] a, int index1, int index2) {
        short tmp = a[index1];
        a[index1] = a[index2];
        a[index2] = tmp;
    }

    public static void swap(int[] a, int index1, int index2) {
        int tmp = a[index1];
        a[index1] = a[index2];
        a[index2] = tmp;
    }

    public static void swap(long[] a, int index1, int index2) {
        long tmp = a[index1];
        a[index1] = a[index2];
        a[index2] = tmp;
    }

    public static void swap(float[] a, int index1, int index2) {
        float tmp = a[index1];
        a[index1] = a[index2];
        a[index2] = tmp;
    }

    public static void swap(double[] a, int index1, int index2) {
        double tmp = a[index1];
        a[index1] = a[index2];
        a[index2] = tmp;
    }

    public static void swap(boolean[] a, int index1, int index2) {
        boolean tmp = a[index1];
        a[index1] = a[index2];
        a[index2] = tmp;
    }

    public static void swap(char[] a, int index1, int index2) {
        char tmp = a[index1];
        a[index1] = a[index2];
        a[index2] = tmp;
    }

    public static void rotate(Object[] a) {
        int i = 0;
        for (int j = a.length - 1; i < j; ++i, --j) {
            Arrays_1x0.swap(a, i, j);
        }
    }

    public static <T extends Comparable<T>> int max(T[] a) {
        return Arrays_1x0.max(a, new Comparator_1x0());
    }

    public static <T> int max(T[] a, Comparator<T> comparator) {
        int index = 0;
        for (int i = 0; i < a.length; ++i) {
            if (comparator.compare(a[index], a[i]) >= 0) continue;
            index = i;
        }
        return index;
    }

    public static <T extends Comparable<T>> int min(T[] a) {
        return Arrays_1x0.min(a, new Comparator_1x0());
    }

    public static <T> int min(T[] a, Comparator<T> comparator) {
        int index = 0;
        for (int i = 0; i < a.length; ++i) {
            if (comparator.compare(a[i], a[index]) >= 0) continue;
            index = i;
        }
        return index;
    }

    public static <T extends Comparable<T>> int isAscending(T[] a) {
        return Arrays_1x0.isAscending(a, new Comparator_1x0());
    }

    public static <T> int isAscending(T[] a, Comparator<T> comparator) {
        return Arrays_1x0.isAscending(a, 0, a.length - 1, comparator);
    }

    public static <T extends Comparable<T>> int isAscending(T[] a, int left, int right) {
        return Arrays_1x0.isAscending(a, left, right, new Comparator_1x0());
    }

    public static <T> int isAscending(T[] a, int left, int right, Comparator<T> comparator) {
        T elem1 = a[left];
        for (int i = left; i < right; ++i) {
            T elem2 = a[i];
            if (comparator.compare(elem2, elem1) < 0) {
                return i;
            }
            elem1 = elem2;
        }
        return -1;
    }

    @Override
    public Float getVersion() {
        return Float.valueOf(1.0f);
    }

    private static class SorterHolder {
        private static final QuickSortParallel_1x0 sorterObject = new QuickSortParallel_1x0();
        private static final QuickSortParallel_1x0 sorterPrimitiv = new QuickSortParallel_1x0();
        private static final int availableProcessors = Runtime.getRuntime().availableProcessors();

        private SorterHolder() {
        }

        static {
            sorterObject.setMinSizeToSolvePivotWhithTreeRule(20);
            sorterObject.setMinSizeToSolvePivotWithPresort(1000);
            sorterObject.setMinSizeToUseRandomElementToSolvePivot(1000);
            sorterObject.setListSizeForNewTaskSmall(500);
            sorterObject.setListSizeForMergeSort(1000);
            sorterObject.setListSizeForShellSort(20);
            sorterObject.setListSizeForInsertionSort(4);
            sorterPrimitiv.setMinSizeToSolvePivotWhithTreeRule(100);
            sorterPrimitiv.setMinSizeToSolvePivotWithPresort(10000);
            sorterPrimitiv.setMinSizeToUseRandomElementToSolvePivot(10000);
            sorterPrimitiv.setListSizeForNewTaskSmall(100000);
            sorterPrimitiv.setListSizeForMergeSort(30000);
            sorterPrimitiv.setListSizeForShellSort(20);
            sorterPrimitiv.setListSizeForInsertionSort(4);
        }
    }
}

