/*
 * Decompiled with CFR 0.152.
 */
package org.happy.commons.sort.algorithms;

import java.util.Comparator;
import org.happy.commons.util.comparators.Comparator_1x0;

public class InsertionSort_1x0 {
    private InsertionSort_1x0() {
    }

    public static <T> void sort(T[] a, int fromIndex, int toIndex, Comparator<T> comparator) {
        if (toIndex - 1 < fromIndex) {
            throw new IllegalArgumentException("InsertionSort_1x0 error: false arguments - right should be bigger or equals to the left");
        }
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            T tmp = a[i];
            for (int j = i; fromIndex < j && 0 < comparator.compare(a[j - 1], tmp); --j) {
                a[j] = a[j - 1];
            }
            a[j] = tmp;
        }
    }

    public static <T> void sort(T[] a, Comparator<T> comparator) {
        InsertionSort_1x0.sort(a, 0, a.length, comparator);
    }

    public static <T extends Comparable<T>> void sort(T[] a) {
        InsertionSort_1x0.sort(a, 0, a.length, new Comparator_1x0());
    }

    public static void sort(byte[] a, int fromIndex, int toIndex) {
        if (toIndex - 1 < fromIndex) {
            throw new IllegalArgumentException("InsertionSort_1x0 error: false arguments - right should be bigger or equals to the left");
        }
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            byte tmp = a[i];
            for (int j = i; fromIndex < j && tmp < a[j - 1]; --j) {
                a[j] = a[j - 1];
            }
            a[j] = tmp;
        }
    }

    public static void sort(byte[] a) {
        InsertionSort_1x0.sort(a, 0, a.length);
    }

    public static void sort(short[] a, int fromIndex, int toIndex) {
        if (toIndex - 1 < fromIndex) {
            throw new IllegalArgumentException("InsertionSort_1x0 error: false arguments - right should be bigger or equals to the left");
        }
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            short tmp = a[i];
            for (int j = i; fromIndex < j && tmp < a[j - 1]; --j) {
                a[j] = a[j - 1];
            }
            a[j] = tmp;
        }
    }

    public static void sort(short[] a) {
        InsertionSort_1x0.sort(a, 0, a.length);
    }

    public static void sort(int[] a, int fromIndex, int toIndex) {
        if (toIndex - 1 < fromIndex) {
            throw new IllegalArgumentException("InsertionSort_1x0 error: false arguments - right should be bigger or equals to the left");
        }
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            int tmp = a[i];
            for (int j = i; fromIndex < j && tmp < a[j - 1]; --j) {
                a[j] = a[j - 1];
            }
            a[j] = tmp;
        }
    }

    public static void sort(int[] a) {
        InsertionSort_1x0.sort(a, 0, a.length);
    }

    public static void sort(long[] a, int fromIndex, int toIndex) {
        if (toIndex - 1 < fromIndex) {
            throw new IllegalArgumentException("InsertionSort_1x0 error: false arguments - right should be bigger or equals to the left");
        }
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            long tmp = a[i];
            for (int j = i; fromIndex < j && tmp < a[j - 1]; --j) {
                a[j] = a[j - 1];
            }
            a[j] = tmp;
        }
    }

    public static void sort(long[] a) {
        InsertionSort_1x0.sort(a, 0, a.length);
    }

    public static void sort(float[] a, int fromIndex, int toIndex) {
        if (toIndex - 1 < fromIndex) {
            throw new IllegalArgumentException("InsertionSort_1x0 error: false arguments - right should be bigger or equals to the left");
        }
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            float tmp = a[i];
            for (int j = i; fromIndex < j && tmp < a[j - 1]; --j) {
                a[j] = a[j - 1];
            }
            a[j] = tmp;
        }
    }

    public static void sort(float[] a) {
        InsertionSort_1x0.sort(a, 0, a.length);
    }

    public static void sort(double[] a, int fromIndex, int toIndex) {
        if (toIndex - 1 < fromIndex) {
            throw new IllegalArgumentException("InsertionSort_1x0 error: false arguments - right should be bigger or equals to the left");
        }
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            double tmp = a[i];
            for (int j = i; fromIndex < j && tmp < a[j - 1]; --j) {
                a[j] = a[j - 1];
            }
            a[j] = tmp;
        }
    }

    public static void sort(double[] a) {
        InsertionSort_1x0.sort(a, 0, a.length);
    }

    public static void sort(char[] a, int fromIndex, int toIndex) {
        if (toIndex - 1 < fromIndex) {
            throw new IllegalArgumentException("InsertionSort_1x0 error: false arguments - right should be bigger or equals to the left");
        }
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            char tmp = a[i];
            for (int j = i; fromIndex < j && tmp < a[j - 1]; --j) {
                a[j] = a[j - 1];
            }
            a[j] = tmp;
        }
    }

    public static void sort(char[] a) {
        InsertionSort_1x0.sort(a, 0, a.length);
    }
}

