/*
 * Decompiled with CFR 0.152.
 */
package org.happy.commons.patterns.observer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.happy.commons.patterns.observer.Delegate_1x0;
import org.happy.commons.patterns.observer.listener.ActionListener_1x0;

public class Delegate_1x0Impl<A extends ActionEvent>
implements Delegate_1x0<A> {
    private Set<ActionListener> listenerSet = new HashSet<ActionListener>();

    @Override
    public boolean add(ActionListener listener) {
        if (this.contains(listener)) {
            return false;
        }
        this.listenerSet.add(listener);
        return true;
    }

    @Override
    public boolean add(ActionListener_1x0<A> listener) {
        if (this.contains(listener)) {
            return false;
        }
        this.listenerSet.add(listener);
        return true;
    }

    @Override
    public boolean remove(ActionListener listener) {
        return this.listenerSet.remove(listener);
    }

    @Override
    public int getListenerCount() {
        return this.listenerSet.size();
    }

    @Override
    public void removeAll() {
        this.listenerSet.clear();
    }

    @Override
    public void fire(A e) {
        for (ActionListener listener : this.listenerSet) {
            listener.actionPerformed((ActionEvent)e);
        }
    }

    @Override
    public <T extends ActionListener> Set<T> getListeners(Class<T> t) {
        HashSet<ActionListener> foundListeners = new HashSet<ActionListener>();
        for (ActionListener listener : this.listenerSet) {
            ActionListener l = null;
            try {
                l = (ActionListener)t.cast(listener);
            }
            catch (ClassCastException e) {
                l = null;
            }
            if (l == null) continue;
            foundListeners.add(l);
        }
        return Collections.unmodifiableSet(foundListeners);
    }

    @Override
    public Set<ActionListener> getListeners() {
        return this.listenerSet;
    }

    @Override
    public <T extends ActionListener> int getListenerCount(Class<T> t) {
        int count = 0;
        for (ActionListener listener : this.listenerSet) {
            boolean sucsess = true;
            try {
                t.cast(listener);
            }
            catch (ClassCastException e) {
                sucsess = false;
            }
            if (!sucsess) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean contains(ActionListener l) {
        return this.listenerSet.contains(l);
    }

    @Override
    public Float getVersion() {
        return Float.valueOf(1.0f);
    }
}

