/*
 * Decompiled with CFR 0.152.
 */
package org.happy.commons.generators;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import org.happy.commons.generators.RandomIntegerGenerator_1x0;
import org.happy.commons.patterns.Generator_1x0;
import org.happy.commons.util.Random_1x0;

public class RandomObjectFromArrayGenerator_1x0<T>
implements Generator_1x0<T> {
    private Object[] arr;
    private Random random;
    private RandomIntegerGenerator_1x0 generator;

    public static <T> RandomObjectFromArrayGenerator_1x0<T> of(Collection<T> c) {
        return new RandomObjectFromArrayGenerator_1x0<T>(c);
    }

    public static <T> RandomObjectFromArrayGenerator_1x0<T> of(Collection<T> c, Random random) {
        return new RandomObjectFromArrayGenerator_1x0<T>(c, random);
    }

    public static <T> RandomObjectFromArrayGenerator_1x0<T> of(T[] arr) {
        return new RandomObjectFromArrayGenerator_1x0<T>(arr);
    }

    public static <T> RandomObjectFromArrayGenerator_1x0<T> of(T[] arr, Random random) {
        return new RandomObjectFromArrayGenerator_1x0<T>(arr, random);
    }

    public RandomObjectFromArrayGenerator_1x0(Collection<T> c) {
        this(c, Random_1x0.singelton());
    }

    public RandomObjectFromArrayGenerator_1x0(Collection<T> c, Random random) {
        this.init(c.toArray(), random);
    }

    public RandomObjectFromArrayGenerator_1x0(T[] arr) {
        Preconditions.checkNotNull(arr);
        this.init(arr, Random_1x0.singelton());
    }

    public RandomObjectFromArrayGenerator_1x0(T[] arr, Random random) {
        this.init(arr, random);
    }

    protected void init(Object[] arr, Random random) {
        if (this.random == null) {
            this.random = Random_1x0.singelton();
        }
        this.arr = arr;
        this.generator = new RandomIntegerGenerator_1x0(0, arr.length, random);
    }

    @Override
    public T generate() {
        if (this.arr.length == 0) {
            return null;
        }
        int index = this.generator.generate();
        return (T)this.arr[index];
    }

    public String toString() {
        return "RandomObjectFromArrayGenerator_1x0 [arr=" + Arrays.toString(this.arr) + "]";
    }
}

