/*
 * Decompiled with CFR 0.152.
 */
package org.happy.commons.generators;

import java.util.Random;
import org.happy.commons.patterns.Generator_1x0;
import org.happy.commons.patterns.version.Version_1x0;
import org.happy.commons.util.Random_1x0;

public class RandomFloatGenerator_1x0
implements Generator_1x0<Float>,
Version_1x0<Float> {
    private float min;
    private float max;
    Random random = null;

    public RandomFloatGenerator_1x0(float min, float max) {
        if (min > max) {
            throw new IllegalArgumentException("MIN must be smaller or equals to MAX");
        }
        this.min = min;
        this.max = max;
    }

    public RandomFloatGenerator_1x0(float min, float max, Random random) {
        this(min, max);
        this.random = random;
    }

    @Override
    public Float generate() {
        if (this.min == this.max) {
            return Float.valueOf(this.min);
        }
        if (this.random == null) {
            return Float.valueOf(this.min + Random_1x0.randomFloat(this.max - this.min));
        }
        return Float.valueOf(this.min + this.random.nextFloat() * (this.max - this.min));
    }

    public float getMin() {
        return this.min;
    }

    public void setMin(float min) {
        this.min = min;
    }

    public float getMax() {
        return this.max;
    }

    public void setMax(float max) {
        this.max = max;
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    @Override
    public Float getVersion() {
        return Float.valueOf(1.0f);
    }

    public String toString() {
        return "RandomFloatGenerator_1x0 [min=" + this.min + ", max=" + this.max + "]";
    }
}

