/*
 * Decompiled with CFR 0.152.
 */
package org.happy.collections.maps.decorators.data.map;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.happy.collections.maps.DataMap_1x2;
import org.happy.collections.maps.decorators.data.map.DataAdapterDecorator_1x2;
import org.happy.commons.patterns.Cacheable_1x2;
import org.happy.commons.util.comparators.Comparator_1x0;

public class CacheDataAdapter_1x2<K, V>
extends DataAdapterDecorator_1x2<K, V>
implements Cacheable_1x2 {
    private SortedMap<Integer, Map.Entry<K, V>> cacheMapSequence = new TreeMap(new Comparator_1x0());
    private Map<K, V> cacheMap = new HashMap();
    private Integer size = null;

    public static <K, V> CacheDataAdapter_1x2<K, V> of(DataMap_1x2.DataAdapter<K, V> decorated) {
        return new CacheDataAdapter_1x2<K, V>(decorated);
    }

    public CacheDataAdapter_1x2(DataMap_1x2.DataAdapter<K, V> decorated) {
        super(decorated);
    }

    @Override
    public boolean remove(Object key) {
        this.refresh();
        return super.remove(key);
    }

    @Override
    public Collection<Map.Entry<K, V>> getBetween(int startIndex, int endIndex) {
        int elementsNumber = endIndex - startIndex;
        SortedMap<Integer, Map.Entry<K, V>> subMap = this.cacheMapSequence.subMap(startIndex, endIndex);
        if (elementsNumber == subMap.size()) {
            return ImmutableSet.copyOf(subMap.values());
        }
        Collection col = super.getBetween(startIndex, endIndex);
        int index = startIndex;
        for (Map.Entry entry : col) {
            this.cacheMapSequence.put(index, entry);
            this.cacheMap.put(entry.getKey(), entry.getValue());
            ++index;
        }
        Preconditions.checkState((index - startIndex == col.size() ? 1 : 0) != 0, (Object)"Internal Error -> Not all elements  were added to the cacheMap!");
        return col;
    }

    @Override
    public int size() {
        if (this.size == null) {
            this.size = super.size();
        }
        return this.size;
    }

    @Override
    public V get(Object key) {
        if (this.cacheMap.containsKey(key)) {
            return this.cacheMap.get(key);
        }
        Object value = super.get(key);
        this.cacheMap.put(key, value);
        return value;
    }

    @Override
    public void clear() {
        this.refresh();
        super.clear();
    }

    @Override
    public V put(K key, V value) {
        this.refresh();
        return super.put(key, value);
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.cacheMap.containsKey(key)) {
            return true;
        }
        return super.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.cacheMap.containsValue(value)) {
            return true;
        }
        return super.containsValue(value);
    }

    @Override
    public boolean refresh() {
        this.cacheMapSequence.clear();
        this.cacheMap.clear();
        this.size = null;
        return true;
    }
}

