/*
 * Decompiled with CFR 0.152.
 */
package org.happy.collections.maps.decorators;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.happy.collections.decorators.UnmodifiableStrategy_1x0;
import org.happy.collections.maps.decorators.EventMap_1x2;
import org.happy.collections.maps.decorators.MapDecorator_1x0;
import org.happy.collections.sets.decorators.UnmodifiableSet_1x0;
import org.happy.commons.patterns.observer.Delegate_1x0Impl;
import org.happy.commons.patterns.observer.event.ActionEventAfter_1x0;
import org.happy.commons.patterns.observer.event.ActionEventBefore_1x0;
import org.happy.commons.patterns.observer.listener.ActionListener_1x0;

public class UnmodifiableMap_1x0<K, V>
extends MapDecorator_1x0<K, V> {
    private EventMap_1x2<K, V> eventMap;
    private Delegate_1x0Impl<ActionEventAfter_1x0<UnmodifiableStrategy_1x0>> onStrategyChanged = null;
    private UnmodifiableStrategy_1x0 strategy;
    protected ActionListener beforePutListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            throw new UnsupportedOperationException("The collection can't be modified! Choose another strategy as " + UnmodifiableMap_1x0.this.getStrategy() + ", if you want to add elements");
        }
    };
    protected ActionListener beforeRemoveListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            throw new UnsupportedOperationException("The collection can't be modified! Choose another strategy as " + UnmodifiableMap_1x0.this.getStrategy() + ", if you want to reove elements");
        }
    };

    public static <K, V> Map.Entry<K, V> unmodifieableEntry(final K key, final V value) {
        return new Map.Entry<K, V>(){

            @Override
            public K getKey() {
                return key;
            }

            @Override
            public V getValue() {
                return value;
            }

            @Override
            public V setValue(V value2) {
                throw new UnsupportedOperationException("the operation is not supported because of the unmodifieable strategy!");
            }
        };
    }

    public static <K, V> Map.Entry<K, V> unmodifieableEntry(final Map.Entry<K, V> entry) {
        return new Map.Entry<K, V>(){

            @Override
            public K getKey() {
                return entry.getKey();
            }

            @Override
            public V getValue() {
                return entry.getValue();
            }

            @Override
            public V setValue(V value) {
                throw new UnsupportedOperationException("the operation is not supported because of the unmodifieable strategy!");
            }
        };
    }

    public static <K, V> UnmodifiableMap_1x0<K, V> of(Map<K, V> decorateable) {
        return UnmodifiableMap_1x0.of(decorateable, UnmodifiableStrategy_1x0.Unmodifiable);
    }

    public static <K, V> UnmodifiableMap_1x0<K, V> of(Map<K, V> decorateable, UnmodifiableStrategy_1x0 strategy) {
        return new UnmodifiableMap_1x0<K, V>(decorateable, strategy);
    }

    public UnmodifiableMap_1x0(Map<K, V> decorateable) {
        this(decorateable, UnmodifiableStrategy_1x0.Unmodifiable);
    }

    public UnmodifiableMap_1x0(Map<K, V> decorated, UnmodifiableStrategy_1x0 strategy) {
        super(decorated);
        this.eventMap = EventMap_1x2.of(decorated);
        this.setStrategy(strategy);
    }

    protected void removeAllListeners() {
        this.eventMap.getOnBeforePutEvent().remove(this.beforePutListener);
        this.eventMap.getOnBeforeRemoveEvent().remove(this.beforeRemoveListener);
        this.eventMap.getOnBeforeClearEvent().remove(this.beforeRemoveListener);
    }

    public UnmodifiableStrategy_1x0 getStrategy() {
        return this.strategy;
    }

    public void setStrategy(UnmodifiableStrategy_1x0 strategy) {
        boolean strategyHasChanged = false;
        strategyHasChanged = this.strategy == null ? true : !this.strategy.equals(strategy);
        this.strategy = strategy;
        this.removeAllListeners();
        if (UnmodifiableStrategy_1x0.RemoveAllowed.equals(this.strategy) || UnmodifiableStrategy_1x0.Unmodifiable.equals(this.strategy)) {
            this.eventMap.getOnBeforePutEvent().add(this.beforePutListener);
        }
        if (UnmodifiableStrategy_1x0.AddAllowed.equals(this.strategy) || UnmodifiableStrategy_1x0.Unmodifiable.equals(this.strategy)) {
            this.eventMap.getOnBeforeRemoveEvent().add(this.beforeRemoveListener);
            this.eventMap.getOnBeforeClearEvent().add(this.beforeRemoveListener);
        }
        if (strategyHasChanged) {
            this.fireOnStrategyChanged(strategy);
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        final UnmodifieableEntrySet entrySet = new UnmodifieableEntrySet(((Map)this.decorated).entrySet(), this.getStrategy());
        this.getOnStrategyChanged().add(new ActionListener_1x0<ActionEventAfter_1x0<UnmodifiableStrategy_1x0>>(){

            @Override
            public void actionPerformedImpl(ActionEventAfter_1x0<UnmodifiableStrategy_1x0> event) {
                entrySet.setStrategy(event.getData());
            }
        });
        return entrySet;
    }

    @Override
    public Set<K> keySet() {
        final UnmodifiableSet_1x0 keySet = new UnmodifiableSet_1x0(((Map)this.decorated).keySet(), this.getStrategy());
        this.getOnStrategyChanged().add(new ActionListener_1x0<ActionEventAfter_1x0<UnmodifiableStrategy_1x0>>(){

            @Override
            public void actionPerformedImpl(ActionEventAfter_1x0<UnmodifiableStrategy_1x0> event) {
                keySet.setStrategy(event.getData());
            }
        });
        return keySet;
    }

    @Override
    public Collection<V> values() {
        final UnmodifiableSet_1x0 values = new UnmodifiableSet_1x0(((Map)this.decorated).values(), this.getStrategy());
        this.getOnStrategyChanged().add(new ActionListener_1x0<ActionEventAfter_1x0<UnmodifiableStrategy_1x0>>(){

            @Override
            public void actionPerformedImpl(ActionEventAfter_1x0<UnmodifiableStrategy_1x0> event) {
                values.setStrategy(event.getData());
            }
        });
        return values;
    }

    protected void fireOnStrategyChanged(UnmodifiableStrategy_1x0 newStragegy) {
        if (this.onStrategyChanged == null) {
            return;
        }
        this.onStrategyChanged.fire(new ActionEventAfter_1x0<UnmodifiableStrategy_1x0>((Object)this, 0, "unmodifiable-strategy has changed", newStragegy));
    }

    public Delegate_1x0Impl<ActionEventAfter_1x0<UnmodifiableStrategy_1x0>> getOnStrategyChanged() {
        if (this.onStrategyChanged == null) {
            this.onStrategyChanged = new Delegate_1x0Impl();
        }
        return this.onStrategyChanged;
    }

    @Override
    public void setDecorated(Map<K, V> decorated) {
        this.eventMap.setDecorated(decorated);
        super.setDecorated(decorated);
    }

    @Override
    public void clear() {
        this.eventMap.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.eventMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.eventMap.containsValue(value);
    }

    @Override
    public V put(K key, V value) {
        return this.eventMap.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.eventMap.putAll(m);
    }

    @Override
    public V remove(Object key) {
        return this.eventMap.remove(key);
    }

    protected final class UnmodifieableEntrySet
    extends UnmodifiableSet_1x0<Map.Entry<K, V>> {
        protected UnmodifieableEntrySet(Collection<Map.Entry<K, V>> decorateable, UnmodifiableStrategy_1x0 strategy) {
            super(decorateable, strategy);
            this.getEventCollection().getOnBeforeGetEvent().add(new ActionListener_1x0<ActionEventBefore_1x0<Map.Entry<K, V>>>(){

                @Override
                public void actionPerformedImpl(ActionEventBefore_1x0<Map.Entry<K, V>> event) {
                    if (!UnmodifiableStrategy_1x0.Modifiable.equals(UnmodifieableEntrySet.this.getStrategy())) {
                        event.setData(UnmodifiableMap_1x0.unmodifieableEntry((Map.Entry)event.getData()));
                    }
                }
            });
        }
    }
}

