/*
 * Decompiled with CFR 0.152.
 */
package org.happy.collections.decorators;

import java.util.Collection;
import java.util.Iterator;
import org.happy.collections.decorators.CollectionDecorator_1x0;
import org.happy.commons.patterns.Lockable_1x0;

public class SynchronizedCollection_1x2<E>
extends CollectionDecorator_1x0<E, Collection<E>>
implements Lockable_1x0 {
    private Object lockObject;

    public static <E> SynchronizedCollection_1x2<E> of(Collection<E> c) {
        return new SynchronizedCollection_1x2<E>(c);
    }

    public static <E> SynchronizedCollection_1x2<E> of(Collection<E> c, Object lockObject) {
        return new SynchronizedCollection_1x2<E>(c, lockObject);
    }

    public SynchronizedCollection_1x2(Collection<E> decorateable) {
        this(decorateable, true);
    }

    public SynchronizedCollection_1x2(Collection<E> decorateable, boolean decorateIterators) {
        super(decorateable, decorateIterators);
        this.setLockObject(this);
    }

    public SynchronizedCollection_1x2(Collection<E> decorateable, Object lockObject) {
        this(decorateable, lockObject, true);
    }

    public SynchronizedCollection_1x2(Collection<E> decorateable, Object lockObject, boolean decorateIterators) {
        super(decorateable, decorateIterators);
        this.setLockObject(lockObject);
    }

    @Override
    public Object getLockObject() {
        return this.lockObject;
    }

    @Override
    public void setLockObject(Object lockObject) {
        if (lockObject == null) {
            throw new IllegalArgumentException("The lockObject can't be null!");
        }
        this.lockObject = lockObject;
    }

    @Override
    protected Iterator<E> iteratorImpl() {
        return new Iterator<E>(){
            Iterator<E> it;
            {
                this.it = ((Collection)SynchronizedCollection_1x2.this.decorated).iterator();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                Object object = SynchronizedCollection_1x2.this.lockObject;
                synchronized (object) {
                    return this.it.hasNext();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public E next() {
                Object object = SynchronizedCollection_1x2.this.lockObject;
                synchronized (object) {
                    return this.it.next();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove() {
                Object object = SynchronizedCollection_1x2.this.lockObject;
                synchronized (object) {
                    this.it.remove();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        Object object = this.lockObject;
        synchronized (object) {
            return ((Collection)this.decorated).add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> c) {
        Object object = this.lockObject;
        synchronized (object) {
            return ((Collection)this.decorated).addAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lockObject;
        synchronized (object) {
            ((Collection)this.decorated).clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        Object object = this.lockObject;
        synchronized (object) {
            return ((Collection)this.decorated).contains(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        Object object = this.lockObject;
        synchronized (object) {
            return ((Collection)this.decorated).containsAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Object object = this.lockObject;
        synchronized (object) {
            return ((Collection)this.decorated).hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.lockObject;
        synchronized (object) {
            return ((Collection)this.decorated).isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<E> iterator() {
        Object object = this.lockObject;
        synchronized (object) {
            return ((Collection)this.decorated).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        Object object = this.lockObject;
        synchronized (object) {
            return ((Collection)this.decorated).remove(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        Object object = this.lockObject;
        synchronized (object) {
            return ((Collection)this.decorated).removeAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        Object object = this.lockObject;
        synchronized (object) {
            return ((Collection)this.decorated).retainAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.lockObject;
        synchronized (object) {
            return ((Collection)this.decorated).size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Object object = this.lockObject;
        synchronized (object) {
            return ((Collection)this.decorated).toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        Object object = this.lockObject;
        synchronized (object) {
            return ((Collection)this.decorated).toArray(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Object object = this.lockObject;
        synchronized (object) {
            return ((Collection)this.decorated).toString();
        }
    }
}

