/*
 * Decompiled with CFR 0.152.
 */
package motifSets;

import java.util.ArrayList;
import java.util.Arrays;
import motifSets.ClusterMK;
import motifSets.Distance;
import motifSets.ScanMK;
import motifSets.SetFinder;
import motifSets.SlidingWindow;

public class TestMotifDiscoveryMotifletsPaper {
    public static double[] parse(String s) {
        int length = (int)s.chars().filter(ch -> ch == 44).count() + 1;
        double[] output = new double[length];
        String listString = s.substring(1, s.length() - 1);
        int i = 0;
        for (String token : listString.split(",")) {
            output[i++] = Double.valueOf(token.trim());
        }
        return output;
    }

    public static void main(String[] args) {
        int w = 160;
        Type type = Type.SetFinder;
        String path = "/Users/bzcschae/workspace/motiflets/datasets/";
        String file_name = path + "fNIRS_subLen_600.csv";
        double[] radii = new double[]{10.0, 20.0, 30.0, 40.0, 50.0, 60.0, 70.0, 80.0, 90.0, 100.0};
        if (args.length >= 1) {
            file_name = args[0];
        }
        if (args.length >= 2) {
            type = Type.valueOf(args[1]);
        }
        if (args.length >= 3) {
            radii = TestMotifDiscoveryMotifletsPaper.parse(args[2]);
        }
        if (args.length >= 4) {
            w = Integer.valueOf(args[3]);
        }
        double[][] data = SlidingWindow.loadSegments(file_name, w);
        System.out.println("Dataset:" + file_name);
        if (type == Type.ScanMK) {
            System.out.println("Scan MK");
            System.out.println("[");
            for (double r : radii) {
                ScanMK smk = new ScanMK(data, w, r, 1);
                ArrayList<ArrayList<Integer>> sets = smk.getMotifSet();
                TestMotifDiscoveryMotifletsPaper.printTopMotif(sets);
            }
        } else if (type == Type.SetFinder) {
            System.out.println("Set Finder");
            System.out.println("[");
            for (double r : radii) {
                SetFinder sf = new SetFinder(data, r, w);
                sf.findMotifSets();
                ArrayList<ArrayList<Integer>> sets = sf.getMotifSet();
                TestMotifDiscoveryMotifletsPaper.printTopMotif(sets);
            }
        } else if (type == Type.ClusterMK) {
            System.out.println("Cluster MK");
            System.out.println("[");
            for (double r : radii) {
                ClusterMK mk = new ClusterMK(data, w, r);
                ArrayList<ArrayList<Integer>> sets = mk.getMotifSet();
                TestMotifDiscoveryMotifletsPaper.printTopMotif(sets);
            }
        }
        System.out.println("]");
    }

    public static void printTopMotif(ArrayList<ArrayList<Integer>> sets) {
        for (ArrayList<Integer> set : sets) {
            if (set.isEmpty()) continue;
            System.out.print("\t" + Arrays.toString((Object[])set.toArray(new Integer[0])));
            System.out.println(",");
            break;
        }
    }

    public static void checkPairWiseDistances(ArrayList<ArrayList<Integer>> motifSets, double[][] data, double r) {
        for (ArrayList<Integer> set : motifSets) {
            for (Integer offset : set) {
                for (Integer offset2 : set) {
                    double[] seq2;
                    double[] seq1;
                    double dist;
                    if (offset.equals(offset2) || offset >= data.length || offset2 >= data.length || !((dist = Distance.distanceEuclidean(seq1 = data[offset], seq2 = data[offset2])) > 2.0 * r)) continue;
                    System.err.println("Motif error:" + offset + " " + offset2 + " " + dist);
                }
            }
        }
    }

    public static enum Type {
        SetFinder,
        ScanMK,
        ClusterMK;

    }
}

