/*
 * Decompiled with CFR 0.152.
 */
package motifSets;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import motifSets.Distance;

public class SetFinder {
    private final double r;
    private final int n;
    private MotifStore sto;
    private final double[][] data;
    private final ArrayList<ArrayList<Integer>> motifSet;

    public SetFinder(double[][] data, double r, int w) {
        this.r = r;
        this.n = w;
        this.data = data;
        this.motifSet = new ArrayList();
    }

    public void findMotifSets() {
        Object tmp;
        int j;
        int i;
        this.sto = new MotifStore();
        for (i = 0; i < this.data.length; ++i) {
            ArrayList<Integer> final_pos = new ArrayList<Integer>();
            ArrayList<Double> final_dists = new ArrayList<Double>();
            for (j = 0; j < this.data.length; ++j) {
                double dist;
                if (Math.abs(i - j) < this.n / 2 || !((dist = Distance.distAbanSquared(this.data[i], this.data[j], this.r)) < this.r)) continue;
                final_pos.add(j);
                final_dists.add(dist);
                j += this.n / 2;
            }
            this.sto.addSubsequence(i, final_pos, final_dists);
        }
        this.sto.sortByMatches();
        this.sto.removeNoMatch();
        for (i = 0; i < this.sto.size(); ++i) {
            try {
                this.sto.checkOverlap(i);
            }
            catch (Exception final_pos) {
                // empty catch block
            }
            tmp = new int[this.sto.getMatches(i) + 1];
            tmp[0] = this.sto.getIndex(i);
            for (int j2 = 0; j2 < this.sto.getStore(i).size(); ++j2) {
                tmp[j2 + 1] = (Integer)this.sto.getStore(i).get(j2);
            }
            for (int k = 0; k < ((Object)tmp).length; ++k) {
                for (j = i + 1; j < this.sto.size(); ++j) {
                    if (Math.abs((int)(tmp[k] - this.sto.getIndex(j))) >= this.n / 2 && !(Distance.distAbanSquared(this.data[tmp[k]], this.data[this.sto.getIndex(j)], 2.0 * this.r) < 2.0 * this.r)) continue;
                    this.sto.removeSubsequence(false, j);
                    --j;
                }
            }
        }
        for (i = 0; i < this.sto.size(); ++i) {
            tmp = new int[this.sto.getMatches(i) + 1];
            for (int j3 = 0; j3 < this.sto.getStore(i).size(); ++j3) {
                tmp[j3] = (Integer)this.sto.getStore(i).get(j3);
            }
            tmp[((int[])tmp).length - 1] = this.sto.getIndex(i);
            for (int l = 0; l < ((Object)tmp).length; ++l) {
                for (j = i + 1; j < this.sto.size(); ++j) {
                    for (int k = 0; k < this.sto.getStore(j).size(); ++k) {
                        if (Math.abs((Integer)this.sto.getStore(j).get(k) - tmp[l]) >= this.n / 2 && !(Distance.distAbanSquared(this.data[tmp[l]], this.data[(Integer)this.sto.getStore(j).get(k)], 2.0 * this.r) < 2.0 * this.r)) continue;
                        this.sto.removeMatch(j, k);
                    }
                }
            }
        }
        this.sto.removeNoMatch();
        for (i = 0; i < this.sto.size(); ++i) {
            tmp = new ArrayList();
            ((ArrayList)tmp).add(this.sto.getIndex(i));
            for (int j4 = 0; j4 < this.sto.getStore(i).size(); ++j4) {
                ((ArrayList)tmp).add(this.sto.getStore(i).get(j4));
            }
            for (int l = 0; l < this.sto.size(); ++l) {
                for (j = 0; j < ((ArrayList)tmp).size(); ++j) {
                    for (int k = 0; k < this.sto.getPoss(l).size(); ++k) {
                        int ma = (Integer)this.sto.getPoss(l).get(k);
                        if (Math.abs(ma - (Integer)((ArrayList)tmp).get(j)) >= this.n / 2) continue;
                        this.sto.removePoss(l, k);
                        --k;
                    }
                }
            }
        }
        for (i = 0; i < this.sto.size(); ++i) {
            block19: for (int j5 = 0; j5 < this.sto.getPoss(i).size(); ++j5) {
                for (int k = j5 + 1; k < this.sto.getPoss(i).size(); ++k) {
                    int second;
                    int first = (Integer)this.sto.getPoss(i).get(j5);
                    if (Math.abs(first - (second = ((Integer)this.sto.getPoss(i).get(k)).intValue())) >= this.n) continue;
                    double dist1 = Distance.distance(this.data[this.sto.getIndex(i)], this.data[first]);
                    double dist2 = Distance.distance(this.data[this.sto.getIndex(i)], this.data[second]);
                    for (int l = 0; l < this.sto.getStore(i).size(); ++l) {
                        dist1 += Distance.distance(this.data[(Integer)this.sto.getStore(i).get(l)], this.data[first]);
                        dist2 += Distance.distance(this.data[(Integer)this.sto.getStore(i).get(l)], this.data[second]);
                    }
                    if (dist1 > dist2) {
                        this.sto.removePoss(i, j5);
                        --j5;
                        continue block19;
                    }
                    this.sto.removePoss(i, k);
                    if (j5 < --k) continue;
                    --j5;
                    continue block19;
                }
            }
        }
        for (i = 0; i < this.sto.size(); ++i) {
            ArrayList<Integer> tmp2 = new ArrayList<Integer>();
            tmp2.add(this.sto.getIndex(i));
            for (int j6 = 0; j6 < this.sto.getStore(i).size(); ++j6) {
                tmp2.add((Integer)this.sto.getStore(i).get(j6));
            }
            this.motifSet.add(tmp2);
        }
    }

    public ArrayList<ArrayList<Integer>> getMotifSet() {
        return this.motifSet;
    }

    public void outputFile(String outFile) throws IOException {
        PrintWriter cout = new PrintWriter((Writer)new FileWriter(outFile), true);
        String use = "";
        String mac = "";
        for (int i = 0; i < this.sto.size(); ++i) {
            int j;
            use = use + this.sto.getIndex(i) + "/";
            for (j = 0; j < this.sto.getStore(i).size(); ++j) {
                mac = mac + this.sto.getStore(i).get(j) + ",";
            }
            for (j = 0; j < this.sto.getPoss(i).size(); ++j) {
                mac = mac + "P" + this.sto.getPoss(i).get(j) + ",";
            }
            mac = mac + "/";
        }
        cout.println("r/n");
        cout.flush();
        cout.println(this.r + "/" + this.n + "/");
        cout.flush();
        cout.println(use);
        cout.flush();
        cout.println(mac);
        cout.flush();
    }

    public ArrayList removeTrivialMatches(ArrayList<Integer> locs, double[][] data, double[][] locations, int n) {
        int count = 1;
        ArrayList<Integer> rem = new ArrayList<Integer>();
        while (count > 0) {
            int[] trivs = new int[locs.size()];
            int i = 0;
            for (int locs_i : locs) {
                trivs[i] = 0;
                for (int locs_j : locs) {
                    if (Math.abs(locs_i - locs_j) >= n || locs_i == locs_j) continue;
                    int n2 = i;
                    trivs[n2] = trivs[n2] + 1;
                }
                ++i;
            }
            count = 0;
            double dists = 0.0;
            int pos = 0;
            double maxDist = 0.0;
            int i2 = 0;
            for (int locs_i : locs) {
                count += trivs[i2];
                if (trivs[i2] > 0) {
                    int j;
                    for (j = 0; j < locations.length; ++j) {
                        dists += Distance.distance(data[locs_i], locations[j]);
                    }
                    j = 0;
                    for (int locs_j : locs) {
                        if (i2 != j) {
                            dists += Distance.distance(data[locs_i], data[locs_j]);
                        }
                        ++j;
                    }
                    if (dists > maxDist) {
                        maxDist = dists;
                        pos = i2;
                    }
                }
                ++i2;
            }
            if (count <= 0) continue;
            locs.remove(pos);
            rem.add(pos);
        }
        return rem;
    }

    public class Candidate
    implements Comparable<Candidate> {
        int pos;
        double dist;

        public Candidate(int pos, double dist) {
            this.pos = pos;
            this.dist = dist;
        }

        @Override
        public int compareTo(Candidate o) {
            return this.pos - o.pos;
        }
    }

    public static class MotifStore {
        private ArrayList<Integer> matches = new ArrayList();
        private ArrayList<Integer> index = new ArrayList();
        private ArrayList<ArrayList> store = new ArrayList();
        private ArrayList<ArrayList> distances = new ArrayList();
        private ArrayList<Double> distTot = new ArrayList();
        private ArrayList<ArrayList> possMatch = new ArrayList();

        public void addSubsequence(int ind, ArrayList matchSub, ArrayList distSub) {
            this.index.add(ind);
            this.matches.add(matchSub.size());
            this.store.add(matchSub);
            this.distances.add(distSub);
            this.possMatch.add(new ArrayList());
            if (distSub.size() > 0) {
                Iterator it = distSub.iterator();
                double tot = 0.0;
                while (it.hasNext()) {
                    tot += ((Double)it.next()).doubleValue();
                }
                this.distTot.add(tot);
            } else {
                this.distTot.add(0.0);
            }
        }

        public void removeSubsequence(boolean origIndex, int no) {
            if (origIndex) {
                int pos = 0;
                boolean error = true;
                for (int i = 0; i < this.index.size(); ++i) {
                    if (this.index.get(i) != no) continue;
                    pos = i;
                    error = false;
                }
                if (!error) {
                    this.matches.remove(pos);
                    this.index.remove(pos);
                    this.distances.remove(pos);
                    this.distTot.remove(pos);
                    this.store.remove(pos);
                    this.possMatch.remove(pos);
                } else {
                    System.err.println("Error, no such index found.");
                }
            } else {
                this.matches.remove(no);
                this.index.remove(no);
                this.distances.remove(no);
                this.distTot.remove(no);
                this.store.remove(no);
                this.possMatch.remove(no);
            }
        }

        public int getMatches(int no) {
            return this.matches.get(no);
        }

        public int getIndex(int no) {
            return this.index.get(no);
        }

        public ArrayList getPoss(int no) {
            return this.possMatch.get(no);
        }

        public void removePoss(int sub, int no) {
            this.possMatch.get(sub).remove(no);
        }

        public ArrayList getStore(int no) {
            return this.store.get(no);
        }

        public boolean matches(int no, int mat) {
            boolean anyMatch = this.matches.get(no) > mat;
            return anyMatch;
        }

        public int size() {
            return this.index.size();
        }

        public void removeMatch(int seq, int mat) {
            this.store.get(seq).remove(mat);
            double dis = (Double)this.distances.get(seq).get(mat);
            double to = this.distTot.get(seq);
            this.distTot.add(seq, to -= dis);
            this.distTot.remove(seq + 1);
            this.distances.get(seq).remove(mat);
            int tmp = this.matches.get(seq) - 1;
            this.matches.add(seq, tmp);
            this.matches.remove(seq + 1);
        }

        public void sortByMatches() {
            ArrayList<Integer> sortMatch = new ArrayList<Integer>();
            ArrayList<Integer> sortIndex = new ArrayList<Integer>();
            ArrayList<ArrayList> sortStore = new ArrayList<ArrayList>();
            ArrayList<ArrayList> sortDist = new ArrayList<ArrayList>();
            ArrayList<Double> sortTot = new ArrayList<Double>();
            ArrayList<ArrayList> sortPoss = new ArrayList<ArrayList>();
            for (int i = 0; i < this.matches.size(); ++i) {
                boolean done = false;
                for (int j = 0; j < sortMatch.size(); ++j) {
                    if (this.matches.get(i) <= (Integer)sortMatch.get(j) && (this.matches.get(i) != sortMatch.get(j) || !(this.distTot.get(i) < (Double)sortTot.get(j)))) continue;
                    sortMatch.add(j, this.matches.get(i));
                    sortIndex.add(j, i);
                    sortStore.add(j, this.store.get(i));
                    sortDist.add(j, this.distances.get(i));
                    sortTot.add(j, this.distTot.get(i));
                    sortPoss.add(j, this.possMatch.get(i));
                    done = true;
                    break;
                }
                if (done) continue;
                sortMatch.add(this.matches.get(i));
                sortIndex.add(i);
                sortStore.add(this.store.get(i));
                sortDist.add(this.distances.get(i));
                sortTot.add(this.distTot.get(i));
                sortPoss.add(this.possMatch.get(i));
            }
            this.matches = sortMatch;
            this.index = sortIndex;
            this.store = sortStore;
            this.distances = sortDist;
            this.distTot = sortTot;
            this.possMatch = sortPoss;
        }

        public void removeNoMatch() {
            int pos = -1;
            for (int i = 0; i < this.matches.size(); ++i) {
                if (this.matches.get(i) != 0) continue;
                pos = i;
                break;
            }
            if (pos > -1) {
                this.matches.subList(pos, this.matches.size()).clear();
                this.index.subList(pos, this.index.size()).clear();
                this.store.subList(pos, this.store.size()).clear();
                this.distances.subList(pos, this.distances.size()).clear();
                this.distTot.subList(pos, this.distTot.size()).clear();
                this.possMatch.subList(pos, this.possMatch.size()).clear();
            }
        }

        private int convertIndex(int in) throws Exception {
            int pos = -1;
            boolean error = true;
            int newIndex = -1;
            for (int i = 0; i < this.index.size(); ++i) {
                if (this.index.get(i) != in) continue;
                pos = i;
                error = false;
            }
            if (error) {
                Exception e = new Exception();
                throw e;
            }
            newIndex = pos;
            return newIndex;
        }

        public void checkOverlap(int first) throws Exception {
            int fOrig = this.index.get(first);
            ArrayList tmp = this.store.get(first);
            ArrayList<Integer> indTmp = new ArrayList<Integer>();
            for (int i = 0; i < tmp.size(); ++i) {
                indTmp.add(this.convertIndex((Integer)tmp.get(i)));
            }
            ArrayList ste = new ArrayList();
            for (int i = 0; i < indTmp.size(); ++i) {
                ArrayList mat = this.store.get((Integer)indTmp.get(i));
                for (int j = 0; j < mat.size(); ++j) {
                    ste.add(mat.get(j));
                }
            }
            ArrayList fin = new ArrayList();
            for (int i = 0; i < ste.size(); ++i) {
                if ((Integer)ste.get(i) == fOrig) continue;
                fin.add(ste.get(i));
            }
            if (fin.size() > 0) {
                this.possMatch.add(first, fin);
                this.possMatch.remove(first + 1);
            }
        }
    }
}

