/*
 * Decompiled with CFR 0.152.
 */
package lm;

import java.util.Random;

public class BruteForceMotif {
    public double[][] S;
    public double[][] M;
    public int K;
    public int J;
    public int L;
    public double T;
    Random rand = new Random();

    public int ComputeHardFrequency(double[] motifCandidate) {
        int hardFrequency = 0;
        double dist = 0.0;
        int lastMatchIndex = -2;
        for (int j = 0; j < this.J; ++j) {
            dist = 0.0;
            for (int l = 0; l < this.L; ++l) {
                dist += (motifCandidate[l] - this.S[j][l]) * (motifCandidate[l] - this.S[j][l]);
            }
            if (!((dist = Math.sqrt(dist)) <= this.T)) continue;
            if (j - lastMatchIndex > this.L) {
                ++hardFrequency;
            }
            lastMatchIndex = j;
        }
        return hardFrequency;
    }

    public int Search() {
        System.out.println("BruteForce T:" + this.T);
        int[] hardFrequencies = new int[this.J];
        for (int j = 0; j < this.J; ++j) {
            hardFrequencies[j] = this.ComputeHardFrequency(this.S[j]);
        }
        this.M = new double[this.K][this.L];
        int hardScoreTotal = 0;
        for (int k = 0; k < this.K; ++k) {
            int motifSegmentIndex = this.rand.nextInt(this.J);
            for (int j = 0; j < this.J; ++j) {
                if (!this.isDiverse(this.S[j], k) || hardFrequencies[j] <= hardFrequencies[motifSegmentIndex]) continue;
                motifSegmentIndex = j;
            }
            for (int l = 0; l < this.L; ++l) {
                this.M[k][l] = this.S[motifSegmentIndex][l];
            }
            hardScoreTotal += hardFrequencies[motifSegmentIndex];
        }
        return hardScoreTotal;
    }

    public boolean isDiverse(double[] candidate, int currentNumMotifsSelected) {
        double dist = 0.0;
        for (int k = 0; k < currentNumMotifsSelected; ++k) {
            dist = 0.0;
            for (int l = 0; l < this.L; ++l) {
                dist += (candidate[l] - this.M[k][l]) * (candidate[l] - this.M[k][l]);
            }
            if (!((dist = Math.sqrt(dist)) < 2.0 * this.T)) continue;
            return false;
        }
        return true;
    }

    public void PrintHardLocations(double[] motifCandidate) {
        double dist = 0.0;
        int lastMatchIndex = -2;
        for (int j = 0; j < this.J; ++j) {
            dist = 0.0;
            for (int l = 0; l < this.L; ++l) {
                dist += (motifCandidate[l] - this.S[j][l]) * (motifCandidate[l] - this.S[j][l]);
            }
            if (!(dist <= this.T)) continue;
            if (j - lastMatchIndex > this.L) {
                System.out.print(j + " ");
            }
            lastMatchIndex = j;
        }
    }
}

