/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.chemistry;

import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.chemistry.Compounds;
import com.rapidminer.operator.io.AbstractReader;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDirectory;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.EqualTypeCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import java.io.File;
import java.util.List;
import libpadeldescriptor.IteratingPaDELReader;
import org.openscience.cdk.interfaces.IAtomContainer;

public class CompoundSource
extends AbstractReader<Compounds> {
    public static final String PARAMETER_READ_FILEDIR = "read";
    public static final String PARAMETER_MOL_FILE = "file";
    public static final String PARAMETER_READ_SINGLE = "read_single_compound";
    public static final String PARAMETER_CPD_INDEX = "index_of_compound_to_read";
    public static final String PARAMETER_DIRECTORIES = "directories";
    public static final String PARAMETER_DIRECTORY_IGNORE = "enter_anything_here";
    public static final String PARAMETER_DIRECTORY = "directory";
    public static final String PARAMETER_FILENAME_AS_NAME = "use_filename_as_compound_name";
    public static final String[] readFileDirStrings = new String[]{"File", "Directories"};

    public CompoundSource(OperatorDescription operatorDescription) {
        super(operatorDescription, Compounds.class);
    }

    public List<ParameterType> getParameterTypes() {
        List list = super.getParameterTypes();
        ParameterTypeCategory parameterTypeCategory = null;
        parameterTypeCategory = new ParameterTypeCategory(PARAMETER_READ_FILEDIR, "Read file/directory", readFileDirStrings, 0);
        parameterTypeCategory.setExpert(false);
        list.add(parameterTypeCategory);
        parameterTypeCategory = new ParameterTypeFile(PARAMETER_MOL_FILE, "Filename of molecular file to read compound(s).", null, true);
        parameterTypeCategory.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_READ_FILEDIR, readFileDirStrings, true, new int[]{0}));
        parameterTypeCategory.setExpert(false);
        list.add(parameterTypeCategory);
        parameterTypeCategory = new ParameterTypeBoolean(PARAMETER_READ_SINGLE, "Read a single compound only.", false);
        parameterTypeCategory.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_READ_FILEDIR, readFileDirStrings, true, new int[]{0}));
        parameterTypeCategory.setExpert(false);
        list.add(parameterTypeCategory);
        parameterTypeCategory = new ParameterTypeInt(PARAMETER_CPD_INDEX, "Index of compound in file to read.", 1, Integer.MAX_VALUE, 1);
        parameterTypeCategory.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_READ_SINGLE, true, true));
        parameterTypeCategory.setExpert(false);
        list.add(parameterTypeCategory);
        parameterTypeCategory = new ParameterTypeList(PARAMETER_DIRECTORIES, "Directories with molecular files.", (ParameterType)new ParameterTypeString(PARAMETER_DIRECTORY_IGNORE, "Leave this empty."), (ParameterType)new ParameterTypeDirectory(PARAMETER_DIRECTORY, "Directory with molecular files.", true));
        parameterTypeCategory.registerDependencyCondition((ParameterCondition)new EqualTypeCondition((ParameterHandler)this, PARAMETER_READ_FILEDIR, readFileDirStrings, true, new int[]{1}));
        parameterTypeCategory.setExpert(false);
        list.add(parameterTypeCategory);
        parameterTypeCategory = new ParameterTypeBoolean(PARAMETER_FILENAME_AS_NAME, "Use filename as compound name.", false);
        parameterTypeCategory.setExpert(true);
        list.add(parameterTypeCategory);
        return list;
    }

    public Compounds read() throws OperatorException {
        int n = this.getParameterAsInt(PARAMETER_READ_FILEDIR);
        if (n == 0) {
            Compounds compounds = new Compounds();
            return this.readFile(compounds, this.getParameterAsFile(PARAMETER_MOL_FILE), false);
        }
        return this.readDir();
    }

    private Compounds readFile(Compounds compounds, File file, boolean bl) throws OperatorException {
        IteratingPaDELReader iteratingPaDELReader = null;
        try {
            iteratingPaDELReader = new IteratingPaDELReader(file);
        }
        catch (Exception exception) {
            throw new OperatorException("Cannot read molecular file: " + file.getAbsolutePath());
        }
        int n = -1;
        if (!bl && this.getParameterAsBoolean(PARAMETER_READ_SINGLE)) {
            n = this.getParameterAsInt(PARAMETER_CPD_INDEX);
        }
        int n2 = 0;
        while (iteratingPaDELReader.hasNext()) {
            ++n2;
            IAtomContainer iAtomContainer = (IAtomContainer)iteratingPaDELReader.next();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.setLength(0);
            if (iAtomContainer.getProperty((Object)"cdk:Title") != null && !this.getParameterAsBoolean(PARAMETER_FILENAME_AS_NAME)) {
                stringBuffer.append(iAtomContainer.getProperty((Object)"cdk:Title"));
            } else {
                String string = this.getParameterAsBoolean(PARAMETER_FILENAME_AS_NAME) ? "" : "AUTOGEN_";
                int n3 = file.getName().lastIndexOf(".");
                if (n3 != -1) {
                    stringBuffer.append(string + file.getName().substring(0, n3));
                } else {
                    stringBuffer.append(string + file.getName());
                }
                if (n2 > 1 || iteratingPaDELReader.hasNext()) {
                    stringBuffer.append("_" + n2);
                }
                iAtomContainer.setProperty((Object)"cdk:Title", (Object)stringBuffer.toString());
            }
            iAtomContainer.setProperty((Object)"cdk:Remark", (Object)"Pharmaceutical Data Exploration Laboratory");
            if (n == -1) {
                compounds.addMolecule(iAtomContainer);
                continue;
            }
            if (n2 != n) continue;
            compounds.addMolecule(iAtomContainer);
            break;
        }
        return compounds;
    }

    private Compounds readDir() throws OperatorException {
        List list = this.getParameterList(PARAMETER_DIRECTORIES);
        Compounds compounds = new Compounds();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            File file = new File(((String[])list.get(i))[1]);
            for (File file2 : file.listFiles()) {
                if (file2.getName().equals(".") || file2.getName().equals("..") || file2.isDirectory()) continue;
                this.readFile(compounds, file2, true);
            }
        }
        return compounds;
    }

    static {
        AbstractReader.registerReaderDescription((AbstractReader.ReaderDescription)new AbstractReader.ReaderDescription("", CompoundSource.class, PARAMETER_MOL_FILE));
    }
}

