/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.graph.impl.scheduler;

import com.bigdata.rdf.graph.IGASSchedulerImpl;
import com.bigdata.rdf.graph.IStaticFrontier;
import com.bigdata.rdf.graph.impl.GASEngine;
import java.util.concurrent.ConcurrentHashMap;
import org.openrdf.model.Value;

public class CHMScheduler
implements IGASSchedulerImpl {
    private final ConcurrentHashMap<Value, Value> vertices;
    private final boolean sortFrontier;

    public CHMScheduler(GASEngine gasEngine) {
        this.vertices = new ConcurrentHashMap(gasEngine.getNThreads());
        this.sortFrontier = gasEngine.getSortFrontier();
    }

    @Override
    public void schedule(Value v) {
        this.vertices.putIfAbsent(v, v);
    }

    @Override
    public void clear() {
        this.vertices.clear();
    }

    @Override
    public void compactFrontier(IStaticFrontier frontier) {
        frontier.resetFrontier(this.vertices.size(), this.sortFrontier, this.vertices.keySet().iterator());
    }
}

