/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sparql.query;

import java.util.regex.Matcher;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.parser.sparql.SPARQLUtil;

public class QueryStringUtil {
    public static String getQueryString(String queryString, BindingSet bindings) {
        if (bindings.size() == 0) {
            return queryString;
        }
        String qry = queryString;
        int b = qry.indexOf(123);
        String select = qry.substring(0, b);
        String where = qry.substring(b);
        for (String name : bindings.getBindingNames()) {
            String replacement = QueryStringUtil.getReplacement(bindings.getValue(name));
            if (replacement == null) continue;
            String pattern = "[\\?\\$]" + name + "(?=\\W)";
            select = select.replaceAll(pattern, "(" + Matcher.quoteReplacement(replacement) + " as ?" + name + ")");
            where = where.replaceAll(pattern, Matcher.quoteReplacement(replacement));
        }
        return select + where;
    }

    private static String getReplacement(Value value) {
        StringBuilder sb = new StringBuilder();
        if (value instanceof URI) {
            return QueryStringUtil.appendValue(sb, (URI)value).toString();
        }
        if (value instanceof Literal) {
            return QueryStringUtil.appendValue(sb, (Literal)value).toString();
        }
        throw new IllegalArgumentException("BNode references not supported by SPARQL end-points");
    }

    private static StringBuilder appendValue(StringBuilder sb, URI uri) {
        sb.append("<").append(uri.stringValue()).append(">");
        return sb;
    }

    private static StringBuilder appendValue(StringBuilder sb, Literal lit) {
        sb.append('\"');
        sb.append(SPARQLUtil.encodeString((String)lit.getLabel()));
        sb.append('\"');
        if (lit.getLanguage() != null) {
            sb.append('@');
            sb.append(lit.getLanguage());
        } else if (lit.getDatatype() != null) {
            sb.append("^^<");
            sb.append(lit.getDatatype().stringValue());
            sb.append('>');
        }
        return sb;
    }
}

