/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.quantile;

import cern.colt.Timer;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.IntArrayList;
import cern.jet.stat.Descriptive;
import cern.jet.stat.quantile.DoubleQuantileFinder;
import cern.jet.stat.quantile.ExactDoubleQuantileFinder;
import cern.jet.stat.quantile.QuantileFinderFactory;
import cern.jet.stat.quantile.Utils;

class QuantileFinderTest {
    QuantileFinderTest() {
    }

    protected static IntArrayList binaryMultiSearch(DoubleArrayList list, double element) {
        int to;
        int from;
        int index = list.binarySearch(element);
        if (index < 0) {
            return null;
        }
        for (from = index - 1; from >= 0 && list.get(from) == element; --from) {
        }
        ++from;
        for (to = index + 1; to < list.size() && list.get(to) == element; ++to) {
        }
        return new IntArrayList(new int[]{from, --to});
    }

    public static double epsilon(int size, double phi, double rank) {
        double s = size;
        return Math.abs(rank / s - phi);
    }

    public static double epsilon(DoubleArrayList sortedList, double phi, double element) {
        double rank = Descriptive.rankInterpolated(sortedList, element);
        return QuantileFinderTest.epsilon(sortedList.size(), phi, rank);
    }

    public static double epsilon(DoubleArrayList sortedList, DoubleQuantileFinder finder, double phi) {
        double element = finder.quantileElements(new DoubleArrayList(new double[]{phi})).get(0);
        return QuantileFinderTest.epsilon(sortedList, phi, element);
    }

    public static void main(String[] args) {
        QuantileFinderTest.testBestBandKCalculation(args);
    }

    public static double observedEpsilonAtPhi(double phi, ExactDoubleQuantileFinder exactFinder, DoubleQuantileFinder approxFinder) {
        int N = (int)exactFinder.size();
        int exactRank = (int)Utils.epsilonCeiling(phi * (double)N) - 1;
        exactFinder.quantileElements(new DoubleArrayList(new double[]{phi})).get(0);
        double approxElement = approxFinder.quantileElements(new DoubleArrayList(new double[]{phi})).get(0);
        IntArrayList approxRanks = QuantileFinderTest.binaryMultiSearch(exactFinder.buffer, approxElement);
        int from = approxRanks.get(0);
        int to = approxRanks.get(1);
        int distance = from <= exactRank && exactRank <= to ? 0 : (from > exactRank ? Math.abs(from - exactRank) : Math.abs(exactRank - to));
        double epsilon = (double)distance / (double)N;
        return epsilon;
    }

    public static DoubleArrayList observedEpsilonsAtPhis(DoubleArrayList phis, ExactDoubleQuantileFinder exactFinder, DoubleQuantileFinder approxFinder, double desiredEpsilon) {
        DoubleArrayList epsilons = new DoubleArrayList(phis.size());
        int i = phis.size();
        while (--i >= 0) {
            double epsilon = QuantileFinderTest.observedEpsilonAtPhi(phis.get(i), exactFinder, approxFinder);
            epsilons.add(epsilon);
            if (!(epsilon > desiredEpsilon)) continue;
            System.out.println("Real epsilon = " + epsilon + " is larger than desired by " + (epsilon - desiredEpsilon));
        }
        return epsilons;
    }

    public static void test() {
        String max_N;
        String quantiles;
        String delta;
        String epsilon;
        String doShuffle;
        String computeExactQuantilesAlso;
        String chunks;
        String enableLogging;
        String k;
        String b;
        String size;
        String[] args = new String[20];
        args[0] = size = "10000";
        args[1] = b = "12";
        args[2] = k = "2290";
        args[3] = enableLogging = "log";
        args[4] = chunks = "10";
        args[5] = computeExactQuantilesAlso = "exact";
        args[6] = doShuffle = "shuffle";
        args[7] = epsilon = "0.001";
        args[8] = delta = "0.0001";
        args[9] = quantiles = "1";
        args[10] = max_N = "-1";
        QuantileFinderTest.testQuantileCalculation(args);
    }

    public static void testBestBandKCalculation(String[] args) {
        int[] quantiles = new int[]{100, 10000};
        long[] sizes = new long[]{Long.MAX_VALUE, 1000000L, 10000000L, 100000000L};
        double[] deltas = new double[]{0.0, 0.1, 1.0E-5};
        double[] epsilons = new double[]{0.0, 0.1, 0.01, 0.001, 1.0E-4, 1.0E-5, 1.0E-6};
        System.out.println("\n\n");
        System.out.println("mem [Math.round(elements/1000.0)]");
        System.out.println("***********************************");
        Timer timer = new Timer().start();
        for (int q = 0; q < quantiles.length; ++q) {
            int p = quantiles[q];
            System.out.println("------------------------------");
            System.out.println("computing for p = " + p);
            for (int s = 0; s < sizes.length; ++s) {
                long N = sizes[s];
                System.out.println("   ------------------------------");
                System.out.println("   computing for N = " + N);
                for (int e = 0; e < epsilons.length; ++e) {
                    double epsilon = epsilons[e];
                    System.out.println("      ------------------------------");
                    System.out.println("      computing for e = " + epsilon);
                    for (int d = 0; d < deltas.length; ++d) {
                        double delta = deltas[d];
                        for (int knownCounter = 0; knownCounter < 2; ++knownCounter) {
                            boolean known_N = knownCounter == 0;
                            DoubleQuantileFinder finder = QuantileFinderFactory.newDoubleQuantileFinder(known_N, N, epsilon, delta, p, null);
                            String knownStr = known_N ? "  known" : "unknown";
                            long mem = finder.totalMemory();
                            if (mem == 0L) {
                                mem = N;
                            }
                            System.out.print("         (known, d)=(" + knownStr + ", " + delta + ") --> ");
                            System.out.print("(MB,mem");
                            System.out.print(")=(" + (double)mem * 8.0 / 1024.0 / 1024.0 + ",  " + (double)mem / 1000.0 + ",  " + Math.round((double)mem * 8.0 / 1024.0 / 1024.0));
                            System.out.println(")");
                        }
                    }
                }
            }
        }
        timer.stop().display();
    }

    public static void testLocalVarDeclarationSpeed(int size) {
        System.out.println("free=" + Runtime.getRuntime().freeMemory());
        System.out.println("total=" + Runtime.getRuntime().totalMemory());
        Timer timer = new Timer().start();
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                Object buffer = null;
                int val = 10;
                double f = 1.0;
            }
        }
        System.out.println(timer.stop());
        System.out.println("free=" + Runtime.getRuntime().freeMemory());
        System.out.println("total=" + Runtime.getRuntime().totalMemory());
    }

    public static void testQuantileCalculation(String[] args) {
        int size = Integer.parseInt(args[0]);
        int b = Integer.parseInt(args[1]);
        int k = Integer.parseInt(args[2]);
        int chunks = Integer.parseInt(args[4]);
        boolean computeExactQuantilesAlso = args[5].equals("exact");
        boolean doShuffle = args[6].equals("shuffle");
        double epsilon = new Double(args[7]);
        double delta = new Double(args[8]);
        int quantiles = Integer.parseInt(args[9]);
        long max_N = Long.parseLong(args[10]);
        System.out.println("free=" + Runtime.getRuntime().freeMemory());
        System.out.println("total=" + Runtime.getRuntime().totalMemory());
        double[] phis = new double[]{0.001, 0.01, 0.1, 0.5, 0.9, 0.99, 0.999, 1.0};
        Timer timer = new Timer();
        Timer timer2 = new Timer();
        DoubleQuantileFinder approxFinder = QuantileFinderFactory.newDoubleQuantileFinder(false, max_N, epsilon, delta, quantiles, null);
        System.out.println(approxFinder);
        DoubleQuantileFinder exactFinder = QuantileFinderFactory.newDoubleQuantileFinder(false, -1L, 0.0, delta, quantiles, null);
        System.out.println(exactFinder);
        DoubleArrayList list = new DoubleArrayList(size);
        for (int chunk = 0; chunk < chunks; ++chunk) {
            list.setSize(0);
            int d = chunk * size;
            timer2.start();
            for (int i = 0; i < size; ++i) {
                list.add(i + d);
            }
            timer2.stop();
            if (doShuffle) {
                Timer timer3 = new Timer().start();
                list.shuffle();
                System.out.println("shuffling took ");
                timer3.stop().display();
            }
            timer.start();
            approxFinder.addAllOf(list);
            timer.stop();
            if (!computeExactQuantilesAlso) continue;
            exactFinder.addAllOf(list);
        }
        System.out.println("list.add() took" + timer2);
        System.out.println("approxFinder.add() took" + timer);
        timer.reset().start();
        DoubleArrayList approxQuantiles = approxFinder.quantileElements(new DoubleArrayList(phis));
        timer.stop().display();
        System.out.println("Phis=" + new DoubleArrayList(phis));
        System.out.println("ApproxQuantiles=" + approxQuantiles);
        if (computeExactQuantilesAlso) {
            System.out.println("Comparing with exact quantile computation...");
            timer.reset().start();
            DoubleArrayList exactQuantiles = exactFinder.quantileElements(new DoubleArrayList(phis));
            timer.stop().display();
            System.out.println("ExactQuantiles=" + exactQuantiles);
            DoubleArrayList observedEpsilons = QuantileFinderTest.observedEpsilonsAtPhis(new DoubleArrayList(phis), (ExactDoubleQuantileFinder)exactFinder, approxFinder, epsilon);
            System.out.println("observedEpsilons=" + observedEpsilons);
            double element = 1000.0;
            System.out.println("exact phi(" + element + ")=" + exactFinder.phi(element));
            System.out.println("apprx phi(" + element + ")=" + approxFinder.phi(element));
            System.out.println("exact elem(phi(" + element + "))=" + exactFinder.quantileElements(new DoubleArrayList(new double[]{exactFinder.phi(element)})));
            System.out.println("apprx elem(phi(" + element + "))=" + approxFinder.quantileElements(new DoubleArrayList(new double[]{approxFinder.phi(element)})));
        }
    }

    public static void testRank() {
        DoubleArrayList list = new DoubleArrayList(new double[]{1.0, 5.0, 5.0, 5.0, 7.0, 10.0});
    }
}

