/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer;

import cern.colt.PersistentObject;
import cern.colt.buffer.ObjectBufferConsumer;
import cern.colt.list.ObjectArrayList;

public class ObjectBuffer
extends PersistentObject
implements ObjectBufferConsumer {
    protected ObjectBufferConsumer target;
    protected Object[] elements;
    protected ObjectArrayList list;
    protected int capacity;
    protected int size;

    public ObjectBuffer(ObjectBufferConsumer target, int capacity) {
        this.target = target;
        this.capacity = capacity;
        this.elements = new Object[capacity];
        this.list = new ObjectArrayList(this.elements);
        this.size = 0;
    }

    public void add(Object element) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.elements[this.size++] = element;
    }

    @Override
    public void addAllOf(ObjectArrayList list) {
        int listSize = list.size();
        if (this.size + listSize >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(list);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.list.setSize(this.size);
            this.target.addAllOf(this.list);
            this.size = 0;
        }
    }
}

