/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.ganglia;

import com.bigdata.ganglia.xdr.XDROutputBuffer;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;

public class GangliaSender {
    private final InetSocketAddress[] metricsServers;
    protected final XDROutputBuffer xdr;
    private final DatagramSocket datagramSocket;

    public GangliaSender(InetSocketAddress[] metricServers, int bufferSize) throws SocketException {
        if (metricServers == null) {
            throw new IllegalArgumentException();
        }
        this.metricsServers = metricServers;
        this.xdr = new XDROutputBuffer(bufferSize);
        this.datagramSocket = new DatagramSocket();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void close() {
        if (this.datagramSocket != null) {
            this.datagramSocket.close();
        }
    }

    public void sendMessage(XDROutputBuffer xdr) throws IOException {
        for (InetSocketAddress socketAddress : this.metricsServers) {
            DatagramPacket packet = new DatagramPacket(xdr.getBuffer(), xdr.getLength(), socketAddress);
            this.datagramSocket.send(packet);
        }
    }
}

