/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf.datastore;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.rdf4j.common.io.NioFile;

public class IDFile
implements Closeable {
    private static final byte[] MAGIC_NUMBER = new byte[]{110, 105, 102};
    private static final byte FILE_FORMAT_VERSION = 1;
    private static final long HEADER_LENGTH = 8L;
    private static final long ITEM_SIZE = 8L;
    private final NioFile nioFile;
    private final boolean forceSync;

    public IDFile(File file) throws IOException {
        this(file, false);
    }

    public IDFile(File file, boolean forceSync) throws IOException {
        this.nioFile = new NioFile(file);
        this.forceSync = forceSync;
        try {
            if (this.nioFile.size() == 0L) {
                this.nioFile.writeBytes(MAGIC_NUMBER, 0L);
                this.nioFile.writeByte((byte)1, 3L);
                this.nioFile.writeBytes(new byte[]{0, 0, 0, 0}, 4L);
                this.sync();
            } else {
                if (this.nioFile.size() < 8L) {
                    throw new IOException("File too small to be a compatible ID file");
                }
                if (!Arrays.equals(MAGIC_NUMBER, this.nioFile.readBytes(0L, MAGIC_NUMBER.length))) {
                    throw new IOException("File doesn't contain compatible ID records");
                }
                byte version = this.nioFile.readByte((long)MAGIC_NUMBER.length);
                if (version > 1) {
                    throw new IOException("Unable to read ID file; it uses a newer file format");
                }
                if (version != 1) {
                    throw new IOException("Unable to read ID file; invalid file format version: " + version);
                }
            }
        }
        catch (IOException e) {
            this.nioFile.close();
            throw e;
        }
    }

    public final File getFile() {
        return this.nioFile.getFile();
    }

    public int getMaxID() throws IOException {
        return (int)(this.nioFile.size() / 8L) - 1;
    }

    public int storeOffset(long offset) throws IOException {
        long fileSize = this.nioFile.size();
        this.nioFile.writeLong(offset, fileSize);
        return (int)(fileSize / 8L);
    }

    public void setOffset(int id, long offset) throws IOException {
        assert (id > 0) : "id must be larger than 0, is: " + id;
        this.nioFile.writeLong(offset, 8L * (long)id);
    }

    public long getOffset(int id) throws IOException {
        assert (id > 0) : "id must be larger than 0, is: " + id;
        return this.nioFile.readLong(8L * (long)id);
    }

    public void clear() throws IOException {
        this.nioFile.truncate(8L);
    }

    public void sync() throws IOException {
        if (this.forceSync) {
            this.nioFile.force(false);
        }
    }

    @Override
    public void close() throws IOException {
        this.nioFile.close();
    }
}

