/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jooq.Binding;
import org.jooq.CharacterSet;
import org.jooq.Collation;
import org.jooq.Comment;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Converter;
import org.jooq.DataType;
import org.jooq.Domain;
import org.jooq.EmbeddableRecord;
import org.jooq.EnumType;
import org.jooq.Field;
import org.jooq.JSON;
import org.jooq.JSONB;
import org.jooq.Name;
import org.jooq.Nullability;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.UDTRecord;
import org.jooq.XML;
import org.jooq.impl.AbstractNamed;
import org.jooq.impl.ArrayDataType;
import org.jooq.impl.ConvertedDataType;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultBinding;
import org.jooq.impl.DefaultDataType;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.tools.Convert;
import org.jooq.types.Interval;
import org.jooq.types.UNumber;

abstract class AbstractDataType<T>
extends AbstractNamed
implements DataType<T> {
    private static final long serialVersionUID = 4155588654449505119L;
    private static final Set<SQLDialect> NO_SUPPORT_TIMESTAMP_PRECISION = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD);

    AbstractDataType(Name name, Comment comment) {
        super(name, comment);
    }

    abstract AbstractDataType<T> construct(Integer var1, Integer var2, Integer var3, Nullability var4, Collation var5, CharacterSet var6, boolean var7, Field<T> var8);

    @Override
    public final DataType<T> nullability(Nullability n) {
        return this.construct(this.precision0(), this.scale0(), this.length0(), n, this.collation(), this.characterSet(), n.nullable() ? false : this.identity(), this.defaultValue());
    }

    @Override
    public final DataType<T> nullable(boolean n) {
        return this.nullability(Nullability.of(n));
    }

    @Override
    public final boolean nullable() {
        return this.nullability().nullable();
    }

    @Override
    public final DataType<T> collation(Collation c) {
        return this.construct(this.precision0(), this.scale0(), this.length0(), this.nullability(), c, this.characterSet(), this.identity(), this.defaultValue());
    }

    @Override
    public final DataType<T> characterSet(CharacterSet c) {
        return this.construct(this.precision0(), this.scale0(), this.length0(), this.nullability(), this.collation(), c, this.identity(), this.defaultValue());
    }

    @Override
    public final DataType<T> identity(boolean i) {
        return this.construct(this.precision0(), this.scale0(), this.length0(), i ? Nullability.NOT_NULL : this.nullability(), this.collation(), this.characterSet(), i, this.defaultValue());
    }

    @Override
    public final DataType<T> defaultValue(T d) {
        return this.default_(d);
    }

    @Override
    public final DataType<T> defaultValue(Field<T> d) {
        return this.default_(d);
    }

    @Override
    public final Field<T> defaultValue() {
        return this.default_();
    }

    @Override
    public final DataType<T> default_(T d) {
        return this.default_(Tools.field(d, this));
    }

    @Override
    public final DataType<T> default_(Field<T> d) {
        return this.construct(this.precision0(), this.scale0(), this.length0(), this.nullability(), this.collation(), this.characterSet(), this.identity(), d);
    }

    @Override
    @Deprecated
    public final DataType<T> defaulted(boolean d) {
        return this.defaultValue(d ? Tools.field(null, this) : null);
    }

    @Override
    public final boolean defaulted() {
        return this.defaultValue() != null;
    }

    @Override
    public final int precision() {
        Integer precision = this.precision0();
        return precision == null ? 0 : precision;
    }

    @Override
    public final DataType<T> precision(int p) {
        return this.precision0(p, this.scale());
    }

    @Override
    public final DataType<T> precision(int p, int s) {
        return this.precision0(p, s);
    }

    final AbstractDataType<T> precision0(Integer p, Integer s) {
        if (AbstractDataType.eq(this.precision0(), p) && AbstractDataType.eq(this.scale0(), s)) {
            return this;
        }
        if (this.isLob()) {
            return this;
        }
        return this.construct(p, s, this.length0(), this.nullability(), this.collation(), this.characterSet(), this.identity(), this.defaultValue());
    }

    @Override
    public final boolean hasPrecision() {
        Class<?> tType = this.tType0();
        return tType == BigInteger.class || tType == BigDecimal.class || tType == Timestamp.class || tType == Time.class || tType == LocalDateTime.class || tType == LocalTime.class || tType == OffsetDateTime.class || tType == OffsetTime.class || tType == Instant.class;
    }

    @Override
    public final boolean precisionDefined() {
        return this.precision0() != null && this.hasPrecision();
    }

    @Override
    public final int scale() {
        Integer scale = this.scale0();
        return scale == null ? 0 : scale;
    }

    @Override
    public final DataType<T> scale(int s) {
        return this.scale0(s);
    }

    final AbstractDataType<T> scale0(Integer s) {
        if (AbstractDataType.eq(this.scale0(), s)) {
            return this;
        }
        if (this.isLob()) {
            return this;
        }
        return this.construct(this.precision0(), s, this.length0(), this.nullability(), this.collation(), this.characterSet(), this.identity(), this.defaultValue());
    }

    @Override
    public final boolean hasScale() {
        return this.tType0() == BigDecimal.class;
    }

    @Override
    public final boolean scaleDefined() {
        return this.scale0() != null && this.hasScale();
    }

    @Override
    public final DataType<T> length(int l) {
        return this.length0(l);
    }

    final AbstractDataType<T> length0(Integer l) {
        if (AbstractDataType.eq(this.length0(), l)) {
            return this;
        }
        if (this.isLob()) {
            return this;
        }
        return this.construct(this.precision0(), this.scale0(), l, this.nullability(), this.collation(), this.characterSet(), this.identity(), this.defaultValue());
    }

    @Override
    public final int length() {
        Integer length = this.length0();
        return length == null ? 0 : length;
    }

    @Override
    public final boolean hasLength() {
        Class<?> tType = this.tType0();
        return (tType == byte[].class || tType == String.class) && !this.isLob();
    }

    @Override
    public final boolean lengthDefined() {
        return this.length0() != null && this.hasLength();
    }

    @Override
    public int getSQLType() {
        return this.getSQLType(DSL.using(this.getDialect()).configuration());
    }

    @Override
    public final int getSQLType(Configuration configuration) {
        Class<?> tType = this.tType0();
        if (tType == Blob.class) {
            return 2004;
        }
        if (tType == Boolean.class) {
            return 16;
        }
        if (tType == BigInteger.class) {
            return -5;
        }
        if (tType == BigDecimal.class) {
            return 3;
        }
        if (tType == Byte.class) {
            return -6;
        }
        if (tType == byte[].class) {
            return 2004;
        }
        if (tType == Clob.class) {
            return 2005;
        }
        if (Tools.isDate(tType)) {
            switch (configuration.family()) {
                default: 
            }
            return 91;
        }
        if (tType == Double.class) {
            return 8;
        }
        if (tType == Float.class) {
            return 6;
        }
        if (tType == Integer.class) {
            return 4;
        }
        if (tType == Long.class) {
            return -5;
        }
        if (tType == Short.class) {
            return 5;
        }
        if (tType == String.class) {
            return 12;
        }
        if (Tools.isTime(tType)) {
            return 92;
        }
        if (Tools.isTimestamp(tType)) {
            return 93;
        }
        if (tType == OffsetTime.class) {
            return 12;
        }
        if (tType == OffsetDateTime.class) {
            return 12;
        }
        if (tType == Instant.class) {
            return 12;
        }
        if (tType.isArray()) {
            return 2003;
        }
        if (EnumType.class.isAssignableFrom(tType)) {
            return 12;
        }
        if (UDTRecord.class.isAssignableFrom(tType)) {
            return 2002;
        }
        if (Result.class.isAssignableFrom(tType)) {
            switch (configuration.family()) {
                case H2: {
                    return -10;
                }
            }
            return 1111;
        }
        return 1111;
    }

    @Override
    public Domain<T> getDomain() {
        return null;
    }

    @Override
    public final Converter<?, T> getConverter() {
        return this.getBinding().converter();
    }

    @Override
    public final String getTypeName() {
        return this.typeName0();
    }

    @Override
    public String getTypeName(Configuration configuration) {
        return this.getDataType(configuration).getTypeName();
    }

    @Override
    public final String getCastTypeName() {
        return this.getCastTypeName0(SQLDialect.DEFAULT);
    }

    private String getCastTypeName0(SQLDialect dialect) {
        if (this.lengthDefined() && this.length() > 0) {
            return this.castTypePrefix0() + "(" + this.length() + ")" + this.castTypeSuffix0();
        }
        if (this.precisionDefined() && (this.isTimestamp() || this.precision() > 0)) {
            if (this.isTimestamp() && NO_SUPPORT_TIMESTAMP_PRECISION.contains((Object)dialect)) {
                return this.castTypePrefix0() + this.castTypeSuffix0();
            }
            if (this.scaleDefined() && this.scale() > 0) {
                return this.castTypePrefix0() + "(" + this.precision() + ", " + this.scale() + ")" + this.castTypeSuffix0();
            }
            return this.castTypePrefix0() + "(" + this.precision() + ")" + this.castTypeSuffix0();
        }
        return this.castTypeName0();
    }

    @Override
    public String getCastTypeName(Configuration configuration) {
        return ((AbstractDataType)this.getDataType(configuration)).getCastTypeName0(configuration.dialect());
    }

    @Override
    public final Class<T[]> getArrayType() {
        return Array.newInstance(this.getType(), 0).getClass();
    }

    @Override
    public final DataType<T[]> getArrayDataType() {
        return new ArrayDataType(this);
    }

    @Override
    public Class<?> getArrayComponentType() {
        return null;
    }

    @Override
    public DataType<?> getArrayComponentDataType() {
        return null;
    }

    @Override
    public final <E extends EnumType> DataType<E> asEnumDataType(Class<E> enumDataType) {
        String enumTypeName = Tools.enums(enumDataType)[0].getName();
        return new DefaultDataType<E>(this.getDialect(), (DataType)null, enumDataType, DSL.unquotedName(enumTypeName), enumTypeName, enumTypeName, this.precision0(), this.scale0(), this.length0(), this.nullability(), this.defaultValue());
    }

    @Override
    public <U> DataType<U> asConvertedDataType(Converter<? super T, U> converter) {
        return this.asConvertedDataType(DefaultBinding.newBinding(converter, this, null));
    }

    @Override
    public <U> DataType<U> asConvertedDataType(Binding<? super T, U> newBinding) {
        if (this.getBinding() == newBinding) {
            return this;
        }
        if (newBinding == null) {
            newBinding = DefaultBinding.binding(this);
        }
        return new ConvertedDataType<T, U>(this, newBinding);
    }

    @Override
    public T convert(Object object) {
        if (object == null) {
            return null;
        }
        if (object.getClass() == this.getType()) {
            return (T)object;
        }
        return Convert.convert(object, this.getType());
    }

    @Override
    public final T[] convert(Object ... objects) {
        return Convert.convertArray(objects, this.getConverter());
    }

    @Override
    public final List<T> convert(Collection<?> objects) {
        return Convert.convert(objects, this.getConverter());
    }

    @Override
    public final boolean isNumeric() {
        return Number.class.isAssignableFrom(this.tType0()) && !this.isInterval();
    }

    @Override
    public final boolean isInteger() {
        Class<?> tType = this.tType0();
        return UNumber.class.isAssignableFrom(tType) || Byte.class == tType || Short.class == tType || Integer.class == tType || Long.class == tType;
    }

    @Override
    public final boolean isString() {
        return this.tType0() == String.class;
    }

    @Override
    public final boolean isNString() {
        DataType t = this.getSQLDataType();
        return t == SQLDataType.NCHAR || t == SQLDataType.NCLOB || t == SQLDataType.NVARCHAR || SQLDataType.NCHAR == null && "nchar".equals(t.getTypeName()) || SQLDataType.NCLOB == null && "nclob".equals(t.getTypeName()) || SQLDataType.NVARCHAR == null && "nvarchar".equals(t.getTypeName());
    }

    @Override
    public final boolean isDateTime() {
        Class<?> tType = this.tType0();
        return java.util.Date.class.isAssignableFrom(tType) || Temporal.class.isAssignableFrom(tType);
    }

    @Override
    public final boolean isDate() {
        Class<?> tType = this.tType0();
        return Date.class.isAssignableFrom(tType) || LocalDate.class.isAssignableFrom(tType);
    }

    @Override
    public final boolean isTimestamp() {
        Class<?> tType = this.tType0();
        return Timestamp.class.isAssignableFrom(tType) || LocalDateTime.class.isAssignableFrom(tType);
    }

    @Override
    public final boolean isTime() {
        Class<?> tType = this.tType0();
        return Time.class.isAssignableFrom(tType) || LocalTime.class.isAssignableFrom(tType);
    }

    @Override
    public final boolean isTemporal() {
        return this.isDateTime() || this.isInterval();
    }

    @Override
    public final boolean isInterval() {
        return Interval.class.isAssignableFrom(this.tType0());
    }

    @Override
    public final boolean isLob() {
        DataType t = this.getSQLDataType();
        if (t == this) {
            return this.getTypeName().endsWith("lob");
        }
        return t == SQLDataType.BLOB || t == SQLDataType.CLOB || t == SQLDataType.NCLOB || SQLDataType.BLOB == null && "blob".equals(t.getTypeName()) || SQLDataType.CLOB == null && "clob".equals(t.getTypeName()) || SQLDataType.NCLOB == null && "nclob".equals(t.getTypeName());
    }

    @Override
    public final boolean isBinary() {
        return this.tType0() == byte[].class;
    }

    @Override
    public final boolean isArray() {
        Class<?> tType = this.tType0();
        return !this.isBinary() && tType.isArray();
    }

    @Override
    public final boolean isEmbeddable() {
        return EmbeddableRecord.class.isAssignableFrom(this.tType0());
    }

    @Override
    public final boolean isUDT() {
        return UDTRecord.class.isAssignableFrom(this.tType0());
    }

    @Override
    public final boolean isEnum() {
        return EnumType.class.isAssignableFrom(this.tType0());
    }

    @Override
    public final boolean isJSON() {
        Class<?> tType = this.tType0();
        return tType == JSON.class || tType == JSONB.class;
    }

    @Override
    public final boolean isXML() {
        return this.tType0() == XML.class;
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.visit(this.getQualifiedName());
    }

    private static final boolean eq(Integer i1, Integer i2) {
        return i1 == i2 || i1 != null && i2 != null && i1.intValue() == i2.intValue();
    }

    abstract String typeName0();

    abstract String castTypePrefix0();

    abstract String castTypeSuffix0();

    abstract String castTypeName0();

    abstract Class<?> tType0();

    abstract Integer precision0();

    abstract Integer scale0();

    abstract Integer length0();

    @Override
    public String toString() {
        return this.getCastTypeName() + (this.isArray() ? " array" : "") + " /* " + this.getType().getName() + " */";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getDialect() == null ? 0 : this.getDialect().hashCode());
        result = 31 * result + this.length();
        result = 31 * result + this.precision();
        result = 31 * result + this.scale();
        result = 31 * result + (this.getType() == null ? 0 : this.getType().hashCode());
        result = 31 * result + (this.tType0() == null ? 0 : this.tType0().hashCode());
        result = 31 * result + (this.typeName0() == null ? 0 : this.typeName0().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractDataType)) {
            return false;
        }
        AbstractDataType other = (AbstractDataType)obj;
        if (this.getDialect() != other.getDialect()) {
            return false;
        }
        if (!AbstractDataType.eq(this.length0(), other.length0())) {
            return false;
        }
        if (!AbstractDataType.eq(this.precision0(), other.precision0())) {
            return false;
        }
        if (!AbstractDataType.eq(this.scale0(), other.scale0())) {
            return false;
        }
        if (this.getType() == null ? other.getType() != null : !this.getType().equals(other.getType())) {
            return false;
        }
        if (this.tType0() == null ? other.tType0() != null : !this.tType0().equals(other.tType0())) {
            return false;
        }
        return !(this.typeName0() == null ? other.typeName0() != null : !this.typeName0().equals(other.typeName0()));
    }
}

