/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.ints.AbstractInt2ReferenceMap;
import it.unimi.dsi.fastutil.ints.AbstractIntSet;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.AbstractReferenceCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;

public class Int2ReferenceOpenHashMap<V>
extends AbstractInt2ReferenceMap<V>
implements Serializable,
Cloneable,
Hash {
    private static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient int[] key;
    protected transient V[] value;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected volatile transient Int2ReferenceMap.FastEntrySet<V> entries;
    protected volatile transient IntSet keys;
    protected volatile transient ReferenceCollection<V> values;

    public Int2ReferenceOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new int[this.n];
        this.value = new Object[this.n];
        this.used = new boolean[this.n];
    }

    public Int2ReferenceOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Int2ReferenceOpenHashMap() {
        this(16, 0.75f);
    }

    public Int2ReferenceOpenHashMap(Map<? extends Integer, ? extends V> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Int2ReferenceOpenHashMap(Map<? extends Integer, ? extends V> m) {
        this(m, 0.75f);
    }

    public Int2ReferenceOpenHashMap(Int2ReferenceMap<V> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Int2ReferenceOpenHashMap(Int2ReferenceMap<V> m) {
        this(m, 0.75f);
    }

    public Int2ReferenceOpenHashMap(int[] k, V[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Int2ReferenceOpenHashMap(int[] k, V[] v) {
        this(k, v, 0.75f);
    }

    @Override
    public V put(int k, V v) {
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                V oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return (V)this.defRetValue;
    }

    @Override
    public V put(Integer ok, V ov) {
        V v = ov;
        int k = ok;
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                V oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size++ >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return (V)this.defRetValue;
    }

    protected final int shiftKeys(int pos) {
        int last;
        while (true) {
            last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = HashCommon.murmurHash3(this.key[pos] ^ this.mask) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
            this.value[last] = this.value[pos];
        }
        this.used[last] = false;
        this.value[last] = null;
        return last;
    }

    @Override
    public V remove(int k) {
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                --this.size;
                V v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return (V)this.defRetValue;
    }

    @Override
    public V remove(Object ok) {
        int k = (Integer)ok;
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                --this.size;
                V v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return (V)this.defRetValue;
    }

    public V get(Integer ok) {
        int k = ok;
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return (V)this.defRetValue;
    }

    @Override
    public V get(int k) {
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return (V)this.defRetValue;
    }

    @Override
    public boolean containsKey(int k) {
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object v) {
        V[] value = this.value;
        boolean[] used = this.used;
        int i = this.n;
        while (i-- != 0) {
            if (!used[i] || value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        Arrays.fill(this.used, false);
        Arrays.fill(this.value, null);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    public Int2ReferenceMap.FastEntrySet<V> int2ReferenceEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public IntSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public ReferenceCollection<V> values() {
        if (this.values == null) {
            this.values = new AbstractReferenceCollection<V>(){

                @Override
                public ObjectIterator<V> iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return Int2ReferenceOpenHashMap.this.size;
                }

                @Override
                public boolean contains(Object v) {
                    return Int2ReferenceOpenHashMap.this.containsValue(v);
                }

                @Override
                public void clear() {
                    Int2ReferenceOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i = 0;
        boolean[] used = this.used;
        int[] key = this.key;
        V[] value = this.value;
        int mask = newN - 1;
        int[] newKey = new int[newN];
        Object[] newValue = new Object[newN];
        boolean[] newUsed = new boolean[newN];
        int j = this.size;
        while (j-- != 0) {
            while (!used[i]) {
                ++i;
            }
            int k = key[i];
            int pos = HashCommon.murmurHash3(k ^ mask) & mask;
            while (newUsed[pos]) {
                pos = pos + 1 & mask;
            }
            newUsed[pos] = true;
            newKey[pos] = k;
            newValue[pos] = value[i];
            ++i;
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
        this.used = newUsed;
    }

    public Int2ReferenceOpenHashMap<V> clone() {
        Int2ReferenceOpenHashMap c;
        try {
            c = (Int2ReferenceOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (int[])this.key.clone();
        c.value = (Object[])this.value.clone();
        c.used = (boolean[])this.used.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int j = this.size;
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (!this.used[i]) {
                ++i;
            }
            t = this.key[i];
            if (this != this.value[i]) {
                t ^= this.value[i] == null ? 0 : System.identityHashCode(this.value[i]);
            }
            h += t;
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int[] key = this.key;
        V[] value = this.value;
        MapIterator i = new MapIterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeInt(key[e]);
            s.writeObject(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new int[this.n];
        int[] key = this.key;
        this.value = new Object[this.n];
        Object[] value = this.value;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            int k = s.readInt();
            Object v = s.readObject();
            pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k;
            value[pos] = v;
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements ObjectIterator<V> {
        @Override
        public V next() {
            return Int2ReferenceOpenHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractIntSet {
        private KeySet() {
        }

        @Override
        public IntIterator iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return Int2ReferenceOpenHashMap.this.size;
        }

        @Override
        public boolean contains(int k) {
            return Int2ReferenceOpenHashMap.this.containsKey(k);
        }

        @Override
        public boolean remove(int k) {
            int oldSize = Int2ReferenceOpenHashMap.this.size;
            Int2ReferenceOpenHashMap.this.remove(k);
            return Int2ReferenceOpenHashMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            Int2ReferenceOpenHashMap.this.clear();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements IntIterator {
        @Override
        public int nextInt() {
            return Int2ReferenceOpenHashMap.this.key[this.nextEntry()];
        }

        @Override
        public Integer next() {
            return Int2ReferenceOpenHashMap.this.key[this.nextEntry()];
        }
    }

    private final class MapEntrySet
    extends AbstractObjectSet<Int2ReferenceMap.Entry<V>>
    implements Int2ReferenceMap.FastEntrySet<V> {
        private MapEntrySet() {
        }

        @Override
        public ObjectIterator<Int2ReferenceMap.Entry<V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public ObjectIterator<Int2ReferenceMap.Entry<V>> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            int k = (Integer)e.getKey();
            int pos = HashCommon.murmurHash3(k ^ Int2ReferenceOpenHashMap.this.mask) & Int2ReferenceOpenHashMap.this.mask;
            while (Int2ReferenceOpenHashMap.this.used[pos]) {
                if (Int2ReferenceOpenHashMap.this.key[pos] == k) {
                    return Int2ReferenceOpenHashMap.this.value[pos] == e.getValue();
                }
                pos = pos + 1 & Int2ReferenceOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            int k = (Integer)e.getKey();
            int pos = HashCommon.murmurHash3(k ^ Int2ReferenceOpenHashMap.this.mask) & Int2ReferenceOpenHashMap.this.mask;
            while (Int2ReferenceOpenHashMap.this.used[pos]) {
                if (Int2ReferenceOpenHashMap.this.key[pos] == k) {
                    Int2ReferenceOpenHashMap.this.remove(e.getKey());
                    return true;
                }
                pos = pos + 1 & Int2ReferenceOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public int size() {
            return Int2ReferenceOpenHashMap.this.size;
        }

        @Override
        public void clear() {
            Int2ReferenceOpenHashMap.this.clear();
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectIterator<Int2ReferenceMap.Entry<V>> {
        final AbstractInt2ReferenceMap.BasicEntry<V> entry;

        private FastEntryIterator() {
            this.entry = new AbstractInt2ReferenceMap.BasicEntry<Object>(0, null);
        }

        @Override
        public AbstractInt2ReferenceMap.BasicEntry<V> next() {
            int e = this.nextEntry();
            this.entry.key = Int2ReferenceOpenHashMap.this.key[e];
            this.entry.value = Int2ReferenceOpenHashMap.this.value[e];
            return this.entry;
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectIterator<Int2ReferenceMap.Entry<V>> {
        private MapEntry entry;

        private EntryIterator() {
        }

        @Override
        public Int2ReferenceMap.Entry<V> next() {
            this.entry = new MapEntry(this.nextEntry());
            return this.entry;
        }

        @Override
        public void remove() {
            super.remove();
            this.entry.index = -1;
        }
    }

    private class MapIterator {
        int pos;
        int last;
        int c;
        IntArrayList wrapped;

        private MapIterator() {
            this.pos = Int2ReferenceOpenHashMap.this.n;
            this.last = -1;
            this.c = Int2ReferenceOpenHashMap.this.size;
            boolean[] used = Int2ReferenceOpenHashMap.this.used;
            if (this.c != 0) {
                while (!used[--this.pos]) {
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.c;
            if (this.pos < 0) {
                this.last = --this.pos;
                int k = this.wrapped.getInt(-this.pos - 2);
                int pos = HashCommon.murmurHash3(k ^ Int2ReferenceOpenHashMap.this.mask) & Int2ReferenceOpenHashMap.this.mask;
                while (Int2ReferenceOpenHashMap.this.used[pos]) {
                    if (Int2ReferenceOpenHashMap.this.key[pos] == k) {
                        return pos;
                    }
                    pos = pos + 1 & Int2ReferenceOpenHashMap.this.mask;
                }
            }
            this.last = this.pos;
            if (this.c != 0) {
                boolean[] used = Int2ReferenceOpenHashMap.this.used;
                while (this.pos-- != 0 && !used[this.pos]) {
                }
            }
            return this.last;
        }

        protected final int shiftKeys(int pos) {
            int last;
            while (true) {
                last = pos;
                pos = last + 1 & Int2ReferenceOpenHashMap.this.mask;
                while (Int2ReferenceOpenHashMap.this.used[pos]) {
                    int slot = HashCommon.murmurHash3(Int2ReferenceOpenHashMap.this.key[pos] ^ Int2ReferenceOpenHashMap.this.mask) & Int2ReferenceOpenHashMap.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1 & Int2ReferenceOpenHashMap.this.mask;
                }
                if (!Int2ReferenceOpenHashMap.this.used[pos]) break;
                if (pos < last) {
                    if (this.wrapped == null) {
                        this.wrapped = new IntArrayList();
                    }
                    this.wrapped.add(Int2ReferenceOpenHashMap.this.key[pos]);
                }
                Int2ReferenceOpenHashMap.this.key[last] = Int2ReferenceOpenHashMap.this.key[pos];
                Int2ReferenceOpenHashMap.this.value[last] = Int2ReferenceOpenHashMap.this.value[pos];
            }
            Int2ReferenceOpenHashMap.this.used[last] = false;
            Int2ReferenceOpenHashMap.this.value[last] = null;
            return last;
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            if (this.pos < -1) {
                Int2ReferenceOpenHashMap.this.remove(this.wrapped.getInt(-this.pos - 2));
                this.last = -1;
                return;
            }
            --Int2ReferenceOpenHashMap.this.size;
            if (this.shiftKeys(this.last) == this.pos && this.c > 0) {
                ++this.c;
                this.nextEntry();
            }
            this.last = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }
    }

    private final class MapEntry
    implements Int2ReferenceMap.Entry<V>,
    Map.Entry<Integer, V> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Integer getKey() {
            return Int2ReferenceOpenHashMap.this.key[this.index];
        }

        @Override
        public int getIntKey() {
            return Int2ReferenceOpenHashMap.this.key[this.index];
        }

        @Override
        public V getValue() {
            return Int2ReferenceOpenHashMap.this.value[this.index];
        }

        @Override
        public V setValue(V v) {
            Object oldValue = Int2ReferenceOpenHashMap.this.value[this.index];
            Int2ReferenceOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Int2ReferenceOpenHashMap.this.key[this.index] == (Integer)e.getKey() && Int2ReferenceOpenHashMap.this.value[this.index] == e.getValue();
        }

        @Override
        public int hashCode() {
            return Int2ReferenceOpenHashMap.this.key[this.index] ^ (Int2ReferenceOpenHashMap.this.value[this.index] == null ? 0 : System.identityHashCode(Int2ReferenceOpenHashMap.this.value[this.index]));
        }

        public String toString() {
            return Int2ReferenceOpenHashMap.this.key[this.index] + "=>" + Int2ReferenceOpenHashMap.this.value[this.index];
        }
    }
}

